/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.PrivateKeyReader;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.security.CompositeX509TrustManager;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SslSocketFactory
extends SSLSocketFactory {
    public static final String SSL_CA_CERT_PATH = "sslCaCertPath";
    public static final String SSL_CLIENT_CERT_PATH = "sslClientCertPath";
    public static final String SSL_CLIENT_KEY_PATH = "sslClientKeyPath";
    public static final String SSL_TRUST_EVERYBODY = "sslTrustEverybody";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private final SSLSocketFactory myFactory;

    public SslSocketFactory() throws GeneralSecurityException, IOException {
        KeyManager[] kms;
        TrustManager[] tms;
        SSLContext ctx = SSLContext.getInstance("TLS");
        try {
            KeyManager[] keyManagerArray;
            TrustManager[] trustManagerArray;
            String caCertPath = System.getProperty(SSL_CA_CERT_PATH);
            String clientCertPath = System.getProperty(SSL_CLIENT_CERT_PATH);
            String clientKeyPath = System.getProperty(SSL_CLIENT_KEY_PATH);
            boolean trustEverybody = Boolean.parseBoolean(System.getProperty(SSL_TRUST_EVERYBODY));
            if (trustEverybody) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = new MyTrustEverybodyManager();
            } else {
                trustManagerArray = tms = caCertPath == null ? new TrustManager[]{} : SslSocketFactory.createTrustManagers(caCertPath);
            }
            if (clientCertPath != null && clientKeyPath != null) {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = new MyKeyManager(clientCertPath, clientKeyPath);
            } else {
                keyManagerArray = new KeyManager[]{};
            }
            kms = keyManagerArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctx.init(kms, tms, null);
        this.myFactory = ctx.getSocketFactory();
    }

    @NotNull
    public static TrustManager[] createTrustManagers(@NotNull String caCertPath) throws Exception {
        String string = FileUtilRt.loadFile(new File(caCertPath));
        String[] tokens = string.split(END_CERTIFICATE);
        ArrayList<TrustManager> result = ContainerUtilRt.newArrayListWithCapacity(tokens.length);
        for (String token : tokens) {
            if (token == null || token.trim().length() == 0) continue;
            result.add(new MyTrustManager(SslSocketFactory.readCertificate(SslSocketFactory.stringStream(token + END_CERTIFICATE))));
        }
        return new TrustManager[]{new CompositeX509TrustManager(new TrustManager[][]{result.toArray(new TrustManager[0])})};
    }

    @NotNull
    public static InputStream stringStream(@NotNull String str) {
        try {
            return new ByteArrayInputStream(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.myFactory.createSocket(host, port);
    }

    @NotNull
    public Socket createSocket(String host, int port) throws IOException {
        return this.myFactory.createSocket(host, port);
    }

    @NotNull
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.myFactory.createSocket(host, port, localHost, localPort);
    }

    @NotNull
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.myFactory.createSocket(address, port, localAddress, localPort);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.myFactory.createSocket(socket, host, port, autoClose);
    }

    @NotNull
    public String[] getDefaultCipherSuites() {
        return this.myFactory.getDefaultCipherSuites();
    }

    @NotNull
    public String[] getSupportedCipherSuites() {
        return this.myFactory.getSupportedCipherSuites();
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull String filePath) throws CertificateException, IOException {
        return SslSocketFactory.readCertificate(new FileInputStream(filePath));
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull InputStream stream) throws CertificateException, IOException {
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(stream);
        stream.close();
        return certificate;
    }

    @NotNull
    public static PrivateKey readPrivateKey(@NotNull String filePath) throws IOException {
        return new PrivateKeyReader(filePath).getPrivateKey();
    }

    private static class MyKeyManager
    extends X509ExtendedKeyManager {
        private final String myAlias = UUID.randomUUID().toString();
        @NotNull
        private final X509Certificate[] myCertificates;
        @NotNull
        private final PrivateKey myPrivateKey;

        private MyKeyManager(@NotNull String certPath, @NotNull String keyPath) throws Exception {
            this.myCertificates = new X509Certificate[]{SslSocketFactory.readCertificate(certPath)};
            this.myPrivateKey = SslSocketFactory.readPrivateKey(keyPath);
        }

        @NotNull
        public String[] getClientAliases(String s, Principal[] principals) {
            return new String[0];
        }

        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return this.myAlias;
        }

        @NotNull
        public String[] getServerAliases(String s, Principal[] principals) {
            return new String[0];
        }

        @Nullable
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return null;
        }

        @NotNull
        public X509Certificate[] getCertificateChain(String s) {
            return this.myCertificates;
        }

        @NotNull
        public PrivateKey getPrivateKey(String s) {
            return this.myPrivateKey;
        }
    }

    private static class MyTrustEverybodyManager
    implements X509TrustManager {
        private MyTrustEverybodyManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class MyTrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;

        private MyTrustManager(@NotNull X509Certificate caCertPath) throws Exception {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(MyTrustManager.createStore(caCertPath));
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                this.trustManager = (X509TrustManager)tm;
                break;
            }
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
        }

        @NotNull
        private static KeyStore createStore(@NotNull X509Certificate certificate) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry(UUID.randomUUID().toString(), certificate);
            return ks;
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }

        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

