/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class WeaklyReferencedDisposable
extends WeakReference<Disposable>
implements Disposable {
    private static final ReferenceQueue<Disposable> ourRefQueue = new ReferenceQueue();

    public WeaklyReferencedDisposable(@NotNull Disposable disposable) {
        super(disposable, ourRefQueue);
        WeaklyReferencedDisposable.reapCollectedRefs();
    }

    @Override
    public void dispose() {
        Disposable disposable = (Disposable)this.get();
        if (disposable == null) {
            return;
        }
        this.clear();
        Disposer.dispose(disposable);
    }

    private static void reapCollectedRefs() {
        Reference<Disposable> ref;
        while ((ref = ourRefQueue.poll()) != null) {
            if (!(ref instanceof WeaklyReferencedDisposable)) continue;
            Disposer.dispose((Disposable)((Object)ref));
        }
    }
}

