/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.sun.jna.TypeMapper;
import com.sun.jna.platform.FileUtils;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jpountz.lz4.LZ4Factory;
import org.apache.log4j.Appender;
import org.apache.oro.text.regex.PatternMatcher;
import org.intellij.lang.annotations.Flow;
import org.jdom.Document;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_GUI_TEST_LOG_FILE = "idea.gui.tests.log.file";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String OPTIONS_DIRECTORY = "options";
    public static final String DEFAULT_EXT = ".xml";
    public static final String DEFAULT_OPTIONS_FILE = "other.xml";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String LIB_FOLDER = "lib";
    private static final String PLUGINS_FOLDER = "plugins";
    private static final String BIN_FOLDER = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_FOLDER = "config";
    private static final String SYSTEM_FOLDER = "system";
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");
    private static String ourHomePath;
    private static String[] ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourScratchPath;
    private static String ourPluginsPath;
    private static String ourLogPath;

    @NotNull
    public static String getHomePath() {
        return PathManager.getHomePath(true);
    }

    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        if (ourHomePath != null) {
            return ourHomePath;
        }
        String fromProperty = System.getProperty(PROPERTY_HOME_PATH, System.getProperty(PROPERTY_HOME));
        if (fromProperty != null) {
            ourHomePath = PathManager.getAbsolutePath(fromProperty);
            if (!new File(ourHomePath).isDirectory()) {
                throw new RuntimeException("Invalid home path '" + ourHomePath + "'");
            }
        } else if (insideIde && (ourHomePath = PathManager.getHomePathFor(PathManager.class)) == null) {
            String advice = SystemInfo.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
            throw new RuntimeException("Could not find installation home path. Please " + advice);
        }
        if (ourHomePath != null && SystemInfo.isWindows) {
            ourHomePath = PathManager.canonicalPath(ourHomePath);
        }
        ourBinDirectories = ourHomePath != null ? PathManager.getBinDirectories(new File(ourHomePath)) : ArrayUtil.EMPTY_STRING_ARRAY;
        return ourHomePath;
    }

    public static boolean isUnderHomeDirectory(@NotNull String path) {
        return FileUtil.isAncestor(PathManager.canonicalPath(PathManager.getHomePath()), PathManager.canonicalPath(path), true);
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class aClass) {
        String rootPath = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        if (rootPath == null) {
            return null;
        }
        File root = new File(rootPath).getAbsoluteFile();
        while ((root = root.getParentFile()) != null && !PathManager.isIdeaHome(root)) {
        }
        return root != null ? root.getPath() : null;
    }

    private static boolean isIdeaHome(File root) {
        for (String binDir : PathManager.getBinDirectories(root)) {
            if (!new File(binDir, PROPERTIES_FILE_NAME).isFile()) continue;
            return true;
        }
        return false;
    }

    private static String[] getBinDirectories(File root) {
        List<String> binDirs = ContainerUtil.newSmartList();
        String[] subDirs = new String[]{BIN_FOLDER, "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            File dir = new File(root, subDir);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
            dir = new File(dir, osSuffix);
            if (!dir.isDirectory()) continue;
            binDirs.add(dir.getPath());
        }
        return ArrayUtil.toStringArray(binDirs);
    }

    @NotNull
    public static String getBinPath() {
        return PathManager.getHomePath() + File.separator + BIN_FOLDER;
    }

    @Nullable
    public static File findBinFile(@NotNull String fileName) {
        PathManager.getHomePath();
        for (String binDir : ourBinDirectories) {
            File file = new File(binDir, fileName);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    @NotNull
    public static File findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        File file = PathManager.findBinFile(fileName);
        if (file != null) {
            return file;
        }
        String paths = StringUtil.join(ourBinDirectories, "\n");
        throw new FileNotFoundException(String.format("'%s' not found in directories:\n%s", fileName, paths));
    }

    @NotNull
    public static String getLibPath() {
        return PathManager.getHomePath() + File.separator + LIB_FOLDER;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        return PathManager.getHomePath() + File.separatorChar + PLUGINS_FOLDER;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            return ourConfigPath;
        }
        ourConfigPath = System.getProperty(PROPERTY_CONFIG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_CONFIG_PATH))) : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + CONFIG_FOLDER);
        return ourConfigPath;
    }

    @NotNull
    public static String getScratchPath() {
        if (ourScratchPath != null) {
            return ourScratchPath;
        }
        ourScratchPath = System.getProperty(PROPERTY_SCRATCH_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_SCRATCH_PATH))) : PathManager.getConfigPath();
        return ourScratchPath;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        return PathManager.platformPath(selector, "Library/Preferences", CONFIG_FOLDER);
    }

    public static void ensureConfigFolderExists() {
        FileUtil.createDirectory(new File(PathManager.getConfigPath()));
    }

    @NotNull
    public static String getOptionsPath() {
        return PathManager.getConfigPath() + File.separator + OPTIONS_DIRECTORY;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        return new File(PathManager.getOptionsPath(), fileName + DEFAULT_EXT);
    }

    @NotNull
    public static String getPluginsPath() {
        if (ourPluginsPath != null) {
            return ourPluginsPath;
        }
        ourPluginsPath = System.getProperty(PROPERTY_PLUGINS_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_PLUGINS_PATH))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? PathManager.platformPath(PATHS_SELECTOR, "Library/Application Support", "") : PathManager.getConfigPath() + File.separatorChar + PLUGINS_FOLDER);
        return ourPluginsPath;
    }

    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        if (SystemInfo.isMac) {
            return PathManager.platformPath(selector, "Library/Application Support", "");
        }
        return PathManager.getDefaultConfigPathFor(selector) + File.separatorChar + PLUGINS_FOLDER;
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : null;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            return ourSystemPath;
        }
        ourSystemPath = System.getProperty(PROPERTY_SYSTEM_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_SYSTEM_PATH))) : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + File.separator + SYSTEM_FOLDER);
        FileUtil.createDirectory(new File(ourSystemPath));
        return ourSystemPath;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        return PathManager.platformPath(selector, "Library/Caches", SYSTEM_FOLDER);
    }

    @NotNull
    public static String getTempPath() {
        return PathManager.getSystemPath() + File.separator + "tmp";
    }

    @NotNull
    public static File getIndexRoot() {
        File indexRoot = new File(System.getProperty("index_root_path", PathManager.getSystemPath() + "/index"));
        FileUtil.createDirectory(indexRoot);
        return indexRoot;
    }

    @NotNull
    public static String getLogPath() {
        if (ourLogPath != null) {
            return ourLogPath;
        }
        ourLogPath = System.getProperty(PROPERTY_LOG_PATH) != null ? PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty(PROPERTY_LOG_PATH))) : (SystemInfo.isMac && PATHS_SELECTOR != null ? SystemProperties.getUserHome() + File.separator + "Library/Logs" + File.separator + PATHS_SELECTOR : PathManager.getSystemPath() + File.separatorChar + LOG_DIRECTORY);
        return ourLogPath;
    }

    @NotNull
    public static String getPluginTempPath() {
        return PathManager.getSystemPath() + File.separator + PLUGINS_FOLDER;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class context, String path) {
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader cl, String resourcePath) {
        URL url = cl.getResource(resourcePath);
        return url != null ? PathManager.extractRoot(url, resourcePath) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = URLUtil.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.first != null) {
                resultPath = FileUtil.toSystemDependentName((String)paths.first);
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return StringUtil.trimEnd(resultPath, File.separator);
    }

    public static void loadProperties() {
        PathManager.getHomePath();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        paths.add(System.getProperty(PROPERTIES_FILE));
        paths.add(PathManager.getCustomPropertiesFile());
        paths.add(SystemProperties.getUserHome() + '/' + PROPERTIES_FILE_NAME);
        for (String binDir : ourBinDirectories) {
            paths.add(binDir + '/' + PROPERTIES_FILE_NAME);
        }
        Properties sysProperties = System.getProperties();
        for (String path : paths) {
            if (path == null || !new File(path).exists()) continue;
            try {
                BufferedReader fis = new BufferedReader(new FileReader(path));
                Throwable throwable = null;
                try {
                    Map<String, String> properties = FileUtil.loadProperties(fis);
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        String key = entry.getKey();
                        if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                            PathManager.log(path + ": '" + key + "' cannot be redefined");
                            continue;
                        }
                        if (sysProperties.containsKey(key)) continue;
                        sysProperties.setProperty(key, PathManager.substituteVars(entry.getValue()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)fis).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)fis).close();
                }
            }
            catch (IOException e) {
                PathManager.log("Can't read property file '" + path + "': " + e.getMessage());
            }
        }
    }

    private static String getCustomPropertiesFile() {
        String configPath = PathManager.getCustomOptionsDirectory();
        return configPath != null ? configPath + File.separator + PROPERTIES_FILE_NAME : null;
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s) {
        return PathManager.substituteVars(s, PathManager.getHomePath());
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, String ideaHomePath) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + File.separatorChar + BIN_FOLDER + File.separatorChar + s;
        }
        Matcher m = PROPERTY_REF.matcher(s);
        while (m.find()) {
            String key = m.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                if (PROPERTY_HOME_PATH.equals(key) || PROPERTY_HOME.equals(key)) {
                    value = ideaHomePath;
                } else if (PROPERTY_CONFIG_PATH.equals(key)) {
                    value = PathManager.getConfigPath();
                } else if (PROPERTY_SYSTEM_PATH.equals(key)) {
                    value = PathManager.getSystemPath();
                }
            }
            if (value == null) {
                PathManager.log("Unknown property: " + key);
                value = "";
            }
            s = StringUtil.replace(s, m.group(), value);
            m = PROPERTY_REF.matcher(s);
        }
        return s;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        File file = new File(PathManager.getLibPath() + File.separator + relativePath);
        return file.exists() ? file : new File(PathManager.getHomePath(), "community" + File.separator + LIB_FOLDER + File.separator + relativePath);
    }

    @NotNull
    public static String getCommunityHomePath() {
        String path = PathManager.getHomePath();
        if (new File(path, "community/.idea").isDirectory()) {
            return path + File.separator + "community";
        }
        if (new File(path, "ultimate/community/.idea").isDirectory()) {
            return path + File.separator + "ultimate" + File.separator + "community";
        }
        return path;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class aClass) {
        String resourceRoot = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        return resourceRoot != null ? new File(resourceRoot).getAbsolutePath() : null;
    }

    @NotNull
    public static Collection<String> getUtilClassPath() {
        Class[] classes = new Class[]{PathManager.class, Flow.class, SystemInfoRt.class, UrlClassLoader.class, Document.class, Appender.class, THashSet.class, TypeMapper.class, FileUtils.class, PatternMatcher.class, LZ4Factory.class};
        HashSet<String> classPath = new HashSet<String>();
        for (Class aClass : classes) {
            String path = PathManager.getJarPathForClass(aClass);
            if (path == null) continue;
            classPath.add(path);
        }
        String resourceRoot = PathManager.getResourceRoot(PathManager.class, "/messages/CommonBundle.properties");
        if (resourceRoot != null) {
            classPath.add(new File(resourceRoot).getAbsolutePath());
        }
        return Collections.unmodifiableCollection(classPath);
    }

    private static void log(String x) {
        System.err.println(x);
    }

    public static String getAbsolutePath(String path) {
        path = FileUtil.expandUserHome(path);
        return FileUtil.toCanonicalPath(new File(path).getAbsolutePath());
    }

    private static String trimPathQuotes(String path) {
        if (path != null && path.length() >= 3 && StringUtil.startsWithChar(path, '\"') && StringUtil.endsWithChar(path, '\"')) {
            path = path.substring(1, path.length() - 1);
        }
        return path;
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @NotNull String fallback) {
        return PathManager.platformPath(selector, macPart, null, null, null, fallback);
    }

    private static String platformPath(@NotNull String selector, @Nullable String macPart, @Nullable String winVar, @Nullable String xdgVar, @Nullable String xdgDir, @NotNull String fallback) {
        String dir;
        String userHome = SystemProperties.getUserHome();
        if (macPart != null && SystemInfo.isMac) {
            return userHome + File.separator + macPart + File.separator + selector;
        }
        if (winVar != null && SystemInfo.isWindows && (dir = System.getenv(winVar)) != null) {
            return dir + File.separator + selector;
        }
        if (xdgVar != null && xdgDir != null && SystemInfo.hasXdgOpen()) {
            dir = System.getenv(xdgVar);
            if (dir == null) {
                dir = userHome + File.separator + xdgDir;
            }
            return dir + File.separator + selector;
        }
        return userHome + File.separator + "." + selector + (!fallback.isEmpty() ? File.separator + fallback : "");
    }

    private static String canonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
    }

    public static File getLogFile() throws FileNotFoundException {
        String logXmlPath = System.getProperty(PROPERTY_GUI_TEST_LOG_FILE);
        if (logXmlPath != null) {
            File logXmlFile = new File(logXmlPath);
            if (logXmlFile.exists()) {
                return logXmlFile;
            }
            throw new FileNotFoundException(String.format("'%s' not found.", logXmlPath));
        }
        return PathManager.findBinFileWithException("log.xml");
    }
}

