/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimeExceptionWithAttachments
extends RuntimeException
implements ExceptionWithAttachments {
    private final String myUserMessage;
    private final Attachment[] myAttachments;

    public RuntimeExceptionWithAttachments(String message, Attachment ... attachments) {
        super(message);
        this.myUserMessage = null;
        this.myAttachments = attachments;
    }

    public RuntimeExceptionWithAttachments(Throwable cause, Attachment ... attachments) {
        super(cause);
        this.myUserMessage = null;
        this.myAttachments = attachments;
    }

    public RuntimeExceptionWithAttachments(String message, @Nullable Throwable cause, Attachment ... attachments) {
        super(message, cause);
        this.myUserMessage = null;
        this.myAttachments = attachments;
    }

    public RuntimeExceptionWithAttachments(String userMessage, String details, Attachment ... attachments) {
        super(details);
        this.myUserMessage = userMessage;
        this.myAttachments = attachments;
    }

    @Nullable
    public String getUserMessage() {
        return this.myUserMessage;
    }

    @Override
    @NotNull
    public Attachment[] getAttachments() {
        return this.myAttachments;
    }
}

