/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.Diff;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffFragmentBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.DiffFragmentBuilder");
    @NotNull
    private final DiffString[] mySource1;
    @NotNull
    private final DiffString[] mySource2;
    private int myLastLine1 = 1;
    private int myLastLine2 = 1;
    @NotNull
    private final List<DiffFragment> myData = new LinkedList<DiffFragment>();

    public DiffFragmentBuilder(@NotNull DiffString[] source1, @NotNull DiffString[] source2) {
        this.mySource1 = source1;
        this.mySource2 = source2;
        this.init();
    }

    @NotNull
    private List<DiffFragment> getFragments() {
        return this.myData;
    }

    private void finish() {
        DiffString text1 = null;
        DiffString text2 = null;
        if (this.myLastLine1 <= this.mySource1.length) {
            text1 = DiffFragmentBuilder.concatenate(this.mySource1, this.myLastLine1, this.mySource1.length);
        }
        if (this.myLastLine2 <= this.mySource2.length) {
            text2 = DiffFragmentBuilder.concatenate(this.mySource2, this.myLastLine2, this.mySource2.length);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
    }

    private void init() {
        this.myData.clear();
        this.myLastLine2 = 1;
        this.myLastLine1 = 1;
    }

    private void append(int line, @NotNull TextRange range) {
        LOG.debug("DiffFragmentBuilder.append(" + line + "," + range + "), modified:");
        DiffString text1 = null;
        DiffString text2 = null;
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        if (this.myLastLine1 <= line) {
            text1 = DiffFragmentBuilder.concatenate(this.mySource1, this.myLastLine1, line);
        }
        if (this.myLastLine2 < start) {
            text2 = DiffFragmentBuilder.concatenate(this.mySource2, this.myLastLine2, start - 1);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
        this.myData.add(new DiffFragment(null, DiffFragmentBuilder.concatenate(this.mySource2, start, end)));
        this.myLastLine1 = line + 1;
        this.myLastLine2 = end + 1;
    }

    private void change(@NotNull TextRange range1, @NotNull TextRange range2) {
        LOG.debug("DiffFragmentBuilder.change(" + range1 + "," + range2 + ")");
        DiffString text1 = null;
        DiffString text2 = null;
        int start1 = range1.getStartOffset();
        int end1 = range1.getEndOffset();
        int start2 = range2.getStartOffset();
        int end2 = range2.getEndOffset();
        if (this.myLastLine1 < start1) {
            text1 = DiffFragmentBuilder.concatenate(this.mySource1, this.myLastLine1, start1 - 1);
        }
        if (this.myLastLine2 < start2) {
            text2 = DiffFragmentBuilder.concatenate(this.mySource2, this.myLastLine2, start2 - 1);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
        this.myData.add(new DiffFragment(DiffFragmentBuilder.concatenate(this.mySource1, start1, end1), DiffFragmentBuilder.concatenate(this.mySource2, start2, end2)));
        this.myLastLine1 = end1 + 1;
        this.myLastLine2 = end2 + 1;
    }

    private void delete(@NotNull TextRange range, int line) {
        LOG.debug("DiffFragmentBuilder.delete(" + range + "," + line + ")");
        DiffString text1 = null;
        DiffString text2 = null;
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        if (this.myLastLine1 < start) {
            text1 = DiffFragmentBuilder.concatenate(this.mySource1, this.myLastLine1, start - 1);
        }
        if (this.myLastLine2 <= line) {
            text2 = DiffFragmentBuilder.concatenate(this.mySource2, this.myLastLine2, line);
        }
        if (text1 != null || text2 != null) {
            this.myData.add(DiffFragment.unchanged(text1, text2));
        }
        this.myData.add(new DiffFragment(DiffFragmentBuilder.concatenate(this.mySource1, start, end), null));
        this.myLastLine1 = end + 1;
        this.myLastLine2 = line + 1;
    }

    @NotNull
    private static DiffString concatenate(@NotNull DiffString[] strings, int start, int end) {
        return DiffString.concatenate(strings, start - 1, end - start + 1);
    }

    @NotNull
    public DiffFragment[] buildFragments(@Nullable Diff.Change change) {
        while (change != null) {
            if (change.inserted > 0 && change.deleted > 0) {
                this.change(new TextRange(change.line0 + 1, change.line0 + change.deleted), new TextRange(change.line1 + 1, change.line1 + change.inserted));
            } else if (change.inserted > 0) {
                this.append(change.line0, new TextRange(change.line1 + 1, change.line1 + change.inserted));
            } else if (change.deleted > 0) {
                this.delete(new TextRange(change.line0 + 1, change.line0 + change.deleted), change.line1);
            }
            change = change.link;
        }
        this.finish();
        List<DiffFragment> fragments = this.getFragments();
        return fragments.toArray(new DiffFragment[this.myData.size()]);
    }
}

