/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;

public abstract class AtomicNotNullLazyValue<T>
extends NotNullLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("AtomicNotNullLazyValue");
    private volatile T myValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final T getValue() {
        T value = this.myValue;
        if (value == null) {
            AtomicNotNullLazyValue atomicNotNullLazyValue = this;
            synchronized (atomicNotNullLazyValue) {
                value = this.myValue;
                if (value == null) {
                    RecursionGuard.StackStamp stamp = ourGuard.markStack();
                    value = this.compute();
                    if (stamp.mayCacheNow()) {
                        this.myValue = value;
                    }
                }
            }
        }
        return value;
    }

    @Override
    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> AtomicNotNullLazyValue<T> createValue(final @NotNull NotNullFactory<? extends T> value) {
        return new AtomicNotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                return value.create();
            }
        };
    }
}

