/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.CopyableIcon;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.DeprecatedDuplicatesIconPathPatcher;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.ImageLoader;
import com.intellij.util.Producer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    private static final String LAF_PREFIX = "/com/intellij/ide/ui/laf/icons/";
    private static final String ICON_CACHE_URL_KEY = "ICON_CACHE_URL_KEY";
    private static final ConcurrentMap<Pair<String, Object>, CachedImageIcon> ourIconsCache = ContainerUtil.newConcurrentMap(100, 0.9f, 2);
    private static final Map<Icon, Icon> ourIcon2DisabledIcon = ContainerUtil.createWeakMap(200);
    private static volatile boolean STRICT_GLOBAL;
    private static final ThreadLocal<Boolean> STRICT_LOCAL;
    private static final AtomicReference<IconTransform> ourTransform;
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    public static <T, E extends Throwable> T performStrictly(ThrowableComputable<T, E> computable) throws E {
        STRICT_LOCAL.set(true);
        try {
            T t = computable.compute();
            return t;
        }
        finally {
            STRICT_LOCAL.set(false);
        }
    }

    public static void setStrictGlobally(boolean strict) {
        STRICT_GLOBAL = strict;
    }

    private static void updateTransform(Function<IconTransform, IconTransform> updater) {
        IconTransform next;
        IconTransform prev;
        while (!ourTransform.compareAndSet(prev = ourTransform.get(), next = updater.fun(prev))) {
        }
        if (prev != next) {
            ourIconsCache.clear();
            ourIcon2DisabledIcon.clear();
            ImageLoader.clearCache();
        }
    }

    public static void installPathPatcher(@NotNull IconPathPatcher patcher) {
        IconLoader.updateTransform(transform -> transform.withPathPatcher(patcher));
    }

    public static void removePathPatcher(@NotNull IconPathPatcher patcher) {
        IconLoader.updateTransform(transform -> transform.withoutPathPatcher(patcher));
    }

    @Deprecated
    @NotNull
    public static Icon getIcon(@NotNull Image image) {
        return new JBImageIcon(image);
    }

    public static void setUseDarkIcons(boolean useDarkIcons) {
        IconLoader.updateTransform(transform -> transform.withDark(useDarkIcons));
    }

    public static void setFilter(ImageFilter filter) {
        IconLoader.updateTransform(transform -> transform.withFilter(filter));
    }

    public static void clearCache() {
        IconLoader.updateTransform(IconTransform::copy);
    }

    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path;
        return IconLoader.getIcon(path, callerClass);
    }

    @Nullable
    private static Icon getReflectiveIcon(@NotNull String path, ClassLoader classLoader) {
        try {
            String pckg = path.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
            Class<?> cur = Class.forName(pckg + path.substring(0, path.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = cur.getField(path.substring(path.lastIndexOf(46) + 1));
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass);
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path, boolean strict) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass, false, strict);
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull Class aClass) {
        Icon icon = IconLoader.findIcon(path, aClass, aClass.getClassLoader(), CachedImageIcon.HandleNotFound.strict(STRICT_LOCAL.get()), true);
        if (icon == null) {
            LOG.error("Icon cannot be found in '" + path + "', aClass='" + aClass + "'");
        }
        return icon;
    }

    public static void activate() {
        ourIsActivated = true;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findLafIcon(@NotNull String key, @NotNull Class aClass) {
        return IconLoader.findLafIcon(key, aClass, STRICT_LOCAL.get());
    }

    @Nullable
    public static Icon findLafIcon(@NotNull String key, @NotNull Class aClass, boolean strict) {
        return IconLoader.findIcon(LAF_PREFIX + key + ".png", aClass, true, strict);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass) {
        return IconLoader.findIcon(path, aClass, false);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass, boolean computeNow) {
        return IconLoader.findIcon(path, aClass, computeNow, STRICT_LOCAL.get());
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass, boolean computeNow, boolean strict) {
        return IconLoader.findIcon(path, aClass, aClass.getClassLoader(), CachedImageIcon.HandleNotFound.strict(strict), false);
    }

    private static boolean isReflectivePath(@NotNull String path) {
        List<String> paths = StringUtil.split(path, ".");
        return paths.size() > 1 && paths.get(0).endsWith("Icons");
    }

    @Nullable
    public static Icon findIcon(URL url) {
        return IconLoader.findIcon(url, true);
    }

    @Nullable
    public static Icon findIcon(URL url, boolean useCache) {
        if (url == null) {
            return null;
        }
        Pair<String, URL> key = Pair.create(ICON_CACHE_URL_KEY, url);
        CachedImageIcon icon = (CachedImageIcon)ourIconsCache.get(key);
        if (icon == null) {
            icon = new CachedImageIcon(url, useCache);
            if (useCache) {
                icon = ConcurrencyUtil.cacheOrGet(ourIconsCache, key, icon);
            }
        }
        return icon;
    }

    @Nullable
    private static Icon findIcon(@NotNull String originalPath, @Nullable Class clazz, @NotNull ClassLoader classLoader, CachedImageIcon.HandleNotFound handleNotFound, boolean deferUrlResolve) {
        Pair<String, ClassLoader> patchedPath = ourTransform.get().patchPath(originalPath, classLoader);
        String path = (String)patchedPath.first;
        if (patchedPath.second != null) {
            classLoader = (ClassLoader)patchedPath.second;
        }
        if (IconLoader.isReflectivePath(path)) {
            return IconLoader.getReflectiveIcon(path, classLoader);
        }
        Pair<String, ClassLoader> key = Pair.create(originalPath, classLoader);
        CachedImageIcon cachedIcon = (CachedImageIcon)ourIconsCache.get(key);
        if (cachedIcon == null) {
            cachedIcon = CachedImageIcon.create(originalPath, path, classLoader, clazz, handleNotFound, deferUrlResolve);
            if (cachedIcon == null) {
                return null;
            }
            cachedIcon = ConcurrencyUtil.cacheOrGet(ourIconsCache, key, cachedIcon);
        }
        return cachedIcon;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        return IconLoader.findIcon(path, null, classLoader, CachedImageIcon.HandleNotFound.strict(false), false);
    }

    @Nullable
    public static Image toImage(@NotNull Icon icon) {
        return IconLoader.toImage(icon, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Image toImage(@NotNull Icon icon, @Nullable JBUI.ScaleContext ctx) {
        if (icon instanceof RetrievableIcon) {
            icon = ((RetrievableIcon)icon).retrieveIcon();
        }
        if (icon instanceof CachedImageIcon) {
            icon = ((CachedImageIcon)icon).getRealIcon(ctx);
        }
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        BufferedImage image = GraphicsEnvironment.isHeadless() ? UIUtil.createImage(ctx, (double)icon.getIconWidth(), (double)icon.getIconHeight(), 2, PaintUtil.RoundingMode.FLOOR) : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(null, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="null, _->null; !null, _->!null")
    public static Icon copy(@Nullable Icon icon, @Nullable Component ancestor) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof CopyableIcon) {
            return ((CopyableIcon)icon).copy();
        }
        BufferedImage image = UIUtil.createImage(ancestor, icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        try {
            icon.paintIcon(ancestor, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return new JBImageIcon(image);
    }

    @Nullable
    private static ImageIcon checkIcon(@Nullable Image image, @NotNull CachedImageIcon cii) {
        if (image == null || image.getHeight(null) < 1) {
            return null;
        }
        JBImageIcon icon = new JBImageIcon(image);
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + cii);
            return EMPTY_ICON;
        }
        return icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    @Nullable
    public static Icon getDisabledIcon(Icon icon) {
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon == null) {
            return null;
        }
        Icon disabledIcon = ourIcon2DisabledIcon.get(icon);
        if (disabledIcon == null) {
            disabledIcon = IconLoader.filterIcon(icon, UIUtil::getGrayFilter, null);
            ourIcon2DisabledIcon.put(icon, disabledIcon);
        }
        return disabledIcon;
    }

    @Nullable
    public static Icon filterIcon(@NotNull Icon icon, @NotNull Producer<RGBImageFilter> filterSupplier, @Nullable Component ancestor) {
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon == null) {
            return null;
        }
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error(icon);
            return EMPTY_ICON;
        }
        if (icon instanceof CachedImageIcon) {
            icon = ((CachedImageIcon)icon).createWithFilter(filterSupplier);
        } else {
            float scale = icon instanceof JBUI.ScaleContextAware ? (float)((JBUI.ScaleContextAware)((Object)icon)).getScale(JBUI.ScaleType.SYS_SCALE) : (UIUtil.isJreHiDPI() ? JBUI.sysScale(ancestor) : 1.0f);
            BufferedImage image = new BufferedImage((int)(scale * (float)icon.getIconWidth()), (int)(scale * (float)icon.getIconHeight()), 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(UIUtil.TRANSPARENT_COLOR);
            graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
            graphics.scale(scale, scale);
            icon.paintIcon(LabelHolder.ourFakeComponent, graphics, 0, 0);
            graphics.dispose();
            Image img = ImageUtil.filter(image, filterSupplier.produce());
            if (UIUtil.isJreHiDPI(ancestor)) {
                img = RetinaImage.createFrom(img, scale, null);
            }
            icon = new JBImageIcon(img);
        }
        return icon;
    }

    @NotNull
    public static Icon getTransparentIcon(@NotNull Icon icon) {
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    @NotNull
    public static Icon getTransparentIcon(final @NotNull Icon icon, final float alpha) {
        return new RetrievableIcon(){

            @Override
            public Icon retrieveIcon() {
                return icon;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }
        };
    }

    @NotNull
    public static Icon getIconSnapshot(@NotNull Icon icon) {
        if (icon instanceof CachedImageIcon) {
            return ((CachedImageIcon)icon).getRealIcon();
        }
        return icon;
    }

    public static Icon getMenuBarIcon(Icon icon, boolean dark) {
        if (icon instanceof RetrievableIcon) {
            icon = ((RetrievableIcon)icon).retrieveIcon();
        }
        if (icon instanceof MenuBarIconProvider) {
            return ((MenuBarIconProvider)((Object)icon)).getMenuBarIcon(dark);
        }
        return icon;
    }

    public static Icon getDarkIcon(Icon icon, boolean dark) {
        if (icon instanceof RetrievableIcon) {
            icon = IconLoader.getOrigin((RetrievableIcon)icon);
        }
        if (icon instanceof DarkIconProvider) {
            return ((DarkIconProvider)((Object)icon)).getDarkIcon(dark);
        }
        return icon;
    }

    private static Icon getOrigin(RetrievableIcon icon) {
        int maxDeep = 10;
        Icon origin = icon.retrieveIcon();
        for (int level = 0; origin instanceof RetrievableIcon && level < 10; ++level) {
            origin = ((RetrievableIcon)origin).retrieveIcon();
        }
        if (origin instanceof RetrievableIcon) {
            LOG.error("can't calculate origin icon (too deep in hierarchy), src: " + icon);
        }
        return origin;
    }

    static {
        STRICT_LOCAL = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }

            @Override
            public Boolean get() {
                if (STRICT_GLOBAL) {
                    return true;
                }
                return (Boolean)super.get();
            }
        };
        ourTransform = new AtomicReference<IconTransform>(IconTransform.getDefault());
        IconLoader.installPathPatcher(new DeprecatedDuplicatesIconPathPatcher());
        EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
    }

    private static final class IconTransform {
        private final boolean myDark;
        @NotNull
        private final IconPathPatcher[] myPatchers;
        @Nullable
        private final ImageFilter myFilter;

        private IconTransform(boolean dark, @NotNull IconPathPatcher[] patchers, @Nullable ImageFilter filter) {
            this.myDark = dark;
            this.myPatchers = patchers;
            this.myFilter = filter;
        }

        public boolean isDark() {
            return this.myDark;
        }

        @Nullable
        public ImageFilter getFilter() {
            return this.myFilter;
        }

        public IconTransform withPathPatcher(IconPathPatcher patcher) {
            return new IconTransform(this.myDark, ArrayUtil.append(this.myPatchers, patcher), this.myFilter);
        }

        public IconTransform withoutPathPatcher(IconPathPatcher patcher) {
            IconPathPatcher[] newPatchers = ArrayUtil.remove(this.myPatchers, patcher);
            return newPatchers == this.myPatchers ? this : new IconTransform(this.myDark, newPatchers, this.myFilter);
        }

        public IconTransform withFilter(ImageFilter filter) {
            return filter == this.myFilter ? this : new IconTransform(this.myDark, this.myPatchers, filter);
        }

        public IconTransform withDark(boolean dark) {
            return dark == this.myDark ? this : new IconTransform(dark, this.myPatchers, this.myFilter);
        }

        public Pair<String, ClassLoader> patchPath(@NotNull String path, ClassLoader classLoader) {
            for (IconPathPatcher patcher : this.myPatchers) {
                Class contextClass;
                String newPath = patcher.patchPath(path, classLoader);
                if (newPath == null) {
                    newPath = patcher.patchPath(path, null);
                }
                if (newPath == null) continue;
                LOG.info("replace '" + path + "' with '" + newPath + "'");
                ClassLoader contextClassLoader = patcher.getContextClassLoader(path, classLoader);
                if (contextClassLoader == null && (contextClass = patcher.getContextClass(path)) != null) {
                    contextClassLoader = contextClass.getClassLoader();
                }
                return Pair.create(newPath, contextClassLoader);
            }
            return Pair.create(path, null);
        }

        public IconTransform copy() {
            return new IconTransform(this.myDark, this.myPatchers, this.myFilter);
        }

        public static IconTransform getDefault() {
            return new IconTransform(UIUtil.isUnderDarcula(), new IconPathPatcher[0], null);
        }
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JLabel();

        private LabelHolder() {
        }
    }

    public static interface DarkIconProvider {
        public Icon getDarkIcon(boolean var1);
    }

    public static interface MenuBarIconProvider {
        public Icon getMenuBarIcon(boolean var1);
    }

    public static abstract class LazyIcon
    extends JBUI.RasterJBIcon
    implements RetrievableIcon {
        private boolean myWasComputed;
        private volatile Icon myIcon;
        private IconTransform myTransform = (IconTransform)IconLoader.access$600().get();

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon;
            if (this.updateScaleContext(JBUI.ScaleContext.create((Graphics2D)g))) {
                this.myIcon = null;
            }
            if ((icon = this.getOrComputeIcon()) != null) {
                icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconWidth() : 0;
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconHeight() : 0;
        }

        protected final synchronized Icon getOrComputeIcon() {
            IconTransform currentTransform = (IconTransform)ourTransform.get();
            if (!this.myWasComputed || this.myTransform != currentTransform || this.myIcon == null) {
                this.myTransform = currentTransform;
                this.myWasComputed = true;
                this.myIcon = this.compute();
            }
            return this.myIcon;
        }

        public final void load() {
            this.getIconWidth();
        }

        protected abstract Icon compute();

        @Override
        @Nullable
        public Icon retrieveIcon() {
            return this.getOrComputeIcon();
        }

        @Override
        @NotNull
        public Icon copy() {
            return IconLoader.copy(this.getOrComputeIcon(), null);
        }
    }

    public static final class CachedImageIcon
    extends JBUI.RasterJBIcon
    implements ScalableIcon,
    DarkIconProvider,
    MenuBarIconProvider {
        private final Object myLock = new Object();
        @Nullable
        private volatile Object myRealIcon;
        @Nullable
        private final String myOriginalPath;
        @NotNull
        private volatile MyUrlResolver myResolver;
        @Nullable(value="when not overridden")
        private final Boolean myDarkOverridden;
        @NotNull
        private volatile IconTransform myTransform;
        private final boolean myUseCacheOnLoad;
        @Nullable
        private final Producer<RGBImageFilter> myLocalFilterSupplier;
        private final MyScaledIconsCache myScaledIconsCache = new MyScaledIconsCache();

        public CachedImageIcon(@NotNull URL url) {
            this(url, true);
        }

        CachedImageIcon(@Nullable URL url, boolean useCacheOnLoad) {
            this(new MyUrlResolver(url, null), null, useCacheOnLoad);
        }

        private CachedImageIcon(@NotNull MyUrlResolver urlResolver, @Nullable String originalPath, boolean useCacheOnLoad) {
            this(originalPath, urlResolver, null, useCacheOnLoad, (IconTransform)ourTransform.get(), null);
        }

        private CachedImageIcon(@Nullable String originalPath, @NotNull MyUrlResolver resolver, @Nullable Boolean darkOverridden, boolean useCacheOnLoad, @NotNull IconTransform transform, @Nullable Producer<RGBImageFilter> localFilterSupplier) {
            this.myOriginalPath = originalPath;
            this.myResolver = resolver;
            this.myDarkOverridden = darkOverridden;
            this.myUseCacheOnLoad = useCacheOnLoad;
            this.myTransform = transform;
            this.myLocalFilterSupplier = localFilterSupplier;
            ((JBUI.ScaleContext)this.getScaleContext()).addUpdateListener(new JBUI.BaseScaleContext.UpdateListener(){

                @Override
                public void contextUpdated() {
                    myRealIcon = null;
                }
            });
        }

        @Contract(value="_, _, _, _, _, true -> !null")
        static CachedImageIcon create(@NotNull String originalPath, @Nullable String pathToResolve, @NotNull ClassLoader classLoader, @Nullable Class clazz, HandleNotFound handleNotFound, boolean deferUrlResolve) {
            MyUrlResolver resolver = new MyUrlResolver(pathToResolve == null ? originalPath : pathToResolve, clazz, classLoader, handleNotFound);
            CachedImageIcon icon = new CachedImageIcon(resolver, originalPath, true);
            if (!deferUrlResolve && icon.getURL() == null) {
                return null;
            }
            return icon;
        }

        @Nullable
        public String getOriginalPath() {
            return this.myOriginalPath;
        }

        @NotNull
        private ImageIcon getRealIcon() {
            return this.getRealIcon(null);
        }

        @Nullable
        public ImageIcon doGetRealIcon() {
            return CachedImageIcon.unwrapIcon(this.myRealIcon);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private ImageIcon getRealIcon(@Nullable JBUI.ScaleContext ctx) {
            if (!this.isValid()) {
                if (IconLoader.isLoaderDisabled()) {
                    return EMPTY_ICON;
                }
                Object object = this.myLock;
                synchronized (object) {
                    if (!this.isValid()) {
                        this.myTransform = (IconTransform)ourTransform.get();
                        this.myResolver.resolve();
                        this.myRealIcon = null;
                        this.myScaledIconsCache.clear();
                        if (this.myOriginalPath != null) {
                            this.myResolver = this.myResolver.patch(this.myOriginalPath, this.myTransform);
                        }
                    }
                }
            }
            Object realIcon = this.myRealIcon;
            Object object = this.myLock;
            synchronized (object) {
                ImageIcon icon;
                if (!this.updateScaleContext(ctx) && realIcon != null && (icon = CachedImageIcon.unwrapIcon(realIcon)) != null) {
                    return icon;
                }
                icon = this.myScaledIconsCache.getOrScaleIcon(1.0f);
                if (icon != null) {
                    this.myRealIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<ImageIcon>(icon);
                    return icon;
                }
            }
            return EMPTY_ICON;
        }

        @Nullable
        private static ImageIcon unwrapIcon(Object realIcon) {
            Object icon = realIcon;
            if (icon instanceof Reference) {
                icon = ((Reference)icon).get();
            }
            return icon instanceof ImageIcon ? (ImageIcon)icon : null;
        }

        private boolean isValid() {
            return this.myTransform == ourTransform.get() && this.myResolver.isResolved();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = g instanceof Graphics2D ? (Graphics2D)g : null;
            this.getRealIcon(JBUI.ScaleContext.create(c, g2d)).paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            URL url;
            if (this.myResolver.isResolved() && (url = this.myResolver.getURL()) != null) {
                return url.toString();
            }
            return this.myOriginalPath != null ? this.myOriginalPath : "unknown path";
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        @NotNull
        public Icon scale(float scale) {
            if (scale == 1.0f) {
                return this;
            }
            this.getRealIcon();
            ImageIcon icon = this.myScaledIconsCache.getOrScaleIcon(scale);
            if (icon != null) {
                return icon;
            }
            return this;
        }

        @Override
        public Icon getDarkIcon(boolean isDark) {
            return new CachedImageIcon(this.myOriginalPath, this.myResolver, isDark, this.myUseCacheOnLoad, this.myTransform, this.myLocalFilterSupplier);
        }

        @Override
        public Icon getMenuBarIcon(boolean isDark) {
            Image img = this.loadFromUrl(JBUI.ScaleContext.createIdentity(), isDark);
            if (img != null) {
                return new ImageIcon(img);
            }
            return this;
        }

        @Override
        @NotNull
        public CachedImageIcon copy() {
            return new CachedImageIcon(this.myOriginalPath, this.myResolver, this.myDarkOverridden, this.myUseCacheOnLoad, this.myTransform, this.myLocalFilterSupplier);
        }

        @NotNull
        private Icon createWithFilter(@NotNull Producer<RGBImageFilter> filterSupplier) {
            return new CachedImageIcon(this.myOriginalPath, this.myResolver, this.myDarkOverridden, this.myUseCacheOnLoad, this.myTransform, filterSupplier);
        }

        private boolean isDark() {
            return this.myDarkOverridden == null ? this.myTransform.isDark() : this.myDarkOverridden.booleanValue();
        }

        @Nullable
        private ImageFilter[] getFilters() {
            ImageFilter local;
            ImageFilter global = this.myTransform.getFilter();
            ImageFilter imageFilter = local = this.myLocalFilterSupplier != null ? (ImageFilter)this.myLocalFilterSupplier.produce() : null;
            if (global != null && local != null) {
                return new ImageFilter[]{global, local};
            }
            if (global != null) {
                return new ImageFilter[]{global};
            }
            if (local != null) {
                return new ImageFilter[]{local};
            }
            return null;
        }

        @Nullable
        public URL getURL() {
            return this.myResolver.getURL();
        }

        @Nullable
        private Image loadFromUrl(@NotNull JBUI.ScaleContext ctx, boolean dark) {
            URL url = this.getURL();
            if (url == null) {
                return null;
            }
            return ImageLoader.loadFromUrl(url, true, this.myUseCacheOnLoad, dark, this.getFilters(), ctx);
        }

        private static class MyUrlResolver {
            @Nullable
            private final Class myClass;
            @Nullable
            private final ClassLoader myClassLoader;
            @Nullable
            private final String myOverriddenPath;
            @NotNull
            private final HandleNotFound myHandleNotFound;
            @Nullable
            private URL myUrl;
            private volatile boolean isResolved;

            MyUrlResolver(@Nullable URL url, @Nullable ClassLoader classLoader) {
                this.myClass = null;
                this.myOverriddenPath = null;
                this.myClassLoader = classLoader;
                this.myUrl = url;
                this.myHandleNotFound = HandleNotFound.IGNORE;
                this.isResolved = true;
            }

            MyUrlResolver(@NotNull String path, @Nullable Class clazz, @Nullable ClassLoader classLoader, @NotNull HandleNotFound handleNotFound) {
                this.myOverriddenPath = path;
                this.myClass = clazz;
                this.myClassLoader = classLoader;
                this.myHandleNotFound = handleNotFound;
                if (!Registry.is("ide.icons.deferUrlResolve")) {
                    this.resolve();
                }
            }

            boolean isResolved() {
                return this.isResolved;
            }

            MyUrlResolver resolve() throws RuntimeException {
                if (this.isResolved) {
                    return this;
                }
                try {
                    URL url = null;
                    String path = this.myOverriddenPath;
                    if (path != null) {
                        if (this.myClassLoader != null) {
                            path = StringUtil.trimStart(path, "/");
                            url = MyUrlResolver.findURL(path, this.myClassLoader::getResource);
                        }
                        if (url == null && this.myClass != null) {
                            url = MyUrlResolver.findURL(path, this.myClass::getResource);
                        }
                    }
                    if (url == null) {
                        this.myHandleNotFound.handle("Can't find icon in '" + path + "' near " + this.myClassLoader);
                    }
                    this.myUrl = url;
                }
                finally {
                    this.isResolved = true;
                }
                return this;
            }

            @Nullable
            URL getURL() {
                if (!this.isResolved()) {
                    return this.resolve().myUrl;
                }
                return this.myUrl;
            }

            MyUrlResolver patch(@NotNull String originalPath, @NotNull IconTransform transform) {
                Pair<String, ClassLoader> patchedPath = transform.patchPath(originalPath, this.myClassLoader);
                ClassLoader classLoader = patchedPath.second != null ? (ClassLoader)patchedPath.second : this.myClassLoader;
                String path = (String)patchedPath.first;
                if (classLoader != null && path != null && path.startsWith("/")) {
                    return new MyUrlResolver(path.substring(1), null, classLoader, this.myHandleNotFound).resolve();
                }
                return this;
            }

            @Nullable
            private static URL findURL(@NotNull String path, @NotNull Function<String, URL> urlProvider) {
                URL url = urlProvider.fun(path);
                if (url != null) {
                    return url;
                }
                if (path.endsWith(".png")) {
                    path = path.substring(0, path.length() - 4) + ".svg";
                } else if (path.endsWith(".svg")) {
                    path = path.substring(0, path.length() - 4) + ".png";
                } else {
                    LOG.debug("unexpected path: ", path);
                }
                return urlProvider.fun(path);
            }
        }

        static enum HandleNotFound {
            THROW_EXCEPTION{

                @Override
                void handle(String msg) {
                    throw new RuntimeException(msg);
                }
            }
            ,
            LOG_ERROR{

                @Override
                void handle(String msg) {
                    LOG.error(msg);
                }
            }
            ,
            IGNORE;


            void handle(String msg) throws RuntimeException {
            }

            static HandleNotFound strict(boolean strict) {
                return strict ? THROW_EXCEPTION : IGNORE;
            }
        }

        private class MyScaledIconsCache {
            private static final int SCALED_ICONS_CACHE_LIMIT = 5;
            private final Map<Couple<Double>, SoftReference<ImageIcon>> scaledIconsCache = Collections.synchronizedMap(new FixedHashMap(5));

            private MyScaledIconsCache() {
            }

            private Couple<Double> key(@NotNull JBUI.ScaleContext ctx) {
                return new Couple<Double>(ctx.getScale(JBUI.ScaleType.USR_SCALE) * ctx.getScale(JBUI.ScaleType.OBJ_SCALE), ctx.getScale(JBUI.ScaleType.SYS_SCALE));
            }

            ImageIcon getOrScaleIcon(float scale) {
                ImageIcon icon;
                JBUI.ScaleContext ctx = (JBUI.ScaleContext)CachedImageIcon.this.getScaleContext();
                if (scale != 1.0f) {
                    ctx = (JBUI.ScaleContext)ctx.copy();
                    ctx.update(JBUI.ScaleType.OBJ_SCALE.of(scale));
                }
                if ((icon = (ImageIcon)SoftReference.dereference(this.scaledIconsCache.get(this.key(ctx)))) != null) {
                    return icon;
                }
                Image image = CachedImageIcon.this.loadFromUrl(ctx, CachedImageIcon.this.isDark());
                icon = IconLoader.checkIcon(image, CachedImageIcon.this);
                if (icon != null && 4L * (long)icon.getIconWidth() * (long)icon.getIconHeight() < ImageLoader.CACHED_IMAGE_MAX_SIZE) {
                    this.scaledIconsCache.put(this.key(ctx), new SoftReference<ImageIcon>(icon));
                }
                return icon;
            }

            public void clear() {
                this.scaledIconsCache.clear();
            }
        }
    }
}

