/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class JDOMExternalizer {
    private JDOMExternalizer() {
    }

    @Deprecated
    public static void write(Element root, @NonNls String name, String value) {
        Element element = new Element("setting");
        element.setAttribute("name", name);
        element.setAttribute("value", value == null ? "" : value);
        root.addContent(element);
    }

    @Deprecated
    public static void write(Element root, @NonNls String name, boolean value) {
        JDOMExternalizer.write(root, name, Boolean.toString(value));
    }

    @Deprecated
    public static void write(Element root, String name, int value) {
        JDOMExternalizer.write(root, name, Integer.toString(value));
    }

    public static boolean readBoolean(Element root, @NonNls String name) {
        return Boolean.parseBoolean(JDOMExternalizer.readString(root, name));
    }

    public static int readInteger(Element root, String name, int defaultValue) {
        return StringUtilRt.parseInt(JDOMExternalizer.readString(root, name), defaultValue);
    }

    @Nullable
    public static String readString(@NonNls Element root, @NonNls String name) {
        for (Element element : root.getChildren("setting")) {
            if (!Comparing.strEqual(element.getAttributeValue("name"), name)) continue;
            return element.getAttributeValue("value");
        }
        return null;
    }

    public static void writeMap(Element root, Map<String, String> map, @NonNls @Nullable String rootName, @NonNls String entryName) {
        Element mapRoot;
        if (StringUtil.isNotEmpty(rootName)) {
            mapRoot = new Element(rootName);
            root.addContent(mapRoot);
        } else {
            mapRoot = root;
        }
        Object[] names = ArrayUtil.toStringArray(map.keySet());
        Arrays.sort(names);
        for (Object name : names) {
            Element element = new Element(entryName);
            element.setAttribute("name", (String)name);
            String value = map.get(name);
            if (value != null) {
                element.setAttribute("value", value);
            }
            mapRoot.addContent(element);
        }
    }

    public static void readMap(Element root, Map<String, String> map, @NonNls @Nullable String rootName, @NonNls String entryName) {
        Element mapRoot = StringUtil.isNotEmpty(rootName) ? root.getChild(rootName) : root;
        if (mapRoot == null) {
            return;
        }
        for (Element element : mapRoot.getChildren(entryName)) {
            String name = element.getAttributeValue("name");
            if (name == null) continue;
            map.put(name, element.getAttributeValue("value"));
        }
    }

    public static void saveStringsList(@NotNull Element parent, @NotNull String nodeName, @NotNull String attrName, String ... values) {
        for (String value : values) {
            Element node = new Element(nodeName);
            node.setAttribute(attrName, value);
            parent.addContent(node);
        }
    }

    @NotNull
    public static List<String> loadStringsList(Element element, String rootName, String attrName) {
        LinkedList<String> paths = new LinkedList<String>();
        if (element != null) {
            List list = element.getChildren(rootName);
            for (Object o : list) {
                paths.add(((Element)o).getAttribute(attrName).getValue());
            }
        }
        return paths;
    }
}

