/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.SafeStAXStreamBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.xml.util.XmlStringUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.JDOMInterner;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.Filter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDOMUtil {
    private static final Condition<Attribute> NOT_EMPTY_VALUE_CONDITION = attribute -> !StringUtil.isEmpty(attribute.getValue());
    private static final String XML_INPUT_FACTORY_KEY = "javax.xml.stream.XMLInputFactory";
    private static final String XML_INPUT_FACTORY_IMPL = "com.sun.xml.internal.stream.XMLInputFactoryImpl";
    private static final NotNullLazyValue<XMLInputFactory> XML_INPUT_FACTORY = new NotNullLazyValue<XMLInputFactory>(){

        @Override
        @NotNull
        protected XMLInputFactory compute() {
            XMLInputFactory factory;
            String property = System.setProperty(JDOMUtil.XML_INPUT_FACTORY_KEY, JDOMUtil.XML_INPUT_FACTORY_IMPL);
            try {
                factory = XMLInputFactory.newFactory();
            }
            finally {
                if (property != null) {
                    System.setProperty(JDOMUtil.XML_INPUT_FACTORY_KEY, property);
                } else {
                    System.clearProperty(JDOMUtil.XML_INPUT_FACTORY_KEY);
                }
            }
            if (!SystemInfo.isIbmJvm) {
                try {
                    factory.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", true);
                }
                catch (Exception e) {
                    JDOMUtil.getLogger().error("cannot set \"report-cdata-event\" property for XMLInputFactory", e);
                }
            }
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            return factory;
        }
    };
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();
    private static final JDOMInterner ourJDOMInterner = new JDOMInterner();

    private JDOMUtil() {
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        return parent == null ? Collections.emptyList() : parent.getChildren();
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent, @NotNull String name) {
        if (parent != null) {
            return parent.getChildren(name);
        }
        return Collections.emptyList();
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        return JDOMUtil.areElementsEqual(e1, e2, false);
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Comparing.equal(e1.getName(), e2.getName()) && JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(e1), JDOMUtil.getAttributes(e2), ignoreEmptyAttrValues) && JDOMUtil.contentListsEqual(e1.getContent((Filter)CONTENT_FILTER), e2.getContent((Filter)CONTENT_FILTER), ignoreEmptyAttrValues);
    }

    @Deprecated
    @NotNull
    public static Element[] getElements(@NotNull Element m) {
        List list = m.getChildren();
        return list.toArray(new Element[0]);
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        return JDOMUtil.legalizeChars(str).toString();
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        StringBuilder result = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            JDOMUtil.appendLegalized(result, str.charAt(i));
        }
        return result;
    }

    private static void appendLegalized(@NotNull StringBuilder sb, char each) {
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter((int)each)) {
            sb.append("0x").append(StringUtil.toUpperCase(Long.toHexString(each)));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentListsEqual(List c1, List c2, boolean ignoreEmptyAttrValues) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator l1 = c1.listIterator();
        ListIterator l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next(), ignoreEmptyAttrValues)) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2, boolean ignoreEmptyAttrValues) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2, ignoreEmptyAttrValues);
    }

    private static boolean isAttributesEqual(@NotNull List<? extends Attribute> l1, @NotNull List<? extends Attribute> l2, boolean ignoreEmptyAttrValues) {
        if (ignoreEmptyAttrValues) {
            l1 = ContainerUtil.filter(l1, NOT_EMPTY_VALUE_CONDITION);
            l2 = ContainerUtil.filter(l2, NOT_EMPTY_VALUE_CONDITION);
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (JDOMUtil.attEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    @NotNull
    private static Document loadDocumentUsingStaX(@NotNull Reader reader) throws JDOMException, IOException {
        try {
            Document document;
            XMLStreamReader xmlStreamReader = XML_INPUT_FACTORY.getValue().createXMLStreamReader(reader);
            try {
                document = SafeStAXStreamBuilder.buildDocument(xmlStreamReader, true);
            }
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), (Throwable)e);
                }
            }
            xmlStreamReader.close();
            return document;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Element loadUsingStaX(@NotNull Reader reader, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        try {
            Element element;
            XMLStreamReader xmlStreamReader = XML_INPUT_FACTORY.getValue().createXMLStreamReader(reader);
            try {
                element = SafeStAXStreamBuilder.build(xmlStreamReader, true, factory == null ? SafeStAXStreamBuilder.FACTORY : factory);
            }
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), (Throwable)e);
                }
            }
            xmlStreamReader.close();
            return element;
        }
        finally {
            reader.close();
        }
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull CharSequence seq) throws IOException, JDOMException {
        return JDOMUtil.loadDocument(new CharSequenceReader(seq));
    }

    @NotNull
    public static Element load(@NotNull CharSequence seq) throws IOException, JDOMException {
        return JDOMUtil.load(new CharSequenceReader(seq));
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        return JDOMUtil.loadDocumentUsingStaX(reader);
    }

    @NotNull
    public static Document loadDocument(@NotNull File file) throws JDOMException, IOException {
        return JDOMUtil.loadDocumentUsingStaX(new BufferedReader(new InputStreamReader(new FileInputStream(file))));
    }

    @NotNull
    public static Element load(@NotNull File file) throws JDOMException, IOException {
        return JDOMUtil.load(file, null);
    }

    @ApiStatus.Experimental
    @NotNull
    public static Element load(@NotNull File file, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        return JDOMUtil.loadUsingStaX(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CharsetToolkit.UTF8_CHARSET)), factory);
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        return JDOMUtil.loadDocumentUsingStaX(new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET));
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(Reader reader) throws JDOMException, IOException {
        return reader == null ? null : JDOMUtil.loadUsingStaX(reader, null);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.load(stream, null);
    }

    @ApiStatus.Experimental
    @NotNull
    public static Element load(@NotNull InputStream stream, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        return JDOMUtil.loadUsingStaX(new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET), factory);
    }

    @NotNull
    public static Element load(@NotNull Class<?> clazz, @NotNull String resource) throws JDOMException, IOException {
        InputStream stream = clazz.getResourceAsStream(resource);
        if (stream == null) {
            throw new FileNotFoundException(resource);
        }
        return JDOMUtil.load(stream);
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.loadDocument(URLUtil.openStream(url));
    }

    @NotNull
    public static Element load(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.load(URLUtil.openStream(url));
    }

    @Deprecated
    @NotNull
    public static Document loadResourceDocument(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
    }

    @NotNull
    public static Element loadResource(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.load(URLUtil.openResourceStream(url));
    }

    public static void writeDocument(@NotNull Document document, @NotNull String filePath, String lineSeparator) throws IOException {
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));){
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull File file, String lineSeparator) throws IOException {
        JDOMUtil.write((Parent)document, file, lineSeparator);
    }

    public static void write(@NotNull Element element, @NotNull File file) throws IOException {
        JDOMUtil.write(element, file, "\n");
    }

    public static void write(@NotNull Element element, @NotNull File file, @Nullable String lineSeparator) throws IOException {
        FileUtil.createParentDirs(file);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), CharsetToolkit.UTF8_CHARSET));){
            JDOMUtil.writeElement(element, (Writer)writer, JDOMUtil.createOutputter(lineSeparator));
        }
    }

    public static void write(@NotNull Parent element, @NotNull File file) throws IOException {
        JDOMUtil.write(element, file, "\n");
    }

    public static void write(@NotNull Parent element, @NotNull File file, @NotNull String lineSeparator) throws IOException {
        FileUtil.createParentDirs(file);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            JDOMUtil.write(element, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        JDOMUtil.write((Parent)document, stream, lineSeparator);
    }

    public static void write(@NotNull Parent element, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, CharsetToolkit.UTF8_CHARSET);){
            if (element instanceof Document) {
                JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((Element)element, (Writer)writer, lineSeparator);
            }
        }
    }

    @NotNull
    public static String writeDocument(@NotNull Document document, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    @NotNull
    public static String write(@NotNull Element element) {
        return JDOMUtil.writeElement(element);
    }

    @NotNull
    public static String write(@NotNull Parent element, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.write(element, writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(Parent element, Writer writer, String lineSeparator) throws IOException {
        if (element instanceof Element) {
            JDOMUtil.writeElement((Element)element, writer, lineSeparator);
        } else if (element instanceof Document) {
            JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull Element element, Writer writer, String lineSeparator) throws IOException {
        JDOMUtil.writeElement(element, writer, JDOMUtil.createOutputter(lineSeparator));
    }

    public static void writeElement(@NotNull Element element, @NotNull Writer writer, @NotNull XMLOutputter xmlOutputter) throws IOException {
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element) {
        return JDOMUtil.writeElement(element, "\n");
    }

    @NotNull
    public static String writeElement(@NotNull Element element, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element, (Writer)writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static String writeChildren(@NotNull Element element, @NotNull String lineSeparator) throws IOException {
        StringWriter writer = new StringWriter();
        for (Element child : element.getChildren()) {
            JDOMUtil.writeElement(child, (Writer)writer, lineSeparator);
            writer.append(lineSeparator);
        }
        return writer.toString();
    }

    public static void writeDocument(@NotNull Document document, @NotNull Writer writer, String lineSeparator) throws IOException {
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static Format createFormat(@Nullable String lineSeparator) {
        return Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        return new MyXMLOutputter(JDOMUtil.createFormat(lineSeparator));
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(@NotNull String text) {
        return JDOMUtil.escapeText(text, false, false);
    }

    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeSpaces, boolean escapeLineEnds) {
        return JDOMUtil.escapeText(text, false, escapeSpaces, escapeLineEnds);
    }

    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        StringBuilder buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            buffer = XmlStringUtil.appendEscapedSymbol(text, buffer, i, quotation, ch);
        }
        return buffer == null ? text : buffer.toString();
    }

    private static void printDiagnostics(@NotNull Element element, String prefix) {
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element) {
        boolean hasNullAttributes = false;
        StringBuilder buf = new StringBuilder(element.getName());
        List<Attribute> attributes = JDOMUtil.getAttributes(element);
        int length = attributes.size();
        if (length > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                hasNullAttributes = true;
            }
            buf.append("]");
        }
        return new ElementInfo(buf, hasNullAttributes);
    }

    public static void updateFileSet(@NotNull File[] oldFiles, @NotNull String[] newFilePaths, @NotNull Document[] newFileDocuments, String lineSeparator) throws IOException {
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        for (String newFilePath : newFilePaths) {
            File file = new File(newFilePath);
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file : oldFiles) {
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is not writeable");
        }
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result = oldFile.delete();
            if (result) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || !element.hasAttributes() && element.getContent().isEmpty();
    }

    public static boolean isEmpty(@Nullable Element element, int attributeCount) {
        return element == null || JDOMUtil.getAttributes(element).size() == attributeCount && element.getContent().isEmpty();
    }

    @NotNull
    public static List<Attribute> getAttributes(@NotNull Element e) {
        return e.hasAttributes() ? e.getAttributes() : Collections.emptyList();
    }

    @Nullable
    public static Element merge(@Nullable Element to, @Nullable Element from) {
        if (from == null) {
            return to;
        }
        if (to == null) {
            return from;
        }
        Iterator<Object> iterator = from.getChildren().iterator();
        while (iterator.hasNext()) {
            Element configuration = (Element)iterator.next();
            iterator.remove();
            to.addContent(configuration);
        }
        iterator = JDOMUtil.getAttributes(from).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            iterator.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    @NotNull
    public static Element deepMerge(@NotNull Element to, @NotNull Element from) {
        Iterator<Object> iterator = from.getChildren().iterator();
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            iterator.remove();
            Element existingChild = to.getChild(child.getName());
            if (existingChild != null && JDOMUtil.isEmpty(existingChild)) {
                to.removeChild(child.getName());
                existingChild = null;
            }
            if (existingChild == null || existingChild.getChildren().isEmpty() || !JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(existingChild), JDOMUtil.getAttributes(child), false)) {
                to.addContent(child);
                continue;
            }
            JDOMUtil.deepMerge(existingChild, child);
        }
        iterator = JDOMUtil.getAttributes(from).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            iterator.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    @NotNull
    public static Element internElement(@NotNull Element element) {
        return ourJDOMInterner.internElement(element);
    }

    @NotNull
    public static String removeControlChars(@NotNull String text) {
        StringBuilder result = null;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Verifier.isXMLCharacter((int)c)) {
                if (result != null) continue;
                result = new StringBuilder(text.length());
                result.append(text, 0, i);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        return result == null ? text : result.toString();
    }

    private static class ElementInfo {
        @NotNull
        final CharSequence name;
        final boolean hasNullAttributes;

        private ElementInfo(@NotNull CharSequence name, boolean attributes) {
            this.name = name;
            this.hasNullAttributes = attributes;
        }
    }

    public static interface ElementOutputFilter {
        public boolean accept(@NotNull Element var1, int var2);
    }

    private static final class MyXMLOutputter
    extends XMLOutputter {
        MyXMLOutputter(@NotNull Format format) {
            super(format);
        }

        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            return JDOMUtil.escapeText(str, false, true);
        }

        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            return JDOMUtil.escapeText(str, false, false);
        }
    }

    private static class EmptyTextFilter
    implements Filter<Content> {
        private EmptyTextFilter() {
        }

        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.openapi.util.JDOMUtil");

        private LoggerHolder() {
        }
    }
}

