/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Key<T> {
    private static final AtomicInteger ourKeysCounter = new AtomicInteger();
    private static final IntObjectMap<Key<?>> allKeys = ContainerUtil.createConcurrentIntObjectWeakValueMap();
    private final int myIndex = ourKeysCounter.getAndIncrement();
    private final String myName;

    public Key(@NotNull String name) {
        this.myName = name;
        allKeys.put(this.myIndex, this);
    }

    public final int hashCode() {
        return this.myIndex;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public static <T> Key<T> create(@NotNull String name) {
        return new Key<T>(name);
    }

    public T get(@Nullable UserDataHolder holder) {
        return holder == null ? null : (T)holder.getUserData(this);
    }

    public T get(@Nullable Map<Key, ?> holder) {
        T t = holder == null ? null : (T)holder.get(this);
        return t;
    }

    @Contract(value="_, !null -> !null")
    public T get(@Nullable UserDataHolder holder, T defaultValue) {
        T t = this.get(holder);
        return t == null ? defaultValue : t;
    }

    @NotNull
    public T getRequired(@NotNull UserDataHolder holder) {
        return ObjectUtils.notNull(holder.getUserData(this));
    }

    public boolean isIn(@Nullable UserDataHolder holder) {
        return this.get(holder) != null;
    }

    public void set(@Nullable UserDataHolder holder, @Nullable T value) {
        if (holder != null) {
            holder.putUserData(this, value);
        }
    }

    public void set(@Nullable Map<Key, Object> holder, T value) {
        if (holder != null) {
            holder.put(this, value);
        }
    }

    @Nullable(value="can become null if the key has been gc-ed")
    public static <T> Key<T> getKeyByIndex(int index) {
        Key<?> key = allKeys.get(index);
        return key;
    }

    @Deprecated
    @Nullable
    public static Key<?> findKeyByName(String name) {
        for (IntObjectMap.Entry<Key<?>> key : allKeys.entrySet()) {
            if (!name.equals(key.getValue().myName)) continue;
            return key.getValue();
        }
        return null;
    }
}

