/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.MissingResourceException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.NotNull;

public class LowMemoryWatcherManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.LowMemoryWatcherManager");
    private static final long MEM_THRESHOLD = 0x500000L;
    @NotNull
    private final ExecutorService myExecutorService;
    private Future<?> mySubmitted;
    private final AtomicBoolean myProcessing = new AtomicBoolean();
    private final Consumer<Boolean> myJanitor = new Consumer<Boolean>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void consume(@NotNull Boolean afterGc) {
            Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
            synchronized (consumer) {
                LowMemoryWatcherManager.this.mySubmitted = null;
            }
            LowMemoryWatcher.onLowMemorySignalReceived(afterGc);
        }
    };
    private final NotificationListener myLowMemoryListener = new NotificationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification notification, Object __) {
            boolean memoryThreshold = "java.management.memory.threshold.exceeded".equals(notification.getType());
            boolean memoryCollectionThreshold = "java.management.memory.collection.threshold.exceeded".equals(notification.getType());
            if (memoryThreshold || memoryCollectionThreshold) {
                boolean afterGc = memoryCollectionThreshold;
                if (Registry.is("low.memory.watcher.sync", true)) {
                    LowMemoryWatcherManager.this.handleEventImmediately(afterGc);
                    return;
                }
                Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                synchronized (consumer) {
                    if (LowMemoryWatcherManager.this.mySubmitted == null) {
                        LowMemoryWatcherManager.this.mySubmitted = LowMemoryWatcherManager.this.myExecutorService.submit(() -> LowMemoryWatcherManager.this.myJanitor.consume(afterGc));
                    }
                }
            }
        }
    };

    public LowMemoryWatcherManager(@NotNull Executor executorService) {
        this.myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor("LowMemoryWatcherManager", executorService);
        try {
            for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                long max;
                long threshold;
                if (bean.getType() != MemoryType.HEAP || !bean.isCollectionUsageThresholdSupported() || !bean.isUsageThresholdSupported() || (threshold = Math.min((long)((double)(max = bean.getUsage().getMax()) * LowMemoryWatcherManager.getOccupiedMemoryThreshold()), max - 0x500000L)) <= 0L) continue;
                bean.setUsageThreshold(threshold);
                bean.setCollectionUsageThreshold(threshold);
            }
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this.myLowMemoryListener, null, null);
        }
        catch (Throwable e) {
            LOG.info("Errors initializing LowMemoryWatcher: ", e);
        }
    }

    private static double getOccupiedMemoryThreshold() {
        try {
            return Registry.doubleValue("low.memory.watcher.notification.threshold");
        }
        catch (MissingResourceException e) {
            return 0.95;
        }
    }

    private void handleEventImmediately(boolean afterGc) {
        if (this.myProcessing.compareAndSet(false, true)) {
            try {
                this.myJanitor.consume(afterGc);
            }
            finally {
                this.myProcessing.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.myLowMemoryListener);
        }
        catch (ListenerNotFoundException e) {
            LOG.error(e);
        }
        Consumer<Boolean> consumer = this.myJanitor;
        synchronized (consumer) {
            if (this.mySubmitted != null) {
                this.mySubmitted.cancel(false);
                this.mySubmitted = null;
            }
        }
        LowMemoryWatcher.stopAll();
    }
}

