/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NotNullLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("NotNullLazyKey");
    private final NotNullFunction<? super H, ? extends T> myFunction;

    private NotNullLazyKey(@NotNull @NonNls String name, @NotNull NotNullFunction<? super H, ? extends T> function) {
        super(name);
        this.myFunction = function;
    }

    @NotNull
    public final T getValue(@NotNull H h) {
        Object data = h.getUserData(this);
        if (data == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            data = this.myFunction.fun(h);
            if (stamp.mayCacheNow()) {
                if (h instanceof UserDataHolderEx) {
                    data = ((UserDataHolderEx)h).putUserDataIfAbsent(this, data);
                } else {
                    h.putUserData(this, data);
                }
            }
        }
        return data;
    }

    @NotNull
    public static <T, H extends UserDataHolder> NotNullLazyKey<T, H> create(@NonNls @NotNull String name, @NotNull NotNullFunction<? super H, ? extends T> function) {
        return new NotNullLazyKey<T, H>(name, function);
    }
}

