/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ShutDownTracker
implements Runnable {
    private final List<Thread> myThreads = new ArrayList<Thread>();
    private final LinkedList<Runnable> myShutdownTasks = new LinkedList();
    private final Thread myThread = new Thread((Runnable)this, "Shutdown tracker");

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(this.myThread);
    }

    @NotNull
    public static ShutDownTracker getInstance() {
        return ShutDownTrackerHolder.ourInstance;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myThread.isAlive();
    }

    @Override
    public void run() {
        Runnable task;
        this.ensureStopperThreadsFinished();
        while ((task = this.removeLast(this.myShutdownTasks)) != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                Logger.getInstance(ShutDownTracker.class).error(e);
            }
        }
    }

    public boolean waitFor(long timeout, @NotNull TimeUnit unit) {
        if (ShutDownTracker.isShutdownHookRunning()) {
            try {
                this.myThread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myThread.isAlive();
        }
        return false;
    }

    public final void ensureStopperThreadsFinished() {
        Thread[] threads = this.getStopperThreads();
        long started = System.currentTimeMillis();
        while (threads.length > 0) {
            Thread thread = threads[0];
            if (!thread.isAlive()) {
                if (this.isRegistered(thread)) {
                    Logger.getInstance(ShutDownTracker.class).error("Thread '" + thread.getName() + "' did not unregister itself from ShutDownTracker");
                    this.unregisterStopperThread(thread);
                }
            } else {
                long totalTimeWaited = System.currentTimeMillis() - started;
                if (totalTimeWaited > 3000L) {
                    thread.interrupt();
                }
                try {
                    thread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
    }

    private synchronized boolean isRegistered(@NotNull Thread thread) {
        return this.myThreads.contains(thread);
    }

    @NotNull
    private synchronized Thread[] getStopperThreads() {
        return this.myThreads.toArray(new Thread[0]);
    }

    public synchronized void registerStopperThread(@NotNull Thread thread) {
        this.myThreads.add(thread);
    }

    public synchronized void unregisterStopperThread(@NotNull Thread thread) {
        this.myThreads.remove(thread);
    }

    public synchronized void registerShutdownTask(@NotNull Runnable task) {
        this.myShutdownTasks.addLast(task);
    }

    public synchronized void unregisterShutdownTask(@NotNull Runnable task) {
        this.myShutdownTasks.remove(task);
    }

    private synchronized <T> T removeLast(@NotNull LinkedList<T> list) {
        return list.isEmpty() ? null : (T)list.removeLast();
    }

    private static class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();

        private ShutDownTrackerHolder() {
        }
    }
}

