/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.keyFMap.KeyFMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserDataHolderBase
implements UserDataHolderEx,
Cloneable {
    private static final Key<KeyFMap> COPYABLE_USER_MAP_KEY = Key.create("COPYABLE_USER_MAP_KEY");
    @NotNull
    private volatile KeyFMap myUserMap = KeyFMap.EMPTY_MAP;
    private static final AtomicFieldUpdater<UserDataHolderBase, KeyFMap> updater = AtomicFieldUpdater.forFieldOfType(UserDataHolderBase.class, KeyFMap.class);

    protected Object clone() {
        try {
            UserDataHolderBase clone = (UserDataHolderBase)super.clone();
            clone.setUserMap(KeyFMap.EMPTY_MAP);
            this.copyCopyableDataTo(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUserDataString() {
        KeyFMap userMap = this.getUserMap();
        KeyFMap copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        return userMap + (copyableMap == null ? "" : copyableMap.toString());
    }

    public void copyUserDataTo(@NotNull UserDataHolderBase other) {
        other.setUserMap(this.getUserMap());
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        T t = this.getUserMap().get(key);
        if (t == null && key instanceof KeyWithDefaultValue) {
            t = this.putUserDataIfAbsent(key, ((KeyWithDefaultValue)key).getDefaultValue());
        }
        return t;
    }

    @NotNull
    protected KeyFMap getUserMap() {
        return this.myUserMap;
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        KeyFMap map;
        KeyFMap newMap;
        do {
            map = this.getUserMap();
            KeyFMap keyFMap = newMap = value == null ? map.minus(key) : map.plus(key, value);
        } while (newMap != map && !this.changeUserMap(map, newMap));
    }

    protected boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
        return updater.compareAndSet(this, oldMap, newMap);
    }

    public <T> T getCopyableUserData(@NotNull Key<T> key) {
        KeyFMap map = this.getUserData(COPYABLE_USER_MAP_KEY);
        return map == null ? null : (T)map.get(key);
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, T value) {
        KeyFMap map;
        KeyFMap newMap;
        do {
            KeyFMap copyableMap;
            if ((copyableMap = (map = this.getUserMap()).get(COPYABLE_USER_MAP_KEY)) == null) {
                copyableMap = KeyFMap.EMPTY_MAP;
            }
            KeyFMap newCopyableMap = value == null ? copyableMap.minus(key) : copyableMap.plus(key, value);
            KeyFMap keyFMap = newMap = newCopyableMap.isEmpty() ? map.minus(COPYABLE_USER_MAP_KEY) : map.plus(COPYABLE_USER_MAP_KEY, newCopyableMap);
        } while (newMap != map && !this.changeUserMap(map, newMap));
    }

    @Override
    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        KeyFMap map;
        KeyFMap newMap;
        do {
            if ((map = this.getUserMap()).get(key) != oldValue) {
                return false;
            }
            KeyFMap keyFMap = newMap = newValue == null ? map.minus(key) : map.plus(key, newValue);
        } while (newMap != map && !this.changeUserMap(map, newMap));
        return true;
    }

    @Override
    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        KeyFMap map;
        KeyFMap newMap;
        do {
            T oldValue;
            if ((oldValue = (map = this.getUserMap()).get(key)) == null) continue;
            return oldValue;
        } while ((newMap = map.plus(key, value)) != map && !this.changeUserMap(map, newMap));
        return value;
    }

    public void copyCopyableDataTo(@NotNull UserDataHolderBase clone) {
        clone.putUserData(COPYABLE_USER_MAP_KEY, this.getUserData(COPYABLE_USER_MAP_KEY));
    }

    protected void clearUserData() {
        this.setUserMap(KeyFMap.EMPTY_MAP);
    }

    protected void setUserMap(@NotNull KeyFMap map) {
        this.myUserMap = map;
    }

    public boolean isUserDataEmpty() {
        return this.getUserMap().isEmpty();
    }
}

