/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.io.ByteSequence;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class ByteArraySequence
implements ByteSequence {
    private final byte[] myBytes;
    private final int myOffset;
    private final int myLen;

    public ByteArraySequence(@NotNull byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ByteArraySequence(@NotNull byte[] bytes, int offset, int len) {
        this.myBytes = bytes;
        this.myOffset = offset;
        this.myLen = len;
        if (offset < 0 || offset > bytes.length || offset + len > bytes.length || len < 0) {
            throw new IllegalArgumentException("Offset is out of range: " + offset + "; bytes.length: " + bytes.length + "; len: " + len);
        }
    }

    @NotNull
    public byte[] getBytes() {
        return this.myBytes;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLength() {
        return this.myLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArraySequence sequence = (ByteArraySequence)o;
        int len = this.myLen;
        if (len != sequence.myLen) {
            return false;
        }
        byte[] thisBytes = this.myBytes;
        byte[] thatBytes = sequence.myBytes;
        int i = 0;
        int j = this.myOffset;
        int k = sequence.myOffset;
        while (i < len) {
            if (thisBytes[j] != thatBytes[k]) {
                return false;
            }
            ++i;
            ++j;
            ++k;
        }
        return true;
    }

    public int hashCode() {
        int len = this.myLen;
        byte[] thisBytes = this.myBytes;
        int result = 1;
        int i = 0;
        int j = this.myOffset;
        while (i < len) {
            result = result * 31 + thisBytes[j];
            ++i;
            ++j;
        }
        return result;
    }

    @Override
    public int length() {
        return this.getLength();
    }

    @Override
    public byte byteAt(int index) {
        return this.myBytes[this.myOffset + index];
    }

    @Override
    @NotNull
    public ByteSequence subSequence(int start, int end) {
        return new ByteArraySequence(this.myBytes, this.myOffset + start, end - start);
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        byte[] bytes = new byte[this.length()];
        System.arraycopy(this.myBytes, this.myOffset, bytes, 0, this.length());
        return bytes;
    }

    @NotNull
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.getBytes(), this.getOffset(), this.getLength());
    }
}

