/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ObjectNode<T> {
    private static final ObjectNode[] EMPTY_ARRAY = new ObjectNode[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectNode");
    private final ObjectTree<T> myTree;
    private ObjectNode<T> myParent;
    private final T myObject;
    private List<ObjectNode<T>> myChildren;
    private final Throwable myTrace;
    private final long myOwnModification;

    ObjectNode(@NotNull ObjectTree<T> tree, @Nullable ObjectNode<T> parentNode, @NotNull T object, long modification) {
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object;
        this.myTrace = parentNode == null && Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
        this.myOwnModification = modification;
    }

    @NotNull
    private ObjectNode<T>[] getChildrenArray() {
        List<ObjectNode<ObjectNode>> children = this.myChildren;
        if (children == null || children.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return children.toArray(new ObjectNode[0]);
    }

    void addChild(@NotNull ObjectNode<T> child) {
        List<ObjectNode<T>> children = this.myChildren;
        if (children == null) {
            this.myChildren = new SmartList<ObjectNode<T>>(child);
        } else {
            children.add(child);
        }
        child.myParent = this;
    }

    void removeChild(@NotNull ObjectNode<T> child) {
        List<ObjectNode<T>> children = this.myChildren;
        if (children != null) {
            for (int i = children.size() - 1; i >= 0; --i) {
                ObjectNode<T> node = children.get(i);
                if (!node.equals(child)) continue;
                children.remove(i);
                break;
            }
        }
        child.myParent = null;
    }

    ObjectNode<T> getParent() {
        return this.myParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Collection<ObjectNode<T>> getChildren() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            if (this.myChildren == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableCollection(this.myChildren);
        }
    }

    void execute(final @NotNull ObjectTreeAction<T> action, final @NotNull List<Throwable> exceptions) {
        ObjectTree.executeActionWithRecursiveGuard(this, this.myTree.getNodesInExecution(), new ObjectTreeAction<ObjectNode<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(@NotNull ObjectNode<T> each) {
                ObjectNode[] childrenArray;
                if (ObjectNode.this.myTree.getDisposalInfo(ObjectNode.this.myObject) != null) {
                    return;
                }
                try {
                    action.beforeTreeExecution(ObjectNode.this.myObject);
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
                Object object = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                synchronized (object) {
                    childrenArray = ObjectNode.this.getChildrenArray();
                    ObjectNode.this.myChildren = null;
                }
                for (int i = childrenArray.length - 1; i >= 0; --i) {
                    try {
                        ObjectNode childNode = childrenArray[i];
                        childNode.execute(action, exceptions);
                        Object object2 = ((ObjectNode)ObjectNode.this).myTree.treeLock;
                        synchronized (object2) {
                            childNode.myParent = null;
                            continue;
                        }
                    }
                    catch (Throwable e) {
                        exceptions.add(e);
                    }
                }
                try {
                    action.execute(ObjectNode.this.myObject);
                    ObjectNode.this.myTree.fireExecuted(ObjectNode.this.myObject);
                }
                catch (Throwable e) {
                    exceptions.add(e);
                }
                ObjectNode.this.removeFromObjectTree();
            }

            @Override
            public void beforeTreeExecution(@NotNull ObjectNode<T> parent) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromObjectTree() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            this.myTree.putNode(this.myObject, null);
            if (this.myParent == null) {
                this.myTree.removeRootObject(this.myObject);
            }
        }
    }

    @NotNull
    T getObject() {
        return this.myObject;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject;
    }

    Throwable getTrace() {
        return this.myTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertNoReferencesKept(@NotNull T aDisposable) {
        assert (this.getObject() != aDisposable);
        Object object = this.myTree.treeLock;
        synchronized (object) {
            if (this.myChildren != null) {
                for (ObjectNode<T> node : this.myChildren) {
                    node.assertNoReferencesKept(aDisposable);
                }
            }
        }
    }

    long getOwnModification() {
        return this.myOwnModification;
    }

    long getModification() {
        return this.getOwnModification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <D extends Disposable> D findChildEqualTo(@NotNull D object) {
        Object object2 = this.myTree.treeLock;
        synchronized (object2) {
            List<ObjectNode<T>> children = this.myChildren;
            if (children != null) {
                for (ObjectNode<T> node : children) {
                    T nodeObject = node.getObject();
                    if (!nodeObject.equals(object)) continue;
                    return (D)((Disposable)nodeObject);
                }
            }
            return null;
        }
    }
}

