/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectTree<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
    private static final ThreadLocal<Throwable> ourTopmostDisposeTrace = new ThreadLocal();
    private final List<ObjectTreeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<T> myRootObjects = ContainerUtil.newIdentityTroveSet();
    private final Map<T, ObjectNode<T>> myObject2NodeMap = ContainerUtil.newIdentityTroveMap();
    private final Map<T, Object> myDisposedObjects = ContainerUtil.createWeakMap(100, 0.5f, ContainerUtil.identityStrategy());
    private final List<ObjectNode<T>> myExecutedNodes = new ArrayList<ObjectNode<T>>();
    private final List<T> myExecutedUnregisteredObjects = new ArrayList<T>();
    final Object treeLock = new Object();
    private final AtomicLong myModification = new AtomicLong(0L);

    ObjectNode<T> getNode(@NotNull T object) {
        return this.myObject2NodeMap.get(object);
    }

    void putNode(@NotNull T object, @Nullable(value="null means remove") ObjectNode<T> node) {
        if (node == null) {
            this.myObject2NodeMap.remove(object);
        } else {
            this.myObject2NodeMap.put(object, node);
        }
    }

    @NotNull
    final List<ObjectNode<T>> getNodesInExecution() {
        return this.myExecutedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull T parent, @NotNull T child) {
        if (parent == child) {
            throw new IllegalArgumentException("Cannot register to itself: " + parent);
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> childNode;
            Object wasDisposed = this.getDisposalInfo(parent);
            if (wasDisposed != null) {
                throw new IncorrectOperationException("Sorry but parent: " + parent + " has already been disposed (see the cause for stacktrace) so the child: " + child + " will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
            }
            if (this.isDisposing(parent)) {
                throw new IncorrectOperationException("Sorry but parent: " + parent + " is being disposed so the child: " + child + " will never be disposed");
            }
            this.myDisposedObjects.remove(child);
            ObjectNode<T> parentNode = this.getNode(parent);
            if (parentNode == null) {
                parentNode = this.createNodeFor(parent, null);
            }
            if ((childNode = this.getNode(child)) == null) {
                childNode = this.createNodeFor(child, parentNode);
            } else {
                ObjectNode<T> oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            this.checkWasNotAddedAlready(parentNode, childNode);
            parentNode.addChild(childNode);
            this.fireRegistered(childNode.getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDisposalInfo(@NotNull T object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            return this.myDisposedObjects.get(object);
        }
    }

    private void checkWasNotAddedAlready(ObjectNode<T> childNode, @NotNull ObjectNode<T> parentNode) {
        for (ObjectNode<T> node = childNode; node != null; node = node.getParent()) {
            if (node != parentNode) continue;
            throw new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
        }
    }

    @NotNull
    private ObjectNode<T> createNodeFor(@NotNull T object, @Nullable ObjectNode<T> parentNode) {
        ObjectNode<T> newNode = new ObjectNode<T>(this, parentNode, object, this.getNextModification());
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        return newNode;
    }

    private long getNextModification() {
        return this.myModification.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeAll(@NotNull T object, @NotNull ObjectTreeAction<T> action, boolean processUnregistered) {
        block17: {
            boolean needTrace;
            ObjectNode<T> node;
            Object object2 = this.treeLock;
            synchronized (object2) {
                node = this.getNode(object);
            }
            boolean bl = needTrace = (node != null || processUnregistered) && Disposer.isDebugMode() && ourTopmostDisposeTrace.get() == null;
            if (needTrace) {
                ourTopmostDisposeTrace.set(ThrowableInterner.intern(new Throwable()));
            }
            try {
                ObjectNode<T> parent;
                if (node == null) {
                    if (processUnregistered) {
                        this.rememberDisposedTrace(object);
                        this.executeUnregistered(object, action);
                    }
                    break block17;
                }
                SmartList<Throwable> exceptions = new SmartList<Throwable>();
                Object object3 = this.treeLock;
                synchronized (object3) {
                    parent = node.getParent();
                }
                node.execute(action, exceptions);
                if (parent != null) {
                    object3 = this.treeLock;
                    synchronized (object3) {
                        parent.removeChild(node);
                    }
                }
                ObjectTree.handleExceptions(exceptions);
            }
            finally {
                if (needTrace) {
                    ourTopmostDisposeTrace.remove();
                }
            }
        }
    }

    private static void handleExceptions(List<Throwable> exceptions) {
        if (!exceptions.isEmpty()) {
            for (Throwable exception : exceptions) {
                if (exception instanceof ProcessCanceledException) continue;
                LOG.error(exception);
            }
            ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
            if (pce != null) {
                throw pce;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposing(@NotNull T disposable) {
        List<ObjectNode<T>> guard;
        List<ObjectNode<T>> list = guard = this.getNodesInExecution();
        synchronized (list) {
            for (ObjectNode<T> node : guard) {
                if (node.getObject() != disposable) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull List<T> recursiveGuard, @NotNull ObjectTreeAction<? super T> action) {
        List<T> list = recursiveGuard;
        synchronized (list) {
            if (ArrayUtil.indexOf(recursiveGuard, object, ContainerUtil.identityStrategy()) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action.execute(object);
        }
        finally {
            list = recursiveGuard;
            synchronized (list) {
                int i = ArrayUtil.lastIndexOf(recursiveGuard, object, ContainerUtil.identityStrategy());
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(@NotNull T object, @NotNull ObjectTreeAction<? super T> action) {
        ObjectTree.executeActionWithRecursiveGuard(object, this.myExecutedUnregisteredObjects, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertNoReferenceKeptInTree(@NotNull T disposable) {
        Object object = this.treeLock;
        synchronized (object) {
            for (Map.Entry<T, ObjectNode<T>> entry : this.myObject2NodeMap.entrySet()) {
                T key = entry.getKey();
                assert (key != disposable);
                ObjectNode<T> node = entry.getValue();
                node.assertNoReferencesKept(disposable);
            }
        }
    }

    void removeRootObject(@NotNull T object) {
        this.myRootObjects.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertIsEmpty(boolean throwError) {
        Object object = this.treeLock;
        synchronized (object) {
            for (T object2 : this.myRootObjects) {
                ObjectNode<T> objectNode;
                if (object2 == null || (objectNode = this.getNode(object2)) == null) continue;
                while (objectNode.getParent() != null) {
                    objectNode = objectNode.getParent();
                }
                Throwable trace = objectNode.getTrace();
                RuntimeException exception = new RuntimeException("Memory leak detected: '" + object2 + "' of " + object2.getClass() + "\nSee the cause for the corresponding Disposer.register() stacktrace:\n", trace);
                if (throwError) {
                    throw exception;
                }
                LOG.error(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.myRootObjects.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Set<T> getRootObjects() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.myRootObjects;
        }
    }

    void addListener(@NotNull ObjectTreeListener listener) {
        this.myListeners.add(listener);
    }

    void removeListener(@NotNull ObjectTreeListener listener) {
        this.myListeners.remove(listener);
    }

    private void fireRegistered(@NotNull T object) {
        for (ObjectTreeListener each : this.myListeners) {
            each.objectRegistered(object);
        }
    }

    void fireExecuted(@NotNull T object) {
        for (ObjectTreeListener each : this.myListeners) {
            each.objectExecuted(object);
        }
        this.rememberDisposedTrace(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberDisposedTrace(@NotNull T object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            Throwable trace = ourTopmostDisposeTrace.get();
            this.myDisposedObjects.put(object, trace != null ? trace : Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.myObject2NodeMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <D extends Disposable> D findRegisteredObject(@NotNull T parentDisposable, @NotNull D object) {
        Object object2 = this.treeLock;
        synchronized (object2) {
            ObjectNode<T> parentNode = this.getNode(parentDisposable);
            if (parentNode == null) {
                return null;
            }
            return parentNode.findChildEqualTo(object);
        }
    }

    long getModification() {
        return this.myModification.get();
    }
}

