/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import java.awt.Color;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class Registry {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    public static final String REGISTRY_BUNDLE = "misc.registry";
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final ConcurrentMap<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private final Map<String, RegistryKeyDescriptor> myContributedKeys = new HashMap<String, RegistryKeyDescriptor>();
    private static final Registry ourInstance;

    @NotNull
    public static RegistryValue get(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) {
        Registry registry = Registry.getInstance();
        RegistryValue value = (RegistryValue)registry.myValues.get(key);
        if (value == null) {
            value = ConcurrencyUtil.cacheOrGet(registry.myValues, key, new RegistryValue(registry, key, registry.myContributedKeys.get(key)));
        }
        return value;
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, boolean defaultValue) {
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asInteger();
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, int defaultValue) {
        try {
            return Registry.get(key).asInteger();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static double doubleValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asDouble();
    }

    @NotNull
    public static String stringValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asString();
    }

    public static Color getColor(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, Color defaultValue) throws MissingResourceException {
        return Registry.get(key).asColor(defaultValue);
    }

    @NotNull
    static ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(REGISTRY_BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public String getBundleValue(@NotNull String key, boolean mustExist) throws MissingResourceException {
        if (this.myContributedKeys.containsKey(key)) {
            return this.myContributedKeys.get(key).getDefaultValue();
        }
        try {
            return Registry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    @NotNull
    public static Registry getInstance() {
        return ourInstance;
    }

    @NotNull
    public Element getState() {
        Element state = new Element("registry");
        for (String eachKey : this.myUserProperties.keySet()) {
            Element entry = new Element("entry");
            entry.setAttribute("key", eachKey);
            entry.setAttribute("value", this.myUserProperties.get(eachKey));
            state.addContent(entry);
        }
        return state;
    }

    public void loadState(@NotNull Element state) {
        this.myUserProperties.clear();
        for (Element eachEntry : state.getChildren("entry")) {
            RegistryValue registryValue;
            String key = eachEntry.getAttributeValue("key");
            String value = eachEntry.getAttributeValue("value");
            if (key == null || value == null || !(registryValue = Registry.get(key)).isChangedFromDefault(value)) continue;
            this.myUserProperties.put(key, value);
            registryValue.resetCache();
        }
    }

    @NotNull
    Map<String, String> getUserProperties() {
        return this.myUserProperties;
    }

    @NotNull
    public static List<RegistryValue> getAll() {
        ResourceBundle bundle = Registry.getBundle();
        Enumeration<String> keys = bundle.getKeys();
        ArrayList<RegistryValue> result = new ArrayList<RegistryValue>();
        Map<String, RegistryKeyDescriptor> contributedKeys = Registry.getInstance().myContributedKeys;
        while (keys.hasMoreElements()) {
            String each = keys.nextElement();
            if (each.endsWith(".description") || each.endsWith(".restartRequired") || contributedKeys.containsKey(each)) continue;
            result.add(Registry.get(each));
        }
        for (String key : contributedKeys.keySet()) {
            result.add(Registry.get(key));
        }
        return result;
    }

    void restoreDefaults() {
        HashMap<String, String> old = new HashMap<String, String>(this.myUserProperties);
        for (String each : old.keySet()) {
            try {
                Registry.get(each).resetToDefault();
            }
            catch (MissingResourceException e) {
                this.myValues.remove(each);
            }
        }
    }

    boolean isInDefaultState() {
        return this.myUserProperties.isEmpty();
    }

    boolean isRestartNeeded() {
        return Registry.isRestartNeeded(this.myUserProperties);
    }

    private static boolean isRestartNeeded(@NotNull Map<String, String> map) {
        for (String s : map.keySet()) {
            RegistryValue eachValue = Registry.get(s);
            if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
            return true;
        }
        return false;
    }

    public static void addKey(@NotNull String key, @NotNull String description, @NotNull String defaultValue, boolean restartRequired) {
        Registry.addKey(key, description, defaultValue, restartRequired, false);
    }

    public static void addKey(@NotNull String key, @NotNull String description, @NotNull String defaultValue, boolean restartRequired, boolean contributedByThirdPartyPlugin) {
        Registry.getInstance().myContributedKeys.put(key, new RegistryKeyDescriptor(key, description, defaultValue, restartRequired, contributedByThirdPartyPlugin));
    }

    public static void addKey(@NotNull String key, @NotNull String description, int defaultValue, boolean restartRequired) {
        Registry.addKey(key, description, Integer.toString(defaultValue), restartRequired);
    }

    public static void addKey(@NotNull String key, @NotNull String description, boolean defaultValue, boolean restartRequired) {
        Registry.addKey(key, description, Boolean.toString(defaultValue), restartRequired);
    }

    static {
        ourInstance = new Registry();
    }
}

