/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.psi.codeStyle.MatcherWithFallback;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcherImpl;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ui.KeyboardLayoutUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixingLayoutMatcher
extends MatcherWithFallback {
    public FixingLayoutMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        super(new MinusculeMatcherImpl(pattern, options, hardSeparators), FixingLayoutMatcher.withFixedLayout(pattern, options, hardSeparators));
    }

    @Nullable
    public static String fixLayout(String pattern) {
        boolean hasLetters = false;
        boolean onlyWrongLetters = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (!Character.isLetter(c)) continue;
            hasLetters = true;
            if (c > '\u007f') continue;
            onlyWrongLetters = false;
            break;
        }
        if (hasLetters && onlyWrongLetters) {
            char[] alternatePattern = new char[pattern.length()];
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                Character newC = KeyboardLayoutUtil.getAsciiForChar(c);
                alternatePattern[i] = newC == null ? c : newC.charValue();
            }
            return new String(alternatePattern);
        }
        return null;
    }

    @Nullable
    private static MinusculeMatcher withFixedLayout(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        String s = FixingLayoutMatcher.fixLayout(pattern);
        if (s != null && !s.equals(pattern)) {
            return new MinusculeMatcherImpl(s, options, hardSeparators);
        }
        return null;
    }
}

