/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.FixingLayoutTypoTolerantMatcher;
import com.intellij.psi.codeStyle.MatcherWithFallback;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NameUtil {
    private static final Function<String, String> LOWERCASE_MAPPING = String::toLowerCase;
    private static final int MAX_LENGTH = 40;

    private NameUtil() {
    }

    @NotNull
    public static List<String> nameToWordsLowerCase(@NotNull String name) {
        return ContainerUtil.map(NameUtil.nameToWords(name), LOWERCASE_MAPPING);
    }

    @NotNull
    public static String[] nameToWords(@NotNull String name) {
        ArrayList<String> array = new ArrayList<String>();
        int index = 0;
        while (index < name.length()) {
            String word;
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            if (StringUtil.isEmptyOrSpaces(word = name.substring(wordStart, index))) continue;
            array.add(word);
        }
        return ArrayUtil.toStringArray(array);
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        return NameUtil.buildRegexp(pattern, exactPrefixLen, allowToUpper, allowToLower, false, false);
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords, boolean forCompletion) {
        boolean endsWithSpace;
        int eol = pattern.indexOf(10);
        if (eol != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 40) {
            pattern = pattern.substring(0, 40);
        }
        StringBuilder buffer = new StringBuilder();
        boolean bl = endsWithSpace = !forCompletion && StringUtil.endsWithChar(pattern, ' ');
        if (!forCompletion) {
            pattern = pattern.trim();
        }
        exactPrefixLen = Math.min(exactPrefixLen, pattern.length());
        boolean prevIsUppercase = false;
        if (exactPrefixLen > 0) {
            char c = pattern.charAt(exactPrefixLen - 1);
            prevIsUppercase = Character.isUpperCase(c) || Character.isDigit(c);
        }
        for (int i = 0; i != exactPrefixLen; ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append("\\").append(c);
        }
        if (exactPrefixLen == 0) {
            buffer.append("_*");
        }
        boolean firstIdentifierLetter = exactPrefixLen == 0;
        boolean lastIsUppercase = false;
        for (int i = exactPrefixLen; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            lastIsUppercase = false;
            if (Character.isLetterOrDigit(c)) {
                prevIsUppercase = false;
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    prevIsUppercase = true;
                    lastIsUppercase = true;
                    buffer.append('(');
                    if (!firstIdentifierLetter) {
                        buffer.append("[a-z\\s0-9\\$]*");
                    }
                    buffer.append(c);
                    if (allowToLower) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    if (!firstIdentifierLetter) {
                        buffer.append("|[A-Za-z\\s0-9\\$]*[_-]+[");
                        buffer.append(c);
                        buffer.append(Character.toLowerCase(c));
                        buffer.append("]");
                    }
                    buffer.append(')');
                } else if (Character.isLowerCase(c) && allowToUpper) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                    if (lowerCaseWords) {
                        buffer.append("([a-z\\s0-9\\$]*[-_]+)?");
                    }
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                if (!firstIdentifierLetter) {
                    buffer.append("[a-z\\s0-9\\$]*\\.");
                } else {
                    buffer.append("\\.");
                }
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ' ') {
                buffer.append("([a-z\\s0-9\\$_-]*[\\ _-]+)+");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ':' || prevIsUppercase) {
                buffer.append("[A-Za-z\\s0-9\\$]*");
            }
            firstIdentifierLetter = true;
            buffer.append("\\").append(c);
        }
        if (!endsWithSpace) {
            buffer.append(".*");
        } else if (lastIsUppercase) {
            buffer.append("[a-z\\s0-9\\$]*");
        }
        return buffer.toString();
    }

    @NotNull
    public static String[] splitNameIntoWords(@NotNull String name) {
        String[] underlineDelimited = name.split("_");
        ArrayList<String> result = new ArrayList<String>();
        for (String word : underlineDelimited) {
            NameUtil.addAllWords(word, result);
        }
        return ArrayUtil.toStringArray(result);
    }

    @NotNull
    public static List<String> getSuggestionsByName(@NotNull String name, @NotNull String prefix, @NotNull String suffix, boolean upperCaseStyle, boolean preferLongerNames, boolean isArray) {
        ArrayList<String> answer = new ArrayList<String>();
        String[] words = NameUtil.nameToWords(name);
        for (int step = 0; step < words.length; ++step) {
            int wordCount = preferLongerNames ? words.length - step : step + 1;
            String startWord = words[words.length - wordCount];
            char c = startWord.charAt(0);
            if (c == '_' || !Character.isJavaIdentifierStart(c)) continue;
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, false) + suffix);
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, true) + suffix);
        }
        return answer;
    }

    @NotNull
    private static String compoundSuggestion(@NotNull String prefix, boolean upperCaseStyle, @NotNull String[] words, int wordCount, @NotNull String startWord, char c, boolean isArray, boolean skip_) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        startWord = upperCaseStyle ? StringUtil.toUpperCase(startWord) : (prefix.isEmpty() || StringUtil.endsWithChar(prefix, '_') ? startWord.toLowerCase() : Character.toUpperCase(c) + startWord.substring(1));
        buffer.append(startWord);
        for (int i = words.length - wordCount + 1; i < words.length; ++i) {
            String word = words[i];
            String prevWord = words[i - 1];
            if (upperCaseStyle) {
                word = StringUtil.toUpperCase(word);
                if (prevWord.charAt(prevWord.length() - 1) != '_' && word.charAt(0) != '_') {
                    word = "_" + word;
                }
            } else {
                if (prevWord.charAt(prevWord.length() - 1) == '_') {
                    word = word.toLowerCase();
                }
                if (skip_) {
                    if (word.equals("_")) continue;
                    if (prevWord.equals("_")) {
                        word = StringUtil.capitalize(word);
                    }
                }
            }
            buffer.append(word);
        }
        String suggestion = buffer.toString();
        if (isArray) {
            suggestion = StringUtil.pluralize(suggestion);
            if (upperCaseStyle) {
                suggestion = StringUtil.toUpperCase(suggestion);
            }
        }
        return suggestion;
    }

    static int nextWord(@NotNull String text, int start) {
        int i;
        if (!Character.isLetterOrDigit(text.charAt(start))) {
            return start + 1;
        }
        for (i = start; i < text.length() && Character.isDigit(text.charAt(i)); ++i) {
        }
        if (i > start) {
            return i;
        }
        while (i < text.length() && Character.isUpperCase(text.charAt(i))) {
            ++i;
        }
        if (i > start + 1) {
            if (i == text.length() || !Character.isLetter(text.charAt(i))) {
                return i;
            }
            return i - 1;
        }
        if (i == start) {
            ++i;
        }
        while (i < text.length() && Character.isLetter(text.charAt(i)) && !NameUtil.isWordStart(text, i)) {
            ++i;
        }
        return i;
    }

    private static void addAllWords(@NotNull String text, @NotNull List<? super String> result) {
        int start = 0;
        while (start < text.length()) {
            int next = NameUtil.nextWord(text, start);
            result.add(text.substring(start, next));
            start = next;
        }
    }

    static boolean isWordStart(String text, int i) {
        char c = text.charAt(i);
        if (Character.isUpperCase(c)) {
            if (i > 0 && Character.isUpperCase(text.charAt(i - 1))) {
                return i + 1 < text.length() && Character.isLowerCase(text.charAt(i + 1));
            }
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        if (!Character.isLetter(c)) {
            return false;
        }
        return i == 0 || !Character.isLetterOrDigit(text.charAt(i - 1)) || NameUtil.isHardCodedWordStart(text, i);
    }

    private static boolean isHardCodedWordStart(String text, int i) {
        return text.charAt(i) == 'l' && i < text.length() - 1 && text.charAt(i + 1) == 'n' && (text.length() == i + 2 || NameUtil.isWordStart(text, i + 2));
    }

    @NotNull
    public static com.intellij.util.text.Matcher buildMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        return NameUtil.buildMatcher(pattern, options);
    }

    @Deprecated
    @NotNull
    public static com.intellij.util.text.Matcher buildMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords) {
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        return NameUtil.buildMatcher(pattern, options);
    }

    @NotNull
    public static MatcherBuilder buildMatcher(@NotNull String pattern) {
        return new MatcherBuilder(pattern);
    }

    @NotNull
    public static MinusculeMatcher buildMatcher(@NotNull String pattern, @NotNull MatchingCaseSensitivity options) {
        return NameUtil.buildMatcher(pattern).withCaseSensitivity(options).build();
    }

    public static MinusculeMatcher buildMatcherWithFallback(@NotNull String pattern, @NotNull String fallbackPattern, @NotNull MatchingCaseSensitivity options) {
        return pattern.equals(fallbackPattern) ? NameUtil.buildMatcher(pattern, options) : new MatcherWithFallback(NameUtil.buildMatcher(pattern, options), NameUtil.buildMatcher(fallbackPattern, options));
    }

    @NotNull
    public static String capitalizeAndUnderscore(@NotNull String name) {
        return NameUtil.splitWords(name, '_', StringUtil::toUpperCase);
    }

    @NotNull
    public static String splitWords(@NotNull String text, char separator, @NotNull Function<? super String, String> transformWord) {
        String[] words = NameUtil.nameToWords(text);
        boolean insertSeparator = false;
        StringBuilder buf = new StringBuilder();
        for (String word : words) {
            if (!Character.isLetterOrDigit(word.charAt(0))) {
                buf.append(separator);
                insertSeparator = false;
                continue;
            }
            if (insertSeparator) {
                buf.append(separator);
            } else {
                insertSeparator = true;
            }
            buf.append(transformWord.fun(word));
        }
        return buf.toString();
    }

    public static enum MatchingCaseSensitivity {
        NONE,
        FIRST_LETTER,
        ALL;

    }

    public static class MatcherBuilder {
        private final String pattern;
        private String separators = "";
        private MatchingCaseSensitivity caseSensitivity = MatchingCaseSensitivity.NONE;

        public MatcherBuilder(String pattern) {
            this.pattern = pattern;
        }

        public MatcherBuilder withCaseSensitivity(MatchingCaseSensitivity caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
            return this;
        }

        public MatcherBuilder withSeparators(String separators) {
            this.separators = separators;
            return this;
        }

        public MinusculeMatcher build() {
            return Registry.is("ide.completion.typo.tolerance") ? FixingLayoutTypoTolerantMatcher.create(this.pattern, this.caseSensitivity, this.separators) : new FixingLayoutMatcher(this.pattern, this.caseSensitivity, this.separators);
        }
    }

    @Deprecated
    public static interface Matcher {
        public boolean matches(@NotNull String var1);
    }
}

