/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public interface PopupBorder
extends Border {
    public void setActive(boolean var1);

    public static class BaseBorder
    implements PopupBorder {
        private final boolean myVisible;
        private final Color myActiveColor;
        private final Color myPassiveColor;
        private boolean myActive;

        protected BaseBorder() {
            this(false, null, null);
        }

        protected BaseBorder(boolean visible, Color activeColor, Color passiveColor) {
            this.myVisible = visible;
            this.myActiveColor = activeColor;
            this.myPassiveColor = passiveColor;
        }

        @Override
        public void setActive(boolean active) {
            this.myActive = active;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!this.myVisible) {
                return;
            }
            Color color = this.myActive ? this.myActiveColor : this.myPassiveColor;
            g.setColor(color);
            RectanglePainter.DRAW.paint((Graphics2D)g, x, y, width, height, null);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myVisible ? JBUI.insets(1) : JBUI.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class Factory {
        private Factory() {
        }

        @NotNull
        public static PopupBorder createEmpty() {
            return new BaseBorder();
        }

        @NotNull
        public static PopupBorder create(boolean active, boolean windowWithShadow) {
            boolean visible = !SystemInfo.isMac || !windowWithShadow || UIManager.getBoolean("Popup.paintBorder") == Boolean.TRUE;
            BaseBorder border = new BaseBorder(visible, JBUI.CurrentTheme.Popup.borderColor(true), JBUI.CurrentTheme.Popup.borderColor(false));
            border.setActive(active);
            return border;
        }

        public static PopupBorder createColored(Color color) {
            BaseBorder border = new BaseBorder(true, color, color);
            border.setActive(true);
            return border;
        }
    }
}

