/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.ui.mac.foundation.FoundationLibrary;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.ImageLoader;
import com.sun.jna.Callback;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Foundation {
    private static final FoundationLibrary myFoundationLibrary;
    private static Callback ourRunnableCallback;
    private static final Map<String, RunnableInfo> ourMainThreadRunnables;
    private static long ourCurrentRunnableCount;
    private static final Object RUNNABLE_LOCK;

    public static void init() {
    }

    private Foundation() {
    }

    public static ID getObjcClass(String className) {
        return myFoundationLibrary.objc_getClass(className);
    }

    public static ID getProtocol(String name) {
        return myFoundationLibrary.objc_getProtocol(name);
    }

    public static Pointer createSelector(String s) {
        return myFoundationLibrary.sel_registerName(s);
    }

    public static ID invoke(ID id, Pointer selector, Object ... args) {
        return myFoundationLibrary.objc_msgSend(id, selector, args);
    }

    public static ID invoke(String cls, String selector, Object ... args) {
        return Foundation.invoke(Foundation.getObjcClass(cls), Foundation.createSelector(selector), args);
    }

    public static ID safeInvoke(String stringCls, String stringSelector, Object ... args) {
        ID cls = Foundation.getObjcClass(stringCls);
        Pointer selector = Foundation.createSelector(stringSelector);
        if (Foundation.invoke(cls, "respondsToSelector:", selector).intValue() == 0) {
            throw new RuntimeException(String.format("Missing selector %s for %s", stringSelector, stringCls));
        }
        return Foundation.invoke(cls, selector, args);
    }

    public static ID invoke(ID id, String selector, Object ... args) {
        return Foundation.invoke(id, Foundation.createSelector(selector), args);
    }

    public static double invoke_fpret(ID receiver, Pointer selector, Object ... args) {
        return myFoundationLibrary.objc_msgSend_fpret(receiver, selector, args);
    }

    public static double invoke_fpret(ID receiver, String selector, Object ... args) {
        return myFoundationLibrary.objc_msgSend_fpret(receiver, Foundation.createSelector(selector), args);
    }

    public static boolean isNil(ID id) {
        return id == null || ID.NIL.equals((Object)id);
    }

    public static ID safeInvoke(ID id, String stringSelector, Object ... args) {
        Pointer selector = Foundation.createSelector(stringSelector);
        if (!id.equals((Object)ID.NIL) && Foundation.invoke(id, "respondsToSelector:", selector).intValue() == 0) {
            throw new RuntimeException(String.format("Missing selector %s for %s", stringSelector, Foundation.toStringViaUTF8(Foundation.invoke(id, "description", new Object[0]))));
        }
        return Foundation.invoke(id, selector, args);
    }

    public static ID allocateObjcClassPair(ID superCls, String name) {
        return myFoundationLibrary.objc_allocateClassPair(superCls, name, 0);
    }

    public static void registerObjcClassPair(ID cls) {
        myFoundationLibrary.objc_registerClassPair(cls);
    }

    public static boolean isClassRespondsToSelector(ID cls, Pointer selectorName) {
        return myFoundationLibrary.class_respondsToSelector(cls, selectorName);
    }

    public static boolean addMethod(ID cls, Pointer selectorName, Callback impl, String types) {
        return myFoundationLibrary.class_addMethod(cls, selectorName, impl, types);
    }

    public static boolean addProtocol(ID aClass, ID protocol) {
        return myFoundationLibrary.class_addProtocol(aClass, protocol);
    }

    public static boolean addMethodByID(ID cls, Pointer selectorName, ID impl, String types) {
        return myFoundationLibrary.class_addMethod(cls, selectorName, impl, types);
    }

    public static boolean isMetaClass(ID cls) {
        return myFoundationLibrary.class_isMetaClass(cls);
    }

    @Nullable
    public static String stringFromSelector(Pointer selector) {
        ID id = myFoundationLibrary.NSStringFromSelector(selector);
        if (id.intValue() > 0) {
            return Foundation.toStringViaUTF8(id);
        }
        return null;
    }

    public static Pointer getClass(Pointer clazz) {
        return myFoundationLibrary.objc_getClass(clazz);
    }

    public static String fullUserName() {
        return Foundation.toStringViaUTF8(myFoundationLibrary.NSFullUserName());
    }

    public static ID class_replaceMethod(ID cls, Pointer selector, Callback impl, String types) {
        return myFoundationLibrary.class_replaceMethod(cls, selector, impl, types);
    }

    public static ID getMetaClass(String className) {
        return myFoundationLibrary.objc_getMetaClass(className);
    }

    public static boolean isPackageAtPath(@NotNull String path) {
        ID workspace = Foundation.invoke("NSWorkspace", "sharedWorkspace", new Object[0]);
        ID result = Foundation.invoke(workspace, Foundation.createSelector("isFilePackageAtPath:"), new Object[]{Foundation.nsString(path)});
        return result.intValue() == 1;
    }

    public static boolean isPackageAtPath(@NotNull File file) {
        if (!file.isDirectory()) {
            return false;
        }
        return Foundation.isPackageAtPath(file.getPath());
    }

    @NotNull
    public static ID nsString(@Nullable String s) {
        return s == null ? ID.NIL : NSString.create(s);
    }

    public static ID nsUUID(@NotNull UUID uuid) {
        return Foundation.nsUUID(uuid.toString());
    }

    public static ID nsUUID(@NotNull String uuid) {
        return Foundation.invoke(Foundation.invoke(Foundation.invoke("NSUUID", "alloc", new Object[0]), "initWithUUIDString:", new Object[]{Foundation.nsString(uuid)}), "autorelease", new Object[0]);
    }

    @Nullable
    public static String toStringViaUTF8(ID cfString) {
        if (cfString.intValue() == 0) {
            return null;
        }
        int lengthInChars = myFoundationLibrary.CFStringGetLength(cfString);
        int potentialLengthInBytes = 3 * lengthInChars + 1;
        byte[] buffer = new byte[potentialLengthInBytes];
        byte ok = myFoundationLibrary.CFStringGetCString(cfString, buffer, buffer.length, 0x8000100);
        if (ok == 0) {
            throw new RuntimeException("Could not convert string");
        }
        return Native.toString((byte[])buffer);
    }

    @Nullable
    public static String getNSErrorText(@Nullable ID error) {
        if (error == null || error.byteValue() == 0) {
            return null;
        }
        String description = Foundation.toStringViaUTF8(Foundation.invoke(error, "localizedDescription", new Object[0]));
        String recovery = Foundation.toStringViaUTF8(Foundation.invoke(error, "localizedRecoverySuggestion", new Object[0]));
        if (recovery != null) {
            description = description + "\n" + recovery;
        }
        return StringUtil.notNullize(description);
    }

    @Nullable
    public static String getEncodingName(long nsStringEncoding) {
        long cfEncoding = myFoundationLibrary.CFStringConvertNSStringEncodingToEncoding(nsStringEncoding);
        ID pointer = myFoundationLibrary.CFStringConvertEncodingToIANACharSetName(cfEncoding);
        String name = Foundation.toStringViaUTF8(pointer);
        if ("macintosh".equals(name)) {
            name = "MacRoman";
        }
        return name;
    }

    public static long getEncodingCode(@Nullable String encodingName) {
        if (StringUtil.isEmptyOrSpaces(encodingName)) {
            return -1L;
        }
        ID converted = Foundation.nsString(encodingName);
        long cfEncoding = myFoundationLibrary.CFStringConvertIANACharSetNameToEncoding(converted);
        ID restored = myFoundationLibrary.CFStringConvertEncodingToIANACharSetName(cfEncoding);
        if (ID.NIL.equals((Object)restored)) {
            return -1L;
        }
        return Foundation.convertCFEncodingToNS(cfEncoding);
    }

    private static long convertCFEncodingToNS(long cfEncoding) {
        return myFoundationLibrary.CFStringConvertEncodingToNSStringEncoding(cfEncoding) & 0xFFFFFFFFFFL;
    }

    public static void cfRetain(ID id) {
        myFoundationLibrary.CFRetain(id);
    }

    public static ID cgWindowListCreateImage(NSRect screenBounds, int windowOption, ID windowID, int imageOption) {
        return myFoundationLibrary.CGWindowListCreateImage(screenBounds, windowOption, windowID, imageOption);
    }

    public static void cfRelease(ID ... ids) {
        for (ID id : ids) {
            if (id == null) continue;
            myFoundationLibrary.CFRelease(id);
        }
    }

    public static ID autorelease(ID id) {
        return Foundation.invoke(id, "autorelease", new Object[0]);
    }

    public static boolean isMainThread() {
        return Foundation.invoke("NSThread", "isMainThread", new Object[0]).intValue() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeOnMainThread(boolean withAutoreleasePool, boolean waitUntilDone, Runnable runnable) {
        String runnableCountString;
        Object object = RUNNABLE_LOCK;
        synchronized (object) {
            Foundation.initRunnableSupport();
            runnableCountString = String.valueOf(++ourCurrentRunnableCount);
            ourMainThreadRunnables.put(runnableCountString, new RunnableInfo(runnable, withAutoreleasePool));
        }
        ID ideaRunnable = Foundation.getObjcClass("IdeaRunnable");
        ID runnableObject = Foundation.invoke(Foundation.invoke(ideaRunnable, "alloc", new Object[0]), "init", new Object[0]);
        ID keyObject = Foundation.invoke(Foundation.nsString(runnableCountString), "retain", new Object[0]);
        Foundation.invoke(runnableObject, "performSelectorOnMainThread:withObject:waitUntilDone:", new Object[]{Foundation.createSelector("run:"), keyObject, waitUntilDone});
        Foundation.invoke(runnableObject, "release", new Object[0]);
    }

    private static void initRunnableSupport() {
        if (ourRunnableCallback == null) {
            ID runnableClass = Foundation.allocateObjcClassPair(Foundation.getObjcClass("NSObject"), "IdeaRunnable");
            Foundation.registerObjcClassPair(runnableClass);
            Callback callback = new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void callback(ID self, String selector, ID keyObject) {
                    RunnableInfo info;
                    String key = Foundation.toStringViaUTF8(keyObject);
                    Foundation.invoke(keyObject, "release", new Object[0]);
                    Object object = RUNNABLE_LOCK;
                    synchronized (object) {
                        info = (RunnableInfo)ourMainThreadRunnables.remove(key);
                    }
                    if (info == null) {
                        return;
                    }
                    ID pool = null;
                    try {
                        if (info.myUseAutoreleasePool) {
                            pool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
                        }
                        info.myRunnable.run();
                    }
                    finally {
                        if (pool != null) {
                            Foundation.invoke(pool, "release", new Object[0]);
                        }
                    }
                }
            };
            if (!Foundation.addMethod(runnableClass, Foundation.createSelector("run:"), callback, "v@:*")) {
                throw new RuntimeException("Unable to add method to objective-c runnableClass class!");
            }
            ourRunnableCallback = callback;
        }
    }

    public static ID fillArray(Object[] a) {
        ID result = Foundation.invoke("NSMutableArray", "array", new Object[0]);
        for (Object s : a) {
            Foundation.invoke(result, "addObject:", Foundation.convertType(s));
        }
        return result;
    }

    public static ID createDict(@NotNull String[] keys, @NotNull Object[] values) {
        ID nsKeys = Foundation.invoke("NSArray", "arrayWithObjects:", Foundation.convertTypes(keys));
        ID nsData = Foundation.invoke("NSArray", "arrayWithObjects:", Foundation.convertTypes(values));
        return Foundation.invoke("NSDictionary", "dictionaryWithObjects:forKeys:", new Object[]{nsData, nsKeys});
    }

    @NotNull
    public static PointerType createPointerReference() {
        PointerByReference reference = new PointerByReference((Pointer)new Memory((long)Native.POINTER_SIZE));
        reference.getPointer().clear((long)Native.POINTER_SIZE);
        return reference;
    }

    @NotNull
    public static ID castPointerToNSError(@NotNull PointerType pointerType) {
        return new ID(pointerType.getPointer().getLong(0L));
    }

    private static Object[] convertTypes(@NotNull Object[] v) {
        Object[] result = new Object[v.length];
        for (int i = 0; i < v.length; ++i) {
            result[i] = Foundation.convertType(v[i]);
        }
        return result;
    }

    private static Object convertType(@NotNull Object o) {
        if (o instanceof Pointer || o instanceof ID) {
            return o;
        }
        if (o instanceof String) {
            return Foundation.nsString((String)o);
        }
        throw new IllegalArgumentException("Unsupported type! " + o.getClass());
    }

    static /* synthetic */ long access$000(long x0) {
        return Foundation.convertCFEncodingToNS(x0);
    }

    static {
        System.setProperty("jna.encoding", "UTF8");
        HashMap foundationOptions = new HashMap();
        myFoundationLibrary = (FoundationLibrary)Native.loadLibrary((String)"Foundation", FoundationLibrary.class, foundationOptions);
        ourMainThreadRunnables = new HashMap<String, RunnableInfo>();
        ourCurrentRunnableCount = 0L;
        RUNNABLE_LOCK = new Object();
    }

    public static class CGFloat
    implements NativeMapped {
        private final double value;

        public CGFloat() {
            this(0.0);
        }

        public CGFloat(double d) {
            this.value = d;
        }

        public Object fromNative(Object o, FromNativeContext fromNativeContext) {
            switch (Native.LONG_SIZE) {
                case 4: {
                    return new CGFloat(((Float)o).floatValue());
                }
                case 8: {
                    return new CGFloat((Double)o);
                }
            }
            throw new IllegalStateException();
        }

        public Object toNative() {
            switch (Native.LONG_SIZE) {
                case 4: {
                    return Float.valueOf((float)this.value);
                }
                case 8: {
                    return this.value;
                }
            }
            throw new IllegalStateException();
        }

        public Class<?> nativeType() {
            switch (Native.LONG_SIZE) {
                case 4: {
                    return Float.class;
                }
                case 8: {
                    return Double.class;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class NSSize
    extends Structure
    implements Structure.ByValue {
        private static final List __FIELDS = Arrays.asList("width", "height");
        public CGFloat width;
        public CGFloat height;

        public NSSize() {
            this(0.0, 0.0);
        }

        public NSSize(double width, double height) {
            this.width = new CGFloat(width);
            this.height = new CGFloat(height);
        }

        protected List getFieldOrder() {
            return __FIELDS;
        }
    }

    public static class NSPoint
    extends Structure
    implements Structure.ByValue {
        private static final List __FIELDS = Arrays.asList("x", "y");
        public CGFloat x;
        public CGFloat y;

        public NSPoint() {
            this(0.0, 0.0);
        }

        public NSPoint(double x, double y) {
            this.x = new CGFloat(x);
            this.y = new CGFloat(y);
        }

        protected List getFieldOrder() {
            return __FIELDS;
        }
    }

    public static class NSRect
    extends Structure
    implements Structure.ByValue {
        private static final List __FIELDS = Arrays.asList("origin", "size");
        public NSPoint origin;
        public NSSize size;

        public NSRect(double x, double y, double w, double h) {
            this.origin = new NSPoint(x, y);
            this.size = new NSSize(w, h);
        }

        protected List getFieldOrder() {
            return __FIELDS;
        }
    }

    public static class NSAutoreleasePool {
        private final ID myDelegate = Foundation.invoke(Foundation.invoke("NSAutoreleasePool", "alloc", new Object[0]), "init", new Object[0]);

        public void drain() {
            Foundation.invoke(this.myDelegate, "drain", new Object[0]);
        }
    }

    public static class NSData {
        private final ID myDelegate;

        public NSData(@NotNull ID delegate) {
            this.myDelegate = delegate;
        }

        public int length() {
            return Foundation.invoke(this.myDelegate, "length", new Object[0]).intValue();
        }

        @NotNull
        public byte[] bytes() {
            Pointer data = new Pointer(Foundation.invoke(this.myDelegate, "bytes", new Object[0]).longValue());
            return data.getByteArray(0L, this.length());
        }

        @NotNull
        public Image createImageFromBytes() {
            return ImageLoader.loadFromBytes(this.bytes());
        }
    }

    public static class NSArray {
        private final ID myDelegate;

        public NSArray(ID delegate) {
            this.myDelegate = delegate;
        }

        public int count() {
            return Foundation.invoke(this.myDelegate, "count", new Object[0]).intValue();
        }

        public ID at(int index) {
            return Foundation.invoke(this.myDelegate, "objectAtIndex:", index);
        }

        @NotNull
        public List<ID> getList() {
            ArrayList<ID> result = new ArrayList<ID>();
            for (int i = 0; i < this.count(); ++i) {
                result.add(this.at(i));
            }
            return result;
        }
    }

    public static class NSDictionary {
        private final ID myDelegate;

        public NSDictionary(ID delegate) {
            this.myDelegate = delegate;
        }

        public ID get(ID key) {
            return Foundation.invoke(this.myDelegate, "objectForKey:", new Object[]{key});
        }

        public ID get(String key) {
            return this.get(Foundation.nsString(key));
        }

        public int count() {
            return Foundation.invoke(this.myDelegate, "count", new Object[0]).intValue();
        }

        public NSArray keys() {
            return new NSArray(Foundation.invoke(this.myDelegate, "allKeys", new Object[0]));
        }

        @NotNull
        public static Map<String, String> toStringMap(@Nullable ID delegate) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (Foundation.isNil(delegate)) {
                return result;
            }
            NSDictionary dict = new NSDictionary(delegate);
            NSArray keys = dict.keys();
            for (int i = 0; i < keys.count(); ++i) {
                String key = Foundation.toStringViaUTF8(keys.at(i));
                String val = Foundation.toStringViaUTF8(dict.get(key));
                result.put(key, val);
            }
            return result;
        }

        public static ID toStringDictionary(@NotNull Map<String, String> map) {
            ID dict = Foundation.invoke("NSMutableDictionary", "dictionaryWithCapacity:", map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Foundation.invoke(dict, "setObject:forKey:", new Object[]{Foundation.nsString(entry.getValue()), Foundation.nsString(entry.getKey())});
            }
            return dict;
        }
    }

    static class RunnableInfo {
        Runnable myRunnable;
        boolean myUseAutoreleasePool;

        RunnableInfo(Runnable runnable, boolean useAutoreleasePool) {
            this.myRunnable = runnable;
            this.myUseAutoreleasePool = useAutoreleasePool;
        }
    }

    private static class NSString {
        private static final ID nsStringCls = Foundation.getObjcClass("NSString");
        private static final Pointer stringSel = Foundation.createSelector("string");
        private static final Pointer allocSel = Foundation.createSelector("alloc");
        private static final Pointer autoreleaseSel = Foundation.createSelector("autorelease");
        private static final Pointer initWithBytesLengthEncodingSel = Foundation.createSelector("initWithBytes:length:encoding:");
        private static final long nsEncodingUTF16LE = Foundation.access$000(0x14000100L);

        private NSString() {
        }

        @NotNull
        public static ID create(@NotNull String s) {
            if (s.isEmpty()) {
                return Foundation.invoke(nsStringCls, stringSel, new Object[0]);
            }
            byte[] utf16Bytes = s.getBytes(CharsetToolkit.UTF_16LE_CHARSET);
            return Foundation.invoke(Foundation.invoke(Foundation.invoke(nsStringCls, allocSel, new Object[0]), initWithBytesLengthEncodingSel, utf16Bytes, utf16Bytes.length, nsEncodingUTF16LE), autoreleaseSel, new Object[0]);
        }
    }
}

