/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, ExecutorService executorService) throws Throwable {
        if (executorService == null) {
            for (Callable<T> task : tasks) {
                task.call();
            }
            return null;
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> callable : tasks) {
                Future<T> future2 = executorService.submit(callable);
                futures.add(future2);
            }
            for (Future future : futures) {
                ((Runnable)((Object)future)).run();
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (CancellationException future2) {
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) continue;
                    throw cause;
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(false);
                }
            }
        }
        return futures;
    }

    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map, @NotNull K key, @NotNull V defaultValue) {
        Object v = map.get(key);
        if (v != null) {
            return v;
        }
        V prev = map.putIfAbsent(key, defaultValue);
        return prev == null ? defaultValue : prev;
    }

    @NotNull
    public static <T> T cacheOrGet(@NotNull AtomicReference<T> ref, @NotNull T defaultValue) {
        T value = ref.get();
        while (value == null) {
            value = ref.compareAndSet(null, defaultValue) ? defaultValue : ref.get();
        }
        return value;
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NotNull @NonNls String name) {
        return ConcurrencyUtil.newSingleThreadExecutor(name, 5);
    }

    @NotNull
    public static ThreadPoolExecutor newSingleThreadExecutor(@NonNls @NotNull String name, int priority) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory(name, true, priority));
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NotNull @NonNls String name) {
        return ConcurrencyUtil.newSingleScheduledThreadExecutor(name, 5);
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NonNls @NotNull String name, int priority) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory(name, true, priority));
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String name, final boolean isDaemon, final int priority) {
        return new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r, name);
                thread.setDaemon(isDaemon);
                thread.setPriority(priority);
                return thread;
            }
        };
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String name) {
        return new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(r, name);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaitQuiescence(@NotNull ThreadPoolExecutor executor, long timeout, @NotNull TimeUnit unit) {
        HashSet workers;
        executor.setKeepAliveTime(1L, TimeUnit.NANOSECONDS);
        executor.setCorePoolSize(0);
        ReentrantLock mainLock = ReflectionUtil.getField(executor.getClass(), executor, ReentrantLock.class, "mainLock");
        mainLock.lock();
        try {
            HashSet workersField = ReflectionUtil.getField(executor.getClass(), executor, HashSet.class, "workers");
            workers = new HashSet(workersField);
        }
        finally {
            mainLock.unlock();
        }
        for (Object worker : workers) {
            Thread thread = ReflectionUtil.getField(worker.getClass(), worker, Thread.class, "thread");
            try {
                thread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException e) {
                String trace = "Thread leaked: " + thread + "; " + (Object)((Object)thread.getState()) + " (" + thread.isAlive() + ")\n--- its stacktrace:\n";
                for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                    trace = trace + " at " + stackTraceElement + "\n";
                }
                trace = trace + "---\n";
                System.err.println("Executor " + executor + " is still active after " + unit.toSeconds(timeout) + " seconds://///\nThread " + thread + " dump:\n" + trace + "all thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n/////");
                break;
            }
        }
    }

    public static void joinAll(@NotNull Collection<? extends Thread> threads) throws RuntimeException {
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void joinAll(Thread ... threads) throws RuntimeException {
        ConcurrencyUtil.joinAll(Arrays.asList(threads));
    }

    @NotNull
    @Contract(pure=true)
    public static Runnable underThreadNameRunnable(@NotNull String name, @NotNull Runnable runnable) {
        return () -> ConcurrencyUtil.runUnderThreadName(name, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUnderThreadName(@NotNull String name, @NotNull Runnable runnable) {
        Thread currentThread = Thread.currentThread();
        String oldThreadName = currentThread.getName();
        if (name.equals(oldThreadName)) {
            runnable.run();
        } else {
            currentThread.setName(name);
            try {
                runnable.run();
            }
            finally {
                currentThread.setName(oldThreadName);
            }
        }
    }

    @NotNull
    public static Runnable once(@NotNull Runnable delegate) {
        AtomicBoolean done = new AtomicBoolean(false);
        return () -> {
            if (done.compareAndSet(false, true)) {
                delegate.run();
            }
        };
    }

    public static <T, E extends Throwable> T withLock(@NotNull Lock lock, @NotNull ThrowableComputable<T, E> runnable) throws E {
        lock.lock();
        try {
            T t = runnable.compute();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public static <E extends Throwable> void withLock(@NotNull Lock lock, @NotNull ThrowableRunnable<E> runnable) throws E {
        lock.lock();
        try {
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }
}

