/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReadEnv;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EnvironmentUtil.class);
    private static final int SHELL_ENV_READING_TIMEOUT = 20000;
    private static final String LANG = "LANG";
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_CTYPE = "LC_CTYPE";
    public static final String BASH_EXECUTABLE_NAME = "bash";
    public static final String SHELL_VARIABLE_NAME = "SHELL";
    private static final String SHELL_INTERACTIVE_ARGUMENT = "-i";
    private static final String SHELL_LOGIN_ARGUMENT = "-l";
    public static final String SHELL_COMMAND_ARGUMENT = "-c";
    private static final Future<Map<String, String>> ourEnvGetter = SystemInfo.isMac && "unlocked".equals(System.getProperty("__idea.mac.env.lock")) && SystemProperties.getBooleanProperty("idea.fix.mac.env", true) ? AppExecutorUtil.getAppExecutorService().submit(() -> Collections.unmodifiableMap(EnvironmentUtil.setCharsetVar(EnvironmentUtil.getShellEnv()))) : new FixedFuture<Map<String, String>>(EnvironmentUtil.getSystemEnv());
    private static final NotNullLazyValue<Map<String, String>> ourEnvironment = new AtomicNotNullLazyValue<Map<String, String>>(){

        @Override
        @NotNull
        protected Map<String, String> compute() {
            try {
                return (Map)ourEnvGetter.get();
            }
            catch (Throwable t) {
                LOG.warn("can't get shell environment", t);
                return EnvironmentUtil.getSystemEnv();
            }
        }
    };
    private static final String DISABLE_OMZ_AUTO_UPDATE = "DISABLE_AUTO_UPDATE";
    private static final String INTELLIJ_ENVIRONMENT_READER = "INTELLIJ_ENVIRONMENT_READER";

    private static Map<String, String> getSystemEnv() {
        if (SystemInfo.isWindows) {
            return Collections.unmodifiableMap(new THashMap(System.getenv(), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE));
        }
        return System.getenv();
    }

    private EnvironmentUtil() {
    }

    public static boolean isEnvironmentReady() {
        return ourEnvGetter.isDone();
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        return ourEnvironment.getValue();
    }

    @Nullable
    public static String getValue(@NotNull String name) {
        return EnvironmentUtil.getEnvironmentMap().get(name);
    }

    public static String[] getEnvironment() {
        return EnvironmentUtil.flattenEnvironment(EnvironmentUtil.getEnvironmentMap());
    }

    public static String[] flattenEnvironment(@NotNull Map<String, String> environment) {
        String[] array = new String[environment.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            array[i++] = entry.getKey() + "=" + entry.getValue();
        }
        return array;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidName(@Nullable String name) {
        return name != null && !name.isEmpty() && name.indexOf(0) == -1 && name.indexOf(61, SystemInfo.isWindows ? 1 : 0) == -1;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidValue(@Nullable String value) {
        return value != null && value.indexOf(0) == -1;
    }

    private static Map<String, String> getShellEnv() throws Exception {
        return new ShellEnvReader().readShellEnv();
    }

    @ApiStatus.Experimental
    @NotNull
    public static List<String> buildShellProcessCommand(@NotNull String shellScript, boolean isLogin, boolean isInteractive, boolean isCommand) {
        ArrayList<String> commands = ContainerUtil.newArrayList(new String[]{shellScript});
        if (isLogin && !shellScript.endsWith("/tcsh") && !shellScript.endsWith("/csh")) {
            commands.add(SHELL_LOGIN_ARGUMENT);
        }
        if (isInteractive) {
            commands.add(SHELL_INTERACTIVE_ARGUMENT);
        }
        if (isCommand) {
            commands.add(SHELL_COMMAND_ARGUMENT);
        }
        return commands;
    }

    @NotNull
    public static Map<String, String> parseEnv(String ... lines) throws Exception {
        HashSet<String> toIgnore = new HashSet<String>(Arrays.asList("_", "PWD", "SHLVL", DISABLE_OMZ_AUTO_UPDATE, INTELLIJ_ENVIRONMENT_READER));
        Map<String, String> env = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>();
        for (String line : lines) {
            int pos = line.indexOf(61);
            if (pos <= 0) {
                throw new Exception("malformed:" + line);
            }
            String name = line.substring(0, pos);
            if (!toIgnore.contains(name)) {
                newEnv.put(name, line.substring(pos + 1));
                continue;
            }
            if (!env.containsKey(name)) continue;
            newEnv.put(name, env.get(name));
        }
        LOG.info("shell environment loaded (" + newEnv.size() + " vars)");
        return newEnv;
    }

    @NotNull
    private static Map<String, String> parseEnv(String text) throws Exception {
        String[] lines = text.split("\u0000");
        return EnvironmentUtil.parseEnv(lines);
    }

    private static int waitAndTerminateAfter(@NotNull Process process, int timeoutMillis) {
        Integer exitCode = EnvironmentUtil.waitFor(process, timeoutMillis);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("shell env loader is timed out");
        if (!SystemInfo.isWindows) {
            UnixProcessManager.sendSigIntToProcessTree(process);
            exitCode = EnvironmentUtil.waitFor(process, 1000);
            if (exitCode != null) {
                return exitCode;
            }
            LOG.warn("failed to terminate shell env loader process gracefully, terminating forcibly");
        }
        if (SystemInfo.isWindows) {
            WinProcessManager.kill(process, true);
        } else {
            UnixProcessManager.sendSigKillToProcessTree(process);
        }
        exitCode = EnvironmentUtil.waitFor(process, 1000);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to kill shell env loader");
        return -1;
    }

    @Nullable
    private static Integer waitFor(@NotNull Process process, int timeoutMillis) {
        long stop = System.currentTimeMillis() + (long)timeoutMillis;
        while (System.currentTimeMillis() < stop) {
            TimeoutUtil.sleep(100L);
            try {
                return process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
        }
        return null;
    }

    private static Map<String, String> setCharsetVar(@NotNull Map<String, String> env) {
        if (!EnvironmentUtil.isCharsetVarDefined(env)) {
            String value = EnvironmentUtil.setLocaleEnv(env, CharsetToolkit.getDefaultSystemCharset());
            LOG.info("LC_CTYPE=" + value);
        }
        return env;
    }

    private static boolean checkIfLocaleAvailable(String candidateLanguageTerritory) {
        Locale[] available;
        for (Locale l : available = Locale.getAvailableLocales()) {
            if (!StringUtil.equals(l.toString(), candidateLanguageTerritory)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String setLocaleEnv(@NotNull Map<String, String> env, @NotNull Charset charset) {
        String languageTerritoryFromLocale;
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String languageTerritory = "en_US";
        if (!language.isEmpty() && !country.isEmpty() && EnvironmentUtil.checkIfLocaleAvailable(languageTerritoryFromLocale = language + '_' + country)) {
            languageTerritory = languageTerritoryFromLocale;
        }
        String result = languageTerritory + '.' + charset.name();
        env.put(LC_CTYPE, result);
        return result;
    }

    private static boolean isCharsetVarDefined(@NotNull Map<String, String> env) {
        return !env.isEmpty() && (env.containsKey(LANG) || env.containsKey(LC_ALL) || env.containsKey(LC_CTYPE));
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs) {
        EnvironmentUtil.inlineParentOccurrences(envs, EnvironmentUtil.getEnvironmentMap());
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs, @NotNull Map<String, String> parentEnv) {
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String parentVal;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || (parentVal = parentEnv.get(key)) == null || !EnvironmentUtil.containsEnvKeySubstitution(key, value)) continue;
            envs.put(key, value.replace("$" + key + "$", parentVal));
        }
    }

    private static boolean containsEnvKeySubstitution(String envKey, String val) {
        return ArrayUtil.find(val.split(File.pathSeparator), "$" + envKey + "$") != -1;
    }

    static Map<String, String> testLoader() {
        try {
            return EnvironmentUtil.getShellEnv();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Map<String, String> testParser(@NotNull String lines) {
        try {
            return EnvironmentUtil.parseEnv(lines);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class StreamGobbler
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            @Override
            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            @Override
            public boolean splitToLines() {
                return false;
            }
        };
        private final StringBuffer myBuffer = new StringBuffer();

        StreamGobbler(@NotNull InputStream stream) {
            super(stream, CharsetToolkit.getDefaultSystemCharset(), OPTIONS);
            this.start("stdout/stderr streams of shell env loading process");
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            return AppExecutorUtil.getAppExecutorService().submit(runnable);
        }

        @Override
        protected void onTextAvailable(@NotNull String text) {
            this.myBuffer.append(text);
        }

        @NotNull
        public String getText() {
            return this.myBuffer.toString();
        }
    }

    public static class ShellEnvReader {
        public Map<String, String> readShellEnv() throws Exception {
            return this.readShellEnv(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> readShellEnv(@Nullable Map<String, String> additionalEnvironment) throws Exception {
            File reader = PathManager.findBinFileWithException("printenv.py");
            File envFile = FileUtil.createTempFile("intellij-shell-env.", ".tmp", false);
            try {
                List<String> command = this.getShellProcessCommand();
                int idx = command.indexOf(EnvironmentUtil.SHELL_COMMAND_ARGUMENT);
                if (idx >= 0) {
                    command.set(idx + 1, command.get(idx + 1) + ";'" + reader.getAbsolutePath() + "' '" + envFile.getAbsolutePath() + "'");
                } else {
                    command.add(EnvironmentUtil.SHELL_COMMAND_ARGUMENT);
                    command.add("'" + reader.getAbsolutePath() + "' '" + envFile.getAbsolutePath() + "'");
                }
                LOG.info("loading shell env: " + StringUtil.join(command, " "));
                Map map = (Map)ShellEnvReader.runProcessAndReadOutputAndEnvs(command, null, additionalEnvironment, (File)envFile).second;
                return map;
            }
            finally {
                FileUtil.delete(envFile);
            }
        }

        @NotNull
        public Map<String, String> readBatEnv(@NotNull File batchFile, List<String> args) throws Exception {
            return (Map)this.readBatOutputAndEnv((File)batchFile, args).second;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected Pair<String, Map<String, String>> readBatOutputAndEnv(@NotNull File batchFile, List<String> args) throws Exception {
            File envFile = FileUtil.createTempFile("intellij-cmd-env.", ".tmp", false);
            try {
                ArrayList<String> cl = new ArrayList<String>();
                cl.add(CommandLineUtil.getWinShellName());
                cl.add("/c");
                cl.add("call");
                cl.add(batchFile.getPath());
                cl.addAll(args);
                cl.add("&&");
                cl.addAll(ShellEnvReader.getReadEnvCommand());
                cl.add(envFile.getPath());
                cl.addAll(Arrays.asList("||", "exit", "/B", "%ERRORLEVEL%"));
                Pair<String, Map<String, String>> pair = ShellEnvReader.runProcessAndReadOutputAndEnvs(cl, batchFile.getParentFile(), null, envFile);
                return pair;
            }
            finally {
                FileUtil.delete(envFile);
            }
        }

        @NotNull
        private static List<String> getReadEnvCommand() {
            return Arrays.asList(FileUtil.toSystemDependentName(System.getProperty("java.home") + "/bin/java"), "-cp", PathManager.getJarPathForClass(ReadEnv.class), ReadEnv.class.getCanonicalName());
        }

        @NotNull
        protected static Pair<String, Map<String, String>> runProcessAndReadOutputAndEnvs(@NotNull List<String> command, @Nullable File workingDir, @Nullable Map<String, String> scriptEnvironment, @NotNull File envFile) throws Exception {
            ProcessBuilder builder = new ProcessBuilder(command).redirectErrorStream(true);
            if (scriptEnvironment != null) {
                builder.environment().putAll(scriptEnvironment);
            }
            if (workingDir != null) {
                builder.directory(workingDir);
            }
            builder.environment().put(EnvironmentUtil.DISABLE_OMZ_AUTO_UPDATE, "true");
            builder.environment().put(EnvironmentUtil.INTELLIJ_ENVIRONMENT_READER, "true");
            Process process = builder.start();
            StreamGobbler gobbler = new StreamGobbler(process.getInputStream());
            int rv = EnvironmentUtil.waitAndTerminateAfter(process, 20000);
            gobbler.stop();
            String lines = FileUtil.loadFile(envFile);
            if (rv != 0 || lines.isEmpty()) {
                throw new Exception("rv:" + rv + " text:" + lines.length() + " out:" + StringUtil.trimEnd(gobbler.getText(), '\n'));
            }
            return Pair.create(gobbler.getText(), EnvironmentUtil.parseEnv(lines));
        }

        @NotNull
        protected List<String> getShellProcessCommand() throws Exception {
            String shellScript = this.getShell();
            if (shellScript == null || !new File(shellScript).canExecute()) {
                throw new Exception("shell:" + shellScript);
            }
            return EnvironmentUtil.buildShellProcessCommand(shellScript, true, true, false);
        }

        @Nullable
        protected String getShell() {
            return System.getenv(EnvironmentUtil.SHELL_VARIABLE_NAME);
        }
    }
}

