/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;

public class FontUtil {
    @NotNull
    public static String rightArrow(@NotNull Font font) {
        return FontUtil.canDisplay(font, '\u2192', "->");
    }

    @NotNull
    public static String upArrow(@NotNull Font font, @NotNull String defaultValue) {
        return FontUtil.canDisplay(font, '\u2191', defaultValue);
    }

    @NotNull
    public static String canDisplay(@NotNull Font font, char value, @NotNull String defaultValue) {
        return font.canDisplay(value) ? String.valueOf(value) : defaultValue;
    }

    @NotNull
    public static String spaceAndThinSpace() {
        return " " + FontUtil.thinSpace();
    }

    @NotNull
    public static String thinSpace() {
        return FontUtil.canDisplay(UIUtil.getLabelFont(), '\u2009', " ");
    }

    @NotNull
    public static Font minusOne(@NotNull Font font) {
        return font.deriveFont((float)font.getSize() - 1.0f);
    }
}

