/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageLoader
implements Serializable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");
    public static final long CACHED_IMAGE_MAX_SIZE = (long)(Registry.doubleValue("ide.cached.image.max.size") * 1024.0 * 1024.0);
    private static final ConcurrentMap<String, Image> ourCache = ContainerUtil.createConcurrentSoftValueMap();
    private static LoadFunction measureLoad;
    public static final Component ourComponent;

    public static void clearCache() {
        ourCache.clear();
    }

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        return ImageLoader.loadFromUrl(url, true);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling) {
        return ImageLoader.loadFromUrl(url, allowFloatScaling, true, new ImageFilter[]{null}, JBUI.ScaleContext.create());
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling, boolean useCache, ImageFilter[] filters, JBUI.ScaleContext ctx) {
        return ImageLoader.loadFromUrl(url, allowFloatScaling, useCache, UIUtil.isUnderDarcula(), filters, ctx);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, final boolean allowFloatScaling, boolean useCache, boolean dark, ImageFilter[] filters, final JBUI.ScaleContext ctx) {
        return ImageDescList.create(url.toString(), null, dark, allowFloatScaling, ctx).load(ImageConverterChain.create().withFilter(filters).with(new ImageConverter(){

            @Override
            public Image convert(Image source, ImageDesc desc) {
                if (source != null && desc.type != ImageDesc.Type.SVG) {
                    double scale = ImageLoader.adjustScaleFactor(allowFloatScaling, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
                    if (desc.scale > 1.0) {
                        scale /= desc.scale;
                    }
                    source = ImageLoader.scaleImage(source, scale);
                }
                return source;
            }
        }).withHiDPI(ctx), useCache);
    }

    private static double adjustScaleFactor(boolean allowFloatScaling, double scale) {
        return allowFloatScaling ? scale : (JBUI.isHiDPI(scale) ? 2.0 : 1.0);
    }

    @NotNull
    public static Image scaleImage(Image image, double scale) {
        if (scale == 1.0) {
            return image;
        }
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).scale(scale);
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            return image;
        }
        int width = (int)Math.round(scale * (double)w);
        int height = (int)Math.round(scale * (double)h);
        return Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetSize) {
        return ImageLoader.scaleImage(image, targetSize, targetSize);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetWidth, int targetHeight) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).scale(targetWidth, targetHeight);
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0 || w == targetWidth && h == targetHeight) {
            return image;
        }
        return Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])null);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path, @NotNull Class aClass) {
        JBUI.ScaleContext ctx = JBUI.ScaleContext.create();
        return ImageDescList.create(path, aClass, UIUtil.isUnderDarcula(), true, ctx).load(ImageConverterChain.create().withHiDPI(ctx));
    }

    public static Image loadFromBytes(@NotNull byte[] bytes) {
        return ImageLoader.loadFromStream(new ByteArrayInputStream(bytes));
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        return ImageLoader.loadFromStream(inputStream, 1);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, int scale) {
        return ImageLoader.loadFromStream(inputStream, scale, null);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, int scale, ImageFilter filter) {
        Image image = ImageLoader.load(inputStream, scale);
        ImageDesc desc = new ImageDesc("", null, scale, ImageDesc.Type.IMG);
        return ImageConverterChain.create().withFilter(filter).withHiDPI(JBUI.ScaleContext.create()).convert(image, desc);
    }

    @Nullable
    public static Image loadCustomIcon(@NotNull File f) throws IOException {
        Image icon = ImageLoader._loadImageFromFile(f);
        if (icon == null) {
            return null;
        }
        int w = icon.getWidth(null);
        int h = icon.getHeight(null);
        if (w <= 0 || h <= 0) {
            LOG.error("negative image size: w=" + w + ", h=" + h + ", path=" + f.getPath());
            return null;
        }
        if (w > EmptyIcon.ICON_18.getIconWidth() || h > EmptyIcon.ICON_18.getIconHeight()) {
            double s = (double)EmptyIcon.ICON_18.getIconWidth() / (double)Math.max(w, h);
            return ImageLoader.scaleImage(icon, s);
        }
        return icon;
    }

    @Nullable
    private static Image _loadImageFromFile(@NotNull File f) throws IOException {
        JBUI.ScaleContext ctx = JBUI.ScaleContext.create();
        double scale = ctx.getScale(JBUI.ScaleType.PIX_SCALE);
        ImageDesc desc = new ImageDesc(f.toURI().toURL().toString(), null, scale, StringUtil.endsWithIgnoreCase(f.getPath(), ".svg") ? ImageDesc.Type.SVG : ImageDesc.Type.IMG);
        return ImageUtil.ensureHiDPI(desc.load(), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image load(@NotNull InputStream inputStream, double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale must be 1 or greater");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            ImageLoader.waitForImage(image);
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }

    static {
        ourComponent = new Component(){};
    }

    private static class ImageConverterChain
    extends ArrayList<ImageConverter> {
        private ImageConverterChain() {
        }

        public static ImageConverterChain create() {
            return new ImageConverterChain();
        }

        ImageConverterChain withFilter(ImageFilter[] filters) {
            if (filters == null) {
                return this;
            }
            ImageConverterChain chain = this;
            for (ImageFilter filter : filters) {
                chain = chain.withFilter(filter);
            }
            return chain;
        }

        ImageConverterChain withFilter(final ImageFilter filter) {
            if (filter == null) {
                return this;
            }
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    return ImageUtil.filter(source, filter);
                }
            });
        }

        ImageConverterChain withHiDPI(final JBUI.ScaleContext ctx) {
            if (ctx == null) {
                return this;
            }
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    return ImageUtil.ensureHiDPI(source, ctx);
                }
            });
        }

        public ImageConverterChain with(ImageConverter f) {
            this.add(f);
            return this;
        }

        public Image convert(Image image, ImageDesc desc) {
            for (ImageConverter f : this) {
                image = f.convert(image, desc);
            }
            return image;
        }
    }

    private static interface ImageConverter {
        public Image convert(@Nullable Image var1, ImageDesc var2);
    }

    private static class ImageDescList
    extends ArrayList<ImageDesc> {
        private ImageDescList() {
        }

        @Nullable
        public Image load() {
            return this.load(ImageConverterChain.create());
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters) {
            return this.load(converters, true);
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters, boolean useCache) {
            for (ImageDesc desc : this) {
                try {
                    Image image = desc.load(useCache);
                    if (image == null) continue;
                    LOG.debug("Loaded image: " + desc);
                    return converters.convert(image, desc);
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        public static ImageDescList create(@NotNull String path, @Nullable Class cls, boolean dark, boolean allowFloatScaling, JBUI.ScaleContext ctx) {
            boolean retina = JBUI.isHiDPI(ctx.getScale(JBUI.ScaleType.PIX_SCALE));
            Builder list = new Builder(FileUtil.getNameWithoutExtension(path), FileUtilRt.getExtension(path), cls, Registry.is("ide.svg.icon"), ImageLoader.adjustScaleFactor(allowFloatScaling, ctx.getScale(JBUI.ScaleType.PIX_SCALE)));
            if (path.contains("://") && !path.startsWith("file:")) {
                list.add(StringUtil.endsWithIgnoreCase(StringUtil.substringBeforeLast(path, "?"), ".svg") ? ImageDesc.Type.SVG : ImageDesc.Type.IMG);
            } else if (retina && dark) {
                list.add(true, true);
                list.add(true, false);
            } else if (dark) {
                list.add(false, true);
                list.add(false, false);
            } else if (retina) {
                list.add(true, false);
            } else {
                list.add(false, false);
            }
            return list.build();
        }

        static class Builder {
            final ImageDescList list = new ImageDescList();
            final String name;
            final String ext;
            final Class cls;
            final boolean svg;
            final double scale;

            Builder(String name, String ext, Class cls, boolean svg, double scale) {
                this.name = name;
                this.ext = ext;
                this.cls = cls;
                this.svg = svg;
                this.scale = scale;
            }

            void add(boolean retina, boolean dark) {
                if (this.svg) {
                    this.add(retina, dark, ImageDesc.Type.SVG);
                }
                this.add(retina, dark, ImageDesc.Type.IMG);
            }

            void add(boolean retina, boolean dark, ImageDesc.Type type) {
                String _ext;
                String string = _ext = ImageDesc.Type.SVG == type ? "svg" : this.ext;
                double _scale = ImageDesc.Type.SVG == type ? this.scale : (retina ? 2.0 : 1.0);
                this.list.add(new ImageDesc(this.name + (dark ? "_dark" : "") + (retina ? "@2x" : "") + "." + _ext, this.cls, _scale, type));
                if (retina && dark) {
                    this.list.add(new ImageDesc(this.name + "@2x_dark." + _ext, this.cls, _scale, type));
                }
                if (retina) {
                    this.list.add(new ImageDesc(this.name + (dark ? "_dark" : "") + "." + _ext, this.cls, ImageDesc.Type.SVG == type ? this.scale : 1.0, type));
                }
            }

            void add(ImageDesc.Type type) {
                this.list.add(new ImageDesc(this.name + "." + this.ext, this.cls, 1.0, type, true));
            }

            ImageDescList build() {
                return this.list;
            }
        }
    }

    public static class ImageDesc {
        final String path;
        final Class cls;
        final double scale;
        final Type type;
        final boolean original;

        ImageDesc(@NotNull String path, @Nullable Class cls, double scale, @NotNull Type type) {
            this(path, cls, scale, type, false);
        }

        ImageDesc(@NotNull String path, @Nullable Class cls, double scale, @NotNull Type type, boolean original) {
            this.path = path;
            this.cls = cls;
            this.scale = scale;
            this.type = type;
            this.original = original;
        }

        @Nullable
        public Image load() throws IOException {
            return this.load(true);
        }

        @Nullable
        public Image load(boolean useCache) throws IOException {
            Image image;
            InputStream stream = null;
            if (this.cls != null && (stream = this.cls.getResourceAsStream(this.path)) == null) {
                return null;
            }
            String cacheKey = null;
            URL url = null;
            if (stream == null) {
                URLConnection connection;
                if (useCache) {
                    cacheKey = this.path + (this.type == Type.SVG ? "_@" + this.scale + "x" : "");
                    image = (Image)ourCache.get(cacheKey);
                    if (image != null) {
                        return image;
                    }
                }
                if ((connection = (url = new URL(this.path)).openConnection()) instanceof HttpURLConnection) {
                    if (!this.original) {
                        return null;
                    }
                    connection.addRequestProperty("User-Agent", "IntelliJ");
                }
                stream = connection.getInputStream();
            }
            if ((image = this.loadImpl(url, stream, this.scale)) != null && cacheKey != null && 4L * (long)image.getWidth(null) * (long)image.getHeight(null) <= CACHED_IMAGE_MAX_SIZE) {
                ourCache.put(cacheKey, image);
            }
            return image;
        }

        Image loadImpl(final URL url, final InputStream stream, final double scale) throws IOException {
            LoadFunction f = new LoadFunction(){

                @Override
                public Image load(@Nullable LoadFunction delegate, @NotNull Type type) throws IOException {
                    switch (type) {
                        case SVG: {
                            return SVGLoader.load(url, stream, scale);
                        }
                        case IMG: {
                            return ImageLoader.load(stream, scale);
                        }
                    }
                    return null;
                }
            };
            if (measureLoad != null) {
                return measureLoad.load(f, this.type);
            }
            return f.load(null, this.type);
        }

        public String toString() {
            return this.path + ", scale: " + this.scale + ", type: " + (Object)((Object)this.type);
        }

        public static enum Type {
            IMG,
            SVG;

        }
    }

    public static interface LoadFunction {
        public Image load(@Nullable LoadFunction var1, @NotNull ImageDesc.Type var2) throws IOException;
    }
}

