/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyInitializer {

    public static abstract class MutableNotNullValue<T>
    extends MutableNullableValue<T> {
        @Override
        public void set(@NotNull T value) {
            super.set(value);
        }

        @Override
        @NotNull
        public T get() {
            return super.get();
        }

        @Override
        @NotNull
        public abstract T initialize();
    }

    public static abstract class MutableNullableValue<T>
    extends NullableValue<T> {
        public void set(T value) {
            this.get();
            this.value = value;
        }
    }

    public static abstract class NotNullValue<T>
    extends NullableValue<T> {
        @Override
        @NotNull
        public T get() {
            return super.get();
        }

        @Override
        @NotNull
        public abstract T initialize();
    }

    public static abstract class NullableValue<T> {
        protected volatile T value;
        private volatile Initializer initializer = new Initializer();

        @Nullable
        public abstract T initialize();

        @Nullable
        public T get() {
            Initializer init = this.initializer;
            if (init != null) {
                init.lock.lock();
                try {
                    if (init.lock.getHoldCount() > 1) {
                        T t = null;
                        return t;
                    }
                    if (this.initializer != null) {
                        this.value = this.initializer.init();
                        this.initializer = null;
                    }
                }
                finally {
                    init.lock.unlock();
                }
                this.onInitialized(this.value);
            }
            return this.value;
        }

        public final boolean isNotNull() {
            return this.get() != null;
        }

        protected void onInitialized(T value) {
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        private class Initializer {
            private final ReentrantLock lock = new ReentrantLock();

            private Initializer() {
            }

            T init() {
                try {
                    return NullableValue.this.initialize();
                }
                catch (Exception e) {
                    Logger.getInstance(LazyInitializer.class).error(e);
                    return null;
                }
            }
        }
    }
}

