/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Factory;
import com.intellij.util.ArrayUtil;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public class NewInstanceFactory<T>
implements Factory<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.NewInstanceFactory");
    private final Constructor<? extends T> myConstructor;
    private final Object[] myArgs;

    private NewInstanceFactory(@NotNull Constructor<? extends T> constructor, @NotNull Object[] args) {
        this.myConstructor = constructor;
        this.myArgs = args;
    }

    @Override
    public T create() {
        try {
            return this.myConstructor.newInstance(this.myArgs);
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    public static <T> Factory<T> fromClass(@NotNull Class<? extends T> clazz) {
        try {
            return new NewInstanceFactory<T>(clazz.getConstructor(ArrayUtil.EMPTY_CLASS_ARRAY), ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (NoSuchMethodException e) {
            return () -> {
                try {
                    return clazz.newInstance();
                }
                catch (Exception e1) {
                    LOG.error(e1);
                    return null;
                }
            };
        }
    }
}

