/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IntIntFunction;
import com.intellij.util.containers.Convertor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectUtils {
    public static final Object NULL = ObjectUtils.sentinel("ObjectUtils.NULL");

    private ObjectUtils() {
    }

    @NotNull
    public static Object sentinel(@NotNull String name) {
        return new Sentinel(name);
    }

    public static void reachabilityFence(Object o) {
    }

    @NotNull
    public static <T> T sentinel(final @NotNull String name, @NotNull Class<T> ofInterface) {
        if (!ofInterface.isInterface()) {
            throw new IllegalArgumentException("Expected interface but got: " + ofInterface);
        }
        return (T)Proxy.newProxyInstance(ofInterface.getClassLoader(), new Class[]{ofInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                if ("toString".equals(method.getName()) && args.length == 0) {
                    return name;
                }
                throw new AbstractMethodError();
            }
        });
    }

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        return ObjectUtils.notNull(t);
    }

    public static <T> void assertAllElementsNotNull(@NotNull T[] array) {
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (t != null) continue;
            throw new NullPointerException("Element [" + i + "] is null");
        }
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; null, null -> null", pure=true)
    public static <T> T chooseNotNull(@Nullable T t1, @Nullable T t2) {
        return t1 == null ? t2 : t1;
    }

    @Contract(value="!null, _ -> !null; _, !null -> !null; null, null -> null", pure=true)
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2) {
        return ObjectUtils.chooseNotNull(t1, t2);
    }

    @Contract(value="!null, _, _ -> !null; _, !null, _ -> !null; _, _, !null -> !null; null,null,null -> null", pure=true)
    public static <T> T coalesce(@Nullable T t1, @Nullable T t2, @Nullable T t3) {
        return t1 != null ? t1 : (t2 != null ? t2 : t3);
    }

    @Nullable
    public static <T> T coalesce(@Nullable Iterable<T> o) {
        if (o == null) {
            return null;
        }
        for (T t : o) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value) {
        return ObjectUtils.notNull(value, value);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        return value == null ? defaultValue : value;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull NotNullFactory<? extends T> defaultValue) {
        return value == null ? defaultValue.create() : value;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        return null;
    }

    @Nullable
    public static <T, S> S doIfCast(@Nullable Object obj, @NotNull Class<T> clazz, Convertor<? super T, ? extends S> convertor) {
        if (clazz.isInstance(obj)) {
            return convertor.convert(obj);
        }
        return null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T, S> S doIfNotNull(@Nullable T obj, @NotNull Function<? super T, ? extends S> function) {
        return obj == null ? null : (S)function.fun((T)obj);
    }

    public static <T> void consumeIfCast(@Nullable Object obj, @NotNull Class<T> clazz, Consumer<? super T> consumer) {
        if (clazz.isInstance(obj)) {
            consumer.consume(obj);
        }
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static <T> T nullizeByCondition(@Nullable T obj, @NotNull Condition<? super T> condition) {
        if (condition.value(obj)) {
            return null;
        }
        return obj;
    }

    public static int binarySearch(int fromIndex, int toIndex, @NotNull IntIntFunction indexComparator) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = indexComparator.fun(mid);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static class Sentinel {
        private final String myName;

        Sentinel(@NotNull String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

