/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static URL getResource(@NotNull Class loaderClass, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        return ResourceUtil.getResource(loaderClass.getClassLoader(), basePath, fileName);
    }

    public static URL getResource(@NotNull ClassLoader loader, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        String fixedPath = StringUtil.trimStart(StringUtil.trimEnd(basePath, "/"), "/");
        List<String> bundles = ResourceUtil.calculateBundleNames(fixedPath, Locale.getDefault());
        for (String bundle : bundles) {
            URL url = loader.getResource(bundle + "/" + fileName);
            if (url == null) continue;
            try {
                url.openConnection();
            }
            catch (IOException e) {
                continue;
            }
            return url;
        }
        return loader.getResource(fixedPath + "/" + fileName);
    }

    @NotNull
    private static List<String> calculateBundleNames(@NotNull String baseName, @NotNull Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(0, baseName);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        StringBuilder temp = new StringBuilder(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.add(0, temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.add(0, temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.add(0, temp.toString());
        return result;
    }

    @NotNull
    public static String loadText(@NotNull URL url) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(URLUtil.openStream(url));
        try (InputStreamReader reader = new InputStreamReader((InputStream)inputStream, CharsetToolkit.UTF8_CHARSET);){
            int length;
            StringBuilder text = new StringBuilder();
            char[] buf = new char[5000];
            while (reader.ready() && (length = reader.read(buf)) != -1) {
                text.append(buf, 0, length);
            }
            String string = text.toString();
            return string;
        }
    }
}

