/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMAnimatedLength;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGOMRectElement;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.xmlgraphics.java2d.Dimension2DDouble;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SVGLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.SVGLoader");
    private static SvgColorPatcher ourColorPatcher = null;
    public static final int ICON_DEFAULT_SIZE = 16;
    public static final LazyInitializer.NotNullValue<Double> ICON_MAX_SIZE = new LazyInitializer.NotNullValue<Double>(){

        @Override
        @NotNull
        public Double initialize() {
            double maxSize = 2.147483647E9;
            if (!GraphicsEnvironment.isHeadless()) {
                GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                AffineTransform tx = device.getDefaultConfiguration().getDefaultTransform();
                maxSize = (int)Math.max((double)bounds.width * tx.getScaleX(), (double)bounds.height * tx.getScaleY());
            }
            return maxSize;
        }
    };
    private final TranscoderInput myTranscoderInput;
    private final double myScale;
    private final double myOverridenWidth;
    private final double myOverridenHeight;
    private BufferedImage myImage;

    public static Image load(@NotNull URL url, float scale) throws IOException {
        return SVGLoader.load(url, url.openStream(), scale);
    }

    public static Image load(@NotNull InputStream stream, float scale) throws IOException {
        return SVGLoader.load(null, stream, scale);
    }

    public static Image load(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        try {
            return new SVGLoader(url, stream, scale).createImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    public static Image load(@Nullable URL url, @NotNull InputStream stream, @NotNull JBUI.ScaleContext ctx, double width, double height) throws IOException {
        try {
            double s = ctx.getScale(JBUI.ScaleType.PIX_SCALE);
            return new SVGLoader(url, stream, width * s, height * s, 1.0).createImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, JBUI.ScaleContext ctx, double width, double height) throws IOException {
        BufferedImage image = (BufferedImage)SVGLoader.load(url, stream, ctx, width, height);
        return (T)((BufferedImage)ImageUtil.ensureHiDPI(image, ctx));
    }

    public static <T extends BufferedImage> T loadHiDPI(@Nullable URL url, @NotNull InputStream stream, JBUI.ScaleContext ctx) throws IOException {
        BufferedImage image = (BufferedImage)SVGLoader.load(url, stream, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
        return (T)((BufferedImage)ImageUtil.ensureHiDPI(image, ctx));
    }

    public static Dimension2D getDocumentSize(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        int ch;
        StringBuilder builder = new StringBuilder(100);
        byte[] bytes = new byte[3];
        boolean checkClosingBracket = false;
        while ((ch = stream.read()) != -1) {
            builder.append((char)ch);
            if (ch == 60) {
                if (stream.read(bytes, 0, 3) == -1) break;
                String str = new String(bytes);
                builder.append(str);
                checkClosingBracket = "svg".equals(str);
                continue;
            }
            if (!checkClosingBracket || ch != 62) continue;
            return new SVGLoader(url, new ByteArrayInputStream(builder.append("</svg>").toString().getBytes()), scale).getDocumentSize();
        }
        return new Dimension2DDouble(16.0 * scale, 16.0 * scale);
    }

    public static double getMaxZoomFactor(@Nullable URL url, @NotNull InputStream stream, @NotNull JBUI.ScaleContext ctx) throws IOException {
        SVGLoader loader = new SVGLoader(url, stream, ctx.getScale(JBUI.ScaleType.PIX_SCALE));
        Dimension2D size = loader.getDocumentSize();
        return Math.min(ICON_MAX_SIZE.get() / size.getWidth(), ICON_MAX_SIZE.get() / size.getHeight());
    }

    private SVGLoader(@Nullable URL url, InputStream stream, double scale) throws IOException {
        this(url, stream, -1.0, -1.0, scale);
    }

    private SVGLoader(@Nullable URL url, InputStream stream, double width, double height, double scale) throws IOException {
        String uri = null;
        try {
            if (url != null && "jar".equals(url.getProtocol()) && stream != null) {
                url = new URL(url.getPath());
            }
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Document document = new MySAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument(uri, stream);
        if (document == null) {
            throw new IOException("document not created");
        }
        SVGLoader.patchColors(url, document);
        this.myTranscoderInput = new TranscoderInput(document);
        this.myOverridenWidth = width;
        this.myOverridenHeight = height;
        this.myScale = scale;
    }

    private static void patchColors(URL url, Document document) {
        if (ourColorPatcher != null) {
            ourColorPatcher.patchColors(url, document.getDocumentElement());
        }
    }

    public static void setColorPatcher(@Nullable SvgColorPatcher colorPatcher) {
        ourColorPatcher = colorPatcher;
        IconLoader.clearCache();
    }

    private BufferedImage createImage() throws TranscoderException {
        MyTranscoder transcoder = new MyTranscoder();
        if (this.myOverridenWidth != -1.0) {
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, new Float(this.myOverridenWidth));
        }
        if (this.myOverridenHeight != -1.0) {
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, new Float(this.myOverridenHeight));
        }
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_WIDTH, new Float(ICON_MAX_SIZE.get()));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_HEIGHT, new Float(ICON_MAX_SIZE.get()));
        transcoder.transcode(this.myTranscoderInput, null);
        return this.myImage;
    }

    private Dimension2D getDocumentSize() {
        SVGOMDocument document = (SVGOMDocument)this.myTranscoderInput.getDocument();
        BridgeContext ctx = new MyTranscoder().createBridgeContext(document);
        new GVTBuilder().build(ctx, (Document)document);
        Dimension2D size = ctx.getDocumentSize();
        size.setSize(size.getWidth() * this.myScale, size.getHeight() * this.myScale);
        return size;
    }

    @NotNull
    private static SVGDocument createFallbackPlaceholder() {
        try {
            String fallbackIcon = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 16 16\">\n  <rect x=\"1\" y=\"1\" width=\"14\" height=\"14\" fill=\"none\" stroke=\"red\" stroke-width=\"2\"/>\n  <line x1=\"1\" y1=\"1\" x2=\"15\" y2=\"15\" stroke=\"red\" stroke-width=\"2\"/>\n  <line x1=\"1\" y1=\"15\" x2=\"15\" y2=\"1\" stroke=\"red\" stroke-width=\"2\"/>\n</svg>\n";
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            return (SVGDocument)factory.createDocument(null, (Reader)new StringReader(fallbackIcon));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class MySVGDOMImplementation
    extends SVGDOMImplementation {
        private MySVGDOMImplementation() {
        }

        static {
            svg11Factories.put("rect", new SVGDOMImplementation.RectElementFactory(){

                public Element create(String prefix, Document doc) {
                    return new SVGOMRectElement(prefix, (AbstractDocument)doc){

                        protected SVGOMAnimatedLength createLiveAnimatedLength(String ns, String ln, String def, short dir, boolean nonneg) {
                            if (def == null && ("width".equals(ln) || "height".equals(ln))) {
                                def = "0";
                            }
                            return super.createLiveAnimatedLength(ns, ln, def, dir, nonneg);
                        }
                    };
                }
            });
        }
    }

    private static class MySAXSVGDocumentFactory
    extends SAXSVGDocumentFactory {
        MySAXSVGDocumentFactory(String parser) {
            super(parser);
            this.implementation = new MySVGDOMImplementation();
        }
    }

    public static interface SvgColorPatcher {
        @Deprecated
        default public void patchColors(Element svg) {
        }

        default public void patchColors(URL url, Element svg) {
            this.patchColors(svg);
        }
    }

    private class MyTranscoder
    extends ImageTranscoder {
        protected MyTranscoder() {
            this.width = 16.0f;
            this.height = 16.0f;
        }

        protected void setImageSize(float docWidth, float docHeight) {
            super.setImageSize((float)((double)docWidth * SVGLoader.this.myScale), (float)((double)docHeight * SVGLoader.this.myScale));
        }

        public BufferedImage createImage(int w, int h) {
            return new BufferedImage(w, h, 2);
        }

        public void writeImage(BufferedImage img, TranscoderOutput output) {
            SVGLoader.this.myImage = img;
        }

        protected UserAgent createUserAgent() {
            return new SVGAbstractTranscoder.SVGAbstractTranscoderUserAgent(){

                public SVGDocument getBrokenLinkDocument(Element e, String url, String message) {
                    LOG.warn(url + " " + message);
                    return SVGLoader.createFallbackPlaceholder();
                }
            };
        }

        public BridgeContext createBridgeContext(SVGOMDocument doc) {
            return super.createBridgeContext(doc);
        }
    }
}

