/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.SingletonIteratorBase;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import org.jetbrains.annotations.NotNull;

public class SmartList<E>
extends AbstractList<E>
implements RandomAccess {
    private int mySize;
    private Object myElem;

    public SmartList() {
    }

    public SmartList(E element) {
        this.add(element);
    }

    public SmartList(@NotNull Collection<? extends E> elements) {
        int size = elements.size();
        if (size == 1) {
            E element = elements instanceof List ? ((List)elements).get(0) : elements.iterator().next();
            this.add(element);
        } else if (size > 0) {
            this.mySize = size;
            this.myElem = elements.toArray(new Object[size]);
        }
    }

    public SmartList(E ... elements) {
        if (elements.length == 1) {
            this.add(elements[0]);
        } else if (elements.length > 0) {
            this.mySize = elements.length;
            this.myElem = Arrays.copyOf(elements, this.mySize);
        }
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            return (E)this.myElem;
        }
        return (E)((Object[])this.myElem)[index];
    }

    @Override
    public boolean add(E e) {
        if (this.mySize == 0) {
            this.myElem = e;
        } else if (this.mySize == 1) {
            Object[] array = new Object[]{this.myElem, e};
            this.myElem = array;
        } else {
            Object[] array = (Object[])this.myElem;
            int oldCapacity = array.length;
            if (this.mySize >= oldCapacity) {
                int newCapacity = oldCapacity * 3 / 2 + 1;
                int minCapacity = this.mySize + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                Object[] oldArray = array;
                array = new Object[newCapacity];
                this.myElem = array;
                System.arraycopy(oldArray, 0, array, 0, oldCapacity);
            }
            array[this.mySize] = e;
        }
        ++this.mySize;
        ++this.modCount;
        return true;
    }

    @Override
    public void add(int index, E e) {
        if (index < 0 || index > this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 0) {
            this.myElem = e;
        } else if (this.mySize == 1 && index == 0) {
            Object[] array = new Object[]{e, this.myElem};
            this.myElem = array;
        } else {
            Object[] array = new Object[this.mySize + 1];
            if (this.mySize == 1) {
                array[0] = this.myElem;
            } else {
                Object[] oldArray = (Object[])this.myElem;
                System.arraycopy(oldArray, 0, array, 0, index);
                System.arraycopy(oldArray, index, array, index + 1, this.mySize - index);
            }
            array[index] = e;
            this.myElem = array;
        }
        ++this.mySize;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public void clear() {
        this.myElem = null;
        this.mySize = 0;
        ++this.modCount;
    }

    @Override
    public E set(int index, E element) {
        Object oldValue;
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            oldValue = this.myElem;
            this.myElem = element;
        } else {
            Object[] array = (Object[])this.myElem;
            oldValue = array[index];
            array[index] = element;
        }
        return (E)oldValue;
    }

    @Override
    public E remove(int index) {
        Object oldValue;
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            oldValue = this.myElem;
            this.myElem = null;
        } else {
            Object[] array = (Object[])this.myElem;
            oldValue = array[index];
            if (this.mySize == 2) {
                this.myElem = array[1 - index];
            } else {
                int numMoved = this.mySize - index - 1;
                if (numMoved > 0) {
                    System.arraycopy(array, index + 1, array, index, numMoved);
                }
                array[this.mySize - 1] = null;
            }
        }
        --this.mySize;
        ++this.modCount;
        return (E)oldValue;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        if (this.mySize == 0) {
            return EmptyIterator.getInstance();
        }
        if (this.mySize == 1) {
            return new SingletonIterator();
        }
        return super.iterator();
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.mySize >= 2) {
            Arrays.sort((Object[])this.myElem, 0, this.mySize, comparator);
        }
    }

    public int getModificationCount() {
        return this.modCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        int aLength = a.length;
        if (this.mySize == 1) {
            if (aLength == 0) {
                Object[] r = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
                r[0] = this.myElem;
                return r;
            }
            a[0] = this.myElem;
        } else {
            if (aLength < this.mySize) {
                return Arrays.copyOf((Object[])this.myElem, this.mySize, a.getClass());
            }
            if (this.mySize != 0) {
                System.arraycopy(this.myElem, 0, a, 0, this.mySize);
            }
        }
        if (aLength > this.mySize) {
            a[this.mySize] = null;
        }
        return a;
    }

    public void trimToSize() {
        if (this.mySize < 2) {
            return;
        }
        Object[] array = (Object[])this.myElem;
        int oldCapacity = array.length;
        if (this.mySize < oldCapacity) {
            ++this.modCount;
            this.myElem = Arrays.copyOf(array, this.mySize);
        }
    }

    @Override
    public int indexOf(Object o) {
        if (this.mySize == 0) {
            return -1;
        }
        if (this.mySize == 1) {
            if (o == null) {
                return this.myElem == null ? 0 : -1;
            }
            return o.equals(this.myElem) ? 0 : -1;
        }
        Object[] array = (Object[])this.myElem;
        if (o == null) {
            for (int i = 0; i < this.mySize; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.mySize; ++i) {
                if (!o.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SmartList) {
            return this.equalsWithSmartList((SmartList)o);
        }
        if (o instanceof ArrayList) {
            return this.equalsWithArrayList((ArrayList)o);
        }
        return super.equals(o);
    }

    private boolean equalsWithSmartList(SmartList that) {
        if (this.mySize != that.mySize) {
            return false;
        }
        if (this.mySize == 1) {
            return Objects.equals(this.myElem, that.myElem);
        }
        return this.compareOneByOne(that);
    }

    private boolean equalsWithArrayList(ArrayList that) {
        if (this.mySize != that.size()) {
            return false;
        }
        if (this.mySize == 1) {
            return Objects.equals(this.myElem, that.get(0));
        }
        return this.compareOneByOne(that);
    }

    private boolean compareOneByOne(List that) {
        for (int i = 0; i < this.mySize; ++i) {
            Object o2;
            E o1 = this.get(i);
            if (Objects.equals(o1, o2 = that.get(i))) continue;
            return false;
        }
        return true;
    }

    private class SingletonIterator
    extends SingletonIteratorBase<E> {
        private final int myInitialModCount;

        SingletonIterator() {
            this.myInitialModCount = SmartList.this.modCount;
        }

        @Override
        protected E getElement() {
            return SmartList.this.myElem;
        }

        @Override
        protected void checkCoModification() {
            if (SmartList.this.modCount != this.myInitialModCount) {
                throw new ConcurrentModificationException("ModCount: " + SmartList.this.modCount + "; expected: " + this.myInitialModCount);
            }
        }

        @Override
        public void remove() {
            this.checkCoModification();
            SmartList.this.clear();
        }
    }
}

