/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemProperties {
    private static String ourTestUserName;

    private SystemProperties() {
    }

    @NotNull
    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getUserName() {
        return ourTestUserName != null ? ourTestUserName : System.getProperty("user.name");
    }

    public static void setTestUserName(@Nullable String name) {
        ourTestUserName = name;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    @Deprecated
    public static String getOsName() {
        return SystemInfo.OS_NAME;
    }

    @Deprecated
    public static String getJavaVersion() {
        return SystemInfo.JAVA_VERSION;
    }

    @Deprecated
    public static String getJavaVmVendor() {
        return SystemInfo.JAVA_VENDOR;
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static int getIntProperty(@NotNull String key, int defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(@NotNull String key, boolean defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    @Deprecated
    public static String getJavaVendor() {
        return SystemInfo.JAVA_VENDOR;
    }

    public static boolean is(String key) {
        return SystemProperties.getBooleanProperty(key, false);
    }

    public static boolean has(String key) {
        return System.getProperty(key) != null;
    }

    public static boolean isTrueSmoothScrollingEnabled() {
        return SystemProperties.getBooleanProperty("idea.true.smooth.scrolling", false);
    }
}

