/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionUtil {
    @Nullable
    public static Version parseVersion(@NotNull String version, Pattern ... patterns) {
        String[] versions = null;
        for (Pattern pattern : patterns) {
            String versionGroup;
            Matcher matcher = pattern.matcher(version);
            if (!matcher.find() || (versionGroup = matcher.group(1)) == null) continue;
            versions = versionGroup.split("\\.");
            break;
        }
        if (versions == null || versions.length < 2) {
            return null;
        }
        return new Version(Integer.parseInt((String)versions[0]), Integer.parseInt((String)versions[1]), versions.length > 2 ? Integer.parseInt(versions[2]) : 0);
    }
}

