/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.concurrency.BoundedScheduledExecutorService;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AppExecutorUtil {
    @NotNull
    public static ScheduledExecutorService getAppScheduledExecutorService() {
        return AppScheduledExecutorService.getInstance();
    }

    @NotNull
    public static ExecutorService getAppExecutorService() {
        return ((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).backendExecutorService;
    }

    @NotNull
    public static ScheduledExecutorService createBoundedScheduledExecutorService(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name, int maxThreads) {
        return new BoundedScheduledExecutorService(name, AppExecutorUtil.getAppExecutorService(), maxThreads);
    }

    @NotNull
    public static ExecutorService createBoundedApplicationPoolExecutor(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name, int maxThreads) {
        return AppExecutorUtil.createBoundedApplicationPoolExecutor(name, AppExecutorUtil.getAppExecutorService(), maxThreads);
    }

    @NotNull
    public static ExecutorService createBoundedApplicationPoolExecutor(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name, @NotNull Executor backendExecutor, int maxThreads) {
        return new BoundedTaskExecutor(name, backendExecutor, maxThreads);
    }

    @NotNull
    public static ExecutorService createBoundedApplicationPoolExecutor(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name, @NotNull Executor backendExecutor, int maxThreads, @NotNull Disposable parentDisposable) {
        return new BoundedTaskExecutor(name, backendExecutor, maxThreads, parentDisposable);
    }
}

