/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.CountingThreadFactory;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AppScheduledExecutorService
extends SchedulingWrapper {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.ide.PooledThreadExecutor");
    static final String POOLED_THREAD_PREFIX = "ApplicationImpl pooled thread ";
    @NotNull
    private final String myName;
    private final LowMemoryWatcherManager myLowMemoryWatcherManager;
    private final MyThreadFactory myCountingThreadFactory;

    @NotNull
    static ScheduledExecutorService getInstance() {
        return Holder.INSTANCE;
    }

    AppScheduledExecutorService(@NotNull String name) {
        super(new BackendThreadPoolExecutor(new MyThreadFactory()), new AppDelayQueue());
        this.myName = name;
        this.myCountingThreadFactory = (MyThreadFactory)((BackendThreadPoolExecutor)this.backendExecutorService).getThreadFactory();
        this.myLowMemoryWatcherManager = new LowMemoryWatcherManager(this);
    }

    public void setNewThreadListener(@NotNull Consumer<? super Thread> threadListener) {
        this.myCountingThreadFactory.setNewThreadListener(threadListener);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return AppScheduledExecutorService.error();
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    static List<Runnable> error() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void doShutdown() {
        super.doShutdown();
        ((BackendThreadPoolExecutor)this.backendExecutorService).doShutdown();
    }

    @Override
    @NotNull
    List<Runnable> doShutdownNow() {
        return ContainerUtil.concat(super.doShutdownNow(), ((BackendThreadPoolExecutor)this.backendExecutorService).doShutdownNow());
    }

    public void shutdownAppScheduledExecutorService() {
        Disposer.dispose(this.myLowMemoryWatcherManager);
        this.delayQueue.shutdown();
        this.doShutdown();
    }

    @NotNull
    public String statistics() {
        return this.myName + " threads created counter = " + this.myCountingThreadFactory.counter;
    }

    public String dumpQueue() {
        return this.delayQueue.toString();
    }

    public int getBackendPoolExecutorSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getPoolSize();
    }

    void setBackendPoolCorePoolSize(int size) {
        ((BackendThreadPoolExecutor)this.backendExecutorService).doSetCorePoolSize(size);
    }

    int getBackendPoolCorePoolSize() {
        return ((BackendThreadPoolExecutor)this.backendExecutorService).getCorePoolSize();
    }

    @NotNull
    public Thread getPeriodicTasksThread() {
        return this.delayQueue.getThread();
    }

    private static class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        BackendThreadPoolExecutor(@NotNull ThreadFactory factory) {
            super(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), factory);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("beforeExecute " + BoundedTaskExecutor.info(r) + " in " + t);
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("afterExecute  " + BoundedTaskExecutor.info(r) + " in " + Thread.currentThread());
            }
            if (t != null) {
                LOG.error("Worker exited due to exception", t);
            }
        }

        private void doShutdown() {
            super.shutdown();
        }

        @NotNull
        private List<Runnable> doShutdownNow() {
            return super.shutdownNow();
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.error();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            return AppScheduledExecutorService.error();
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.error();
        }

        private void doSetCorePoolSize(int corePoolSize) {
            super.setCorePoolSize(corePoolSize);
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setThreadFactory(ThreadFactory threadFactory) {
            AppScheduledExecutorService.error();
        }
    }

    private static class MyThreadFactory
    extends CountingThreadFactory {
        private Consumer<? super Thread> newThreadListener;

        private MyThreadFactory() {
        }

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = new Thread(r, AppScheduledExecutorService.POOLED_THREAD_PREFIX + this.counter.incrementAndGet());
            thread.setPriority(4);
            Consumer<? super Thread> listener = this.newThreadListener;
            if (listener != null) {
                listener.consume(thread);
            }
            return thread;
        }

        void setNewThreadListener(@NotNull Consumer<? super Thread> threadListener) {
            if (this.newThreadListener != null) {
                throw new IllegalStateException("Listener was already set: " + this.newThreadListener);
            }
            this.newThreadListener = threadListener;
        }
    }

    private static class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService("Global instance");

        private Holder() {
        }
    }
}

