/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.Patches;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BoundedTaskExecutor
extends AbstractExecutorService {
    private static final Logger LOG = Logger.getInstance(BoundedTaskExecutor.class);
    private volatile boolean myShutdown;
    @NotNull
    private final String myName;
    private final Executor myBackendExecutor;
    private final int myMaxThreads;
    private final AtomicLong myStatus = new AtomicLong();
    private final BlockingQueue<Runnable> myTaskQueue = new LinkedBlockingQueue<Runnable>();

    BoundedTaskExecutor(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name, @NotNull Executor backendExecutor, int maxThreads) {
        this.myName = name;
        this.myBackendExecutor = backendExecutor;
        if (maxThreads < 1) {
            throw new IllegalArgumentException("maxThreads must be >=1 but got: " + maxThreads);
        }
        if (backendExecutor instanceof BoundedTaskExecutor) {
            throw new IllegalArgumentException("backendExecutor is already BoundedTaskExecutor: " + backendExecutor);
        }
        this.myMaxThreads = maxThreads;
    }

    @Deprecated
    public BoundedTaskExecutor(@NotNull Executor backendExecutor, int maxSimultaneousTasks) {
        this(ExceptionUtil.getThrowableText(new Throwable("Creation point:")), backendExecutor, maxSimultaneousTasks);
    }

    BoundedTaskExecutor(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String name, @NotNull Executor backendExecutor, int maxSimultaneousTasks, @NotNull Disposable parent) {
        this(name, backendExecutor, maxSimultaneousTasks);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                BoundedTaskExecutor.this.shutdownNow();
            }
        });
    }

    static Object info(Runnable info) {
        Runnable task = info;
        String extra = null;
        if (task instanceof FutureTask) {
            extra = ((FutureTask)task).isCancelled() ? " (future cancelled)" : (((FutureTask)task).isDone() ? " (future done)" : null);
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Callable.class, "callable"), task);
        }
        if (task instanceof Callable && task.getClass().getName().equals("java.util.concurrent.Executors$RunnableAdapter")) {
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Runnable.class, "task"), task);
        }
        return extra == null ? task : task.getClass() + extra;
    }

    @Override
    public void shutdown() {
        if (this.myShutdown) {
            throw new IllegalStateException("Already shutdown: " + this);
        }
        this.myShutdown = true;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return this.clearAndCancelAll();
    }

    @Override
    public boolean isShutdown() {
        return this.myShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.myShutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        if (!this.isShutdown()) {
            throw new IllegalStateException("you must call shutdown() or shutdownNow() first");
        }
        try {
            this.waitAllTasksExecuted(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    @Override
    public void execute(@NotNull @Async.Schedule Runnable task) {
        if (this.isShutdown() && !(task instanceof LastTask)) {
            throw new RejectedExecutionException("Already shutdown");
        }
        long status = this.incrementCounterAndTimestamp();
        int inProgress = (int)status;
        assert (inProgress > 0) : inProgress;
        if (inProgress <= this.myMaxThreads) {
            this.wrapAndExecute(task, status);
            return;
        }
        if (!this.myTaskQueue.offer(task)) {
            throw new RejectedExecutionException();
        }
        Runnable next = this.pollOrGiveUp(status);
        if (next != null) {
            this.wrapAndExecute(next, status);
        }
    }

    private long incrementCounterAndTimestamp() {
        long newStatus;
        long status;
        while (!this.myStatus.compareAndSet(status = this.myStatus.get(), newStatus = status + 1L + 0x100000000L & Long.MAX_VALUE)) {
        }
        return newStatus;
    }

    private Runnable pollOrGiveUp(long status) {
        while (true) {
            Runnable next;
            int inProgress = (int)status;
            assert (inProgress > 0) : inProgress;
            if (inProgress <= this.myMaxThreads && (next = (Runnable)this.myTaskQueue.poll()) != null) {
                return next;
            }
            if (this.myStatus.compareAndSet(status, status - 1L)) break;
            status = this.myStatus.get();
        }
        return null;
    }

    private void wrapAndExecute(@NotNull Runnable firstTask, final long status) {
        try {
            final AtomicReference<Runnable> currentTask = new AtomicReference<Runnable>(firstTask);
            this.myBackendExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ConcurrencyUtil.runUnderThreadName(BoundedTaskExecutor.this.myName, () -> {
                        Runnable task = (Runnable)currentTask.get();
                        do {
                            currentTask.set(task);
                            BoundedTaskExecutor.doRun(task);
                        } while ((task = BoundedTaskExecutor.this.pollOrGiveUp(status)) != null);
                    });
                }

                public String toString() {
                    return String.valueOf(BoundedTaskExecutor.info((Runnable)currentTask.get()));
                }
            });
        }
        catch (Error | RuntimeException e) {
            this.myStatus.decrementAndGet();
            throw e;
        }
    }

    private static void doRun(@Async.Execute Runnable task) {
        block4: {
            try {
                task.run();
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) break block4;
                try {
                    LOG.error(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void waitAllTasksExecuted(long timeout, @NotNull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        CountDownLatch started = new CountDownLatch(this.myMaxThreads);
        CountDownLatch readyToFinish = new CountDownLatch(1);
        Runnable runnable = () -> {
            try {
                started.countDown();
                readyToFinish.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
        List<Future> futures = ContainerUtil.map(Collections.nCopies(this.myMaxThreads, null), o -> {
            LastTask wait = new LastTask(runnable);
            this.execute(wait);
            return wait;
        });
        try {
            if (!started.await(timeout, unit)) {
                throw new TimeoutException("Interrupted by timeout. " + this);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            readyToFinish.countDown();
        }
        for (Future future : futures) {
            future.get(timeout, unit);
        }
    }

    @NotNull
    public List<Runnable> clearAndCancelAll() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>();
        this.myTaskQueue.drainTo(queued);
        for (Runnable task : queued) {
            if (!(task instanceof FutureTask)) continue;
            ((FutureTask)task).cancel(false);
        }
        return queued;
    }

    public String toString() {
        return "BoundedExecutor(" + this.myMaxThreads + ") " + (this.isShutdown() ? "SHUTDOWN " : "") + "inProgress: " + (int)this.myStatus.get() + "; " + (this.myTaskQueue.isEmpty() ? "" : "Queue size: " + this.myTaskQueue.size() + "; tasks in queue: [" + ContainerUtil.map(this.myTaskQueue, BoundedTaskExecutor::info) + "]") + "name: " + this.myName;
    }

    static {
        assert (Patches.USE_REFLECTION_TO_ACCESS_JDK8);
    }

    private static class LastTask
    extends FutureTask<Void> {
        LastTask(@NotNull Runnable runnable) {
            super(runnable, null);
        }
    }
}

