/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

class SchedulingWrapper
implements ScheduledExecutorService {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.concurrency.SchedulingWrapper");
    private final AtomicBoolean shutdown = new AtomicBoolean();
    @NotNull
    final ExecutorService backendExecutorService;
    final AppDelayQueue delayQueue;
    private static final AtomicLong sequencer = new AtomicLong();

    SchedulingWrapper(@NotNull ExecutorService backendExecutorService, @NotNull AppDelayQueue delayQueue) {
        this.delayQueue = delayQueue;
        if (backendExecutorService instanceof ScheduledExecutorService) {
            throw new IllegalArgumentException("backendExecutorService: " + backendExecutorService + " is already ScheduledExecutorService");
        }
        this.backendExecutorService = backendExecutorService;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        return this.doShutdownNow();
    }

    @Override
    public void shutdown() {
        this.doShutdown();
    }

    void doShutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            throw new IllegalStateException("Already shutdown");
        }
    }

    @NotNull
    List<Runnable> doShutdownNow() {
        this.doShutdown();
        return this.cancelAndRemoveTasksFromQueue();
    }

    @NotNull
    List<Runnable> cancelAndRemoveTasksFromQueue() {
        List<Runnable> result = ContainerUtil.filter(this.delayQueue, task -> {
            if (((MyScheduledFutureTask)task).getBackendExecutorService() == this.backendExecutorService) {
                task.cancel(false);
                return true;
            }
            return false;
        });
        this.delayQueue.removeAll(new HashSet<MyScheduledFutureTask>(result));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Shutdown. Drained tasks: " + result);
        }
        return result;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        if (!this.isShutdown()) {
            throw new IllegalStateException("must await termination after shutdown() or shutdownNow() only");
        }
        ArrayList<MyScheduledFutureTask> tasks = new ArrayList<MyScheduledFutureTask>(this.delayQueue);
        for (MyScheduledFutureTask task : tasks) {
            if (task.getBackendExecutorService() != this.backendExecutorService) continue;
            try {
                task.get(timeout, unit);
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        return this.backendExecutorService.awaitTermination(timeout, unit);
    }

    static long triggerTime(@NotNull AppDelayQueue queue, long delay, TimeUnit unit) {
        return SchedulingWrapper.triggerTime(queue, unit.toNanos(delay < 0L ? 0L : delay));
    }

    private static long now() {
        return System.nanoTime();
    }

    private static long triggerTime(@NotNull AppDelayQueue queue, long delay) {
        return SchedulingWrapper.now() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : SchedulingWrapper.overflowFree(queue, delay));
    }

    private static long overflowFree(@NotNull AppDelayQueue queue, long delay) {
        long headDelay;
        Object head = queue.peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
        MyScheduledFutureTask<Object> t = new MyScheduledFutureTask<Object>(command, null, SchedulingWrapper.triggerTime(this.delayQueue, delay, unit));
        return this.delayedExecute(t);
    }

    @NotNull
    <T> MyScheduledFutureTask<T> delayedExecute(@NotNull MyScheduledFutureTask<T> t) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Submit at delay " + t.getDelay(TimeUnit.MILLISECONDS) + "ms " + BoundedTaskExecutor.info(t));
        }
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Already shutdown");
        }
        this.delayQueue.add(t);
        if (t.getDelay(TimeUnit.DAYS) > 31L && !t.isPeriodic()) {
            throw new IllegalArgumentException("Unsupported crazy delay " + t.getDelay(TimeUnit.DAYS) + " days: " + BoundedTaskExecutor.info(t));
        }
        return t;
    }

    @Override
    @NotNull
    public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
        MyScheduledFutureTask t = new MyScheduledFutureTask(callable, SchedulingWrapper.triggerTime(this.delayQueue, delay, unit));
        return this.delayedExecute(t);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
        throw new IncorrectOperationException("Not supported because it's bad for hibernation; use scheduleWithFixedDelay() with the same parameters instead.");
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit unit) {
        if (delay <= 0L) {
            throw new IllegalArgumentException("delay must be positive but got: " + delay);
        }
        MyScheduledFutureTask sft = new MyScheduledFutureTask(command, null, SchedulingWrapper.triggerTime(this.delayQueue, initialDelay, unit), unit.toNanos(-delay));
        return this.delayedExecute(sft);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        return this.backendExecutorService.submit(task);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        return this.backendExecutorService.submit(task, result);
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        return this.backendExecutorService.submit(task);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.backendExecutorService.invokeAll(tasks);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        return this.backendExecutorService.invokeAll(tasks, timeout, unit);
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.backendExecutorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.backendExecutorService.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        this.backendExecutorService.execute(command);
    }

    class MyScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;

        MyScheduledFutureTask(Runnable r, V result, long ns) {
            super(r, result);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        private MyScheduledFutureTask(Runnable r, V result, long ns, long period) {
            super(r, result);
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        private MyScheduledFutureTask(Callable<V> callable, long ns) {
            super(callable);
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean canceled = super.cancel(mayInterruptIfRunning);
            SchedulingWrapper.this.delayQueue.remove(this);
            return canceled;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            return unit.convert(this.time - SchedulingWrapper.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof MyScheduledFutureTask) {
                MyScheduledFutureTask x = (MyScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : SchedulingWrapper.triggerTime(SchedulingWrapper.this.delayQueue, -p);
        }

        @Override
        public void run() {
            boolean periodic;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Executing " + BoundedTaskExecutor.info(this));
            }
            if (!(periodic = this.isPeriodic())) {
                super.run();
            } else if (this.runAndReset()) {
                this.setNextRunTime();
                SchedulingWrapper.this.delayQueue.offer(this);
            }
        }

        @Override
        public String toString() {
            Object info = BoundedTaskExecutor.info(this);
            return "Delay: " + this.getDelay(TimeUnit.MILLISECONDS) + "ms; " + (info == this ? super.toString() : info) + " backendExecutorService: " + SchedulingWrapper.this.backendExecutorService;
        }

        @NotNull
        private ExecutorService getBackendExecutorService() {
            return SchedulingWrapper.this.backendExecutorService;
        }

        void executeMeInBackendExecutor() {
            SchedulingWrapper.this.backendExecutorService.execute(this);
        }
    }
}

