/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BidirectionalMap<K, V>
implements Map<K, V> {
    private final Map<K, V> myKeyToValueMap = new THashMap();
    private final Map<V, List<K>> myValueToKeysMap = new THashMap();

    @Override
    public V put(K key, V value) {
        List<K> array;
        V oldValue = this.myKeyToValueMap.put(key, value);
        if (oldValue != null) {
            if (oldValue.equals(value)) {
                return oldValue;
            }
            array = this.myValueToKeysMap.get(oldValue);
            array.remove(key);
            if (array.isEmpty()) {
                this.myValueToKeysMap.remove(oldValue);
            }
        }
        if ((array = this.myValueToKeysMap.get(value)) == null) {
            array = new ArrayList<K>();
            this.myValueToKeysMap.put((List<K>)value, (List<V>)array);
        }
        array.add(key);
        return oldValue;
    }

    @Override
    public void clear() {
        this.myKeyToValueMap.clear();
        this.myValueToKeysMap.clear();
    }

    @Nullable
    public List<K> getKeysByValue(V value) {
        return this.myValueToKeysMap.get(value);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.myKeyToValueMap.keySet();
    }

    @Override
    public int size() {
        return this.myKeyToValueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myKeyToValueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myKeyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myValueToKeysMap.containsKey(value);
    }

    @Override
    public V get(Object key) {
        return this.myKeyToValueMap.get(key);
    }

    public void removeValue(V v) {
        List<K> ks = this.myValueToKeysMap.remove(v);
        if (ks != null) {
            for (K k : ks) {
                this.myKeyToValueMap.remove(k);
            }
        }
    }

    @Override
    public V remove(Object key) {
        V value = this.myKeyToValueMap.remove(key);
        List<K> ks = this.myValueToKeysMap.get(value);
        if (ks != null) {
            if (ks.size() > 1) {
                ks.remove(key);
            } else {
                this.myValueToKeysMap.remove(value);
            }
        }
        return value;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        for (K k1 : t.keySet()) {
            this.put(k1, t.get(k1));
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.myValueToKeysMap.keySet();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.myKeyToValueMap.entrySet();
    }

    public String toString() {
        return new HashMap<K, V>(this.myKeyToValueMap).toString();
    }
}

