/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.Convertor;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparatorUtil {
    private ComparatorUtil() {
    }

    @NotNull
    public static <Type, Aspect> Comparator<Type> compareBy(@NotNull Convertor<? super Type, ? extends Aspect> aspect, @NotNull Comparator<? super Aspect> comparator) {
        return (element1, element2) -> comparator.compare((Object)aspect.convert((Object)element1), (Object)aspect.convert((Object)element2));
    }

    @NotNull
    public static <T extends Comparable<T>> T max(@NotNull T o1, @NotNull T o2) {
        return o1.compareTo(o2) >= 0 ? o1 : o2;
    }

    @NotNull
    public static <T extends Comparable<T>> T min(@NotNull T o1, @NotNull T o2) {
        return o1.compareTo(o2) >= 0 ? o2 : o1;
    }

    public static <T> boolean equalsNullable(@Nullable T a, @Nullable T b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

