/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ConcurrentInstanceMap {
    private ConcurrentInstanceMap() {
    }

    @NotNull
    public static <T> Map<Class<? extends T>, T> create() {
        return ConcurrentFactoryMap.createMap(ConcurrentInstanceMap::calculate);
    }

    @NotNull
    public static <T> T calculate(@NotNull Class<? extends T> key) {
        try {
            return key.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Couldn't instantiate " + key, e);
        }
    }
}

