/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ConcurrentMultiMap<K, V>
extends MultiMap<K, V> {
    @Override
    @NotNull
    protected ConcurrentMap<K, Collection<V>> createMap() {
        return ContainerUtil.newConcurrentMap();
    }

    @Override
    @NotNull
    protected Collection<V> createCollection() {
        return ContainerUtil.createLockFreeCopyOnWriteList();
    }

    @Override
    public void putValue(@NotNull K key, V value) {
        Collection<V> collection = (Collection<V>)this.myMap.get(key);
        if (collection == null) {
            Collection<V> newCollection = this.createCollection();
            collection = ConcurrencyUtil.cacheOrGet((ConcurrentMap)this.myMap, key, newCollection);
        }
        collection.add(value);
    }
}

