/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RefValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, ValueReference<K, V>> myMap = ContainerUtil.newConcurrentMap();
    protected final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentRefValueHashMap() {
    }

    boolean processQueue() {
        ValueReference ref;
        boolean processed = false;
        while ((ref = (ValueReference)((Object)this.myQueue.poll())) != null) {
            this.myMap.remove(ref.getKey(), ref);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(@NotNull Object key) {
        ValueReference ref = (ValueReference)this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        this.processQueue();
        ValueReference<K, V> oldRef = this.myMap.put(key, this.createValueReference(key, value));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    @NotNull
    abstract ValueReference<K, V> createValueReference(@NotNull K var1, @NotNull V var2);

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        V oldVal;
        block2: {
            ValueReference<K, V> oldRef;
            ValueReference<K, V> newRef = this.createValueReference(key, value);
            do {
                this.processQueue();
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block2;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return oldVal;
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        this.processQueue();
        return this.myMap.remove(key, this.createValueReference(key, value));
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        this.processQueue();
        return this.myMap.replace(key, this.createValueReference(key, oldValue), this.createValueReference(key, newValue));
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        this.processQueue();
        ValueReference<K, V> ref = this.myMap.replace(key, this.createValueReference(key, value));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(@NotNull Object key) {
        this.processQueue();
        ValueReference ref = (ValueReference)this.myMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        this.processQueue();
        for (Map.Entry<K, V> entry : t.entrySet()) {
            V v = entry.getValue();
            if (v == null) continue;
            K key = entry.getKey();
            this.put(key, v);
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        throw RefValueHashMap.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(@NotNull Object value) {
        throw RefValueHashMap.pointlessContainsValue();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection refs = this.myMap.values();
        for (ValueReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keys = this.keySet();
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (final K key : keys) {
            final V value = this.get(key);
            if (value == null) continue;
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(@NotNull V value2) {
                    throw new UnsupportedOperationException("setValue is not implemented");
                }

                public String toString() {
                    return "(" + this.getKey() + " : " + this.getValue() + ")";
                }
            });
        }
        return entries;
    }

    public String toString() {
        return "map size:" + this.size() + " [" + StringUtil.join(this.entrySet(), ",") + "]";
    }

    static interface ValueReference<K, V> {
        @NotNull
        public K getKey();

        public V get();
    }
}

