/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SingletonSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentIntKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.IntKeyWeakValueHashMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.SoftKeySoftValueHashMap;
import com.intellij.util.containers.SoftValueHashMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.containers.WeakHashSet;
import com.intellij.util.containers.WeakKeyIntValueHashMap;
import com.intellij.util.containers.WeakKeySoftValueHashMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import com.intellij.util.containers.WeakValueHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil
extends ContainerUtilRt {
    private static final int INSERTION_SORT_THRESHOLD = 10;

    @NotNull
    @Contract(pure=true)
    public static <T> T[] ar(T ... elements) {
        return elements;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        return ContainerUtilRt.newHashMap(first, entries);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull List<? extends K> keys, @NotNull List<? extends V> values) {
        return ContainerUtilRt.newHashMap(keys, values);
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable<? super K>, V> TreeMap<K, V> newTreeMap() {
        return ContainerUtilRt.newTreeMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable<? super K>, V> TreeMap<K, V> newTreeMap(@NotNull Map<? extends K, ? extends V> map) {
        return ContainerUtilRt.newTreeMap(map);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return ContainerUtilRt.newLinkedHashMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        return ContainerUtilRt.newLinkedHashMap(capacity);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Map<? extends K, ? extends V> map) {
        return ContainerUtilRt.newLinkedHashMap(map);
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        return ContainerUtilRt.newLinkedHashMap(first, entries);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap() {
        return new THashMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap(@NotNull TObjectHashingStrategy<K> strategy) {
        return new THashMap(strategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(@NotNull Class<K> keyType) {
        return new EnumMap(keyType);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        return TObjectHashingStrategy.CANONICAL;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        return TObjectHashingStrategy.IDENTITY;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        return ContainerUtilRt.newLinkedList();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        return ContainerUtilRt.newLinkedList(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Iterable<? extends T> elements) {
        return ContainerUtilRt.newLinkedList(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(E ... array) {
        return ContainerUtilRt.newArrayList(array);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        return ContainerUtilRt.newArrayList(iterable);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        return new ArrayList(size);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        return new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + this.size);
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newUnmodifiableList(List<? extends T> originalList) {
        int size = originalList.size();
        if (size == 0) {
            return ContainerUtil.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(originalList.get(0));
        }
        return Collections.unmodifiableList(new ArrayList<T>(originalList));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> unmodifiableOrEmptyCollection(@NotNull Collection<? extends T> original) {
        int size = original.size();
        if (size == 0) {
            return ContainerUtil.emptyList();
        }
        return Collections.unmodifiableCollection(original);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> unmodifiableOrEmptyList(@NotNull List<? extends T> original) {
        int size = original.size();
        if (size == 0) {
            return ContainerUtil.emptyList();
        }
        return Collections.unmodifiableList(original);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> unmodifiableOrEmptySet(@NotNull Set<? extends T> original) {
        int size = original.size();
        if (size == 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(original);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> unmodifiableOrEmptyMap(@NotNull Map<? extends K, ? extends V> original) {
        int size = original.size();
        if (size == 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(original);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList() {
        return new SmartList();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T element) {
        return new SmartList<T>(element);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T ... elements) {
        return new SmartList<T>(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        return ContainerUtilRt.newHashSet(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        return ContainerUtilRt.newHashSet(iterable);
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator) {
        return ContainerUtilRt.newHashSet(iterator);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean empty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        return empty ? Collections.emptySet() : ContainerUtilRt.newHashSet(iterable);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return ContainerUtilRt.newLinkedHashSet();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        return ContainerUtilRt.newLinkedHashSet(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        return ContainerUtilRt.newLinkedHashSet(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet() {
        return new THashSet();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy) {
        return new THashSet(strategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        return ContainerUtil.newTroveSet(Arrays.asList(elements));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, T ... elements) {
        return new THashSet(Arrays.asList(elements), strategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, @NotNull Collection<? extends T> elements) {
        return new THashSet(elements, strategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull Collection<? extends T> elements) {
        return new THashSet(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet() {
        return new THashSet(ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(int initialCapacity) {
        return new THashSet(initialCapacity, ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(@NotNull Collection<? extends K> collection) {
        return new THashSet(collection, ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        return new THashMap(ContainerUtil.identityStrategy());
    }

    @NotNull
    @Contract(pure=true)
    public static <T extends Comparable<? super T>> TreeSet<T> newTreeSet() {
        return ContainerUtilRt.newTreeSet();
    }

    @NotNull
    @Contract(pure=true)
    public static <T extends Comparable<? super T>> TreeSet<T> newTreeSet(@NotNull Iterable<? extends T> elements) {
        return ContainerUtilRt.newTreeSet(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<? super T> comparator) {
        return ContainerUtilRt.newTreeSet(comparator);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet() {
        return Collections.newSetFromMap(ContainerUtil.newConcurrentMap());
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> reverse(final @NotNull List<? extends E> elements) {
        if (elements.isEmpty()) {
            return ContainerUtilRt.emptyList();
        }
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return elements.get(elements.size() - 1 - index);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> union(@NotNull Map<? extends K, ? extends V> map, @NotNull Map<? extends K, ? extends V> map2) {
        THashMap result = new THashMap(map.size() + map2.size());
        result.putAll(map);
        result.putAll(map2);
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> union(@NotNull Set<? extends T> set, @NotNull Set<? extends T> set2) {
        return ContainerUtil.union(set, set2);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> union(@NotNull Collection<? extends T> set, @NotNull Collection<? extends T> set2) {
        THashSet result = new THashSet(set.size() + set2.size());
        result.addAll(set);
        result.addAll(set2);
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> Set<E> immutableSet(E ... elements) {
        switch (elements.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(elements[0]);
            }
        }
        return Collections.unmodifiableSet(new THashSet(Arrays.asList(elements)));
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(E ... array) {
        return new ImmutableListBackedByArray(array);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableSingletonList(E element) {
        return ImmutableList.singleton(element);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(@NotNull List<? extends E> list) {
        return new ImmutableListBackedByList(list);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        return new ImmutableMapBuilder();
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> MultiMap<K, V> groupBy(@NotNull Iterable<? extends V> collection, @NotNull NullableFunction<? super V, ? extends K> grouper) {
        MultiMap<K, V> result = MultiMap.createLinked();
        for (V data : collection) {
            K key = grouper.fun(data);
            if (key == null) continue;
            result.putValue(key, data);
        }
        if (!result.isEmpty() && result.keySet().iterator().next() instanceof Comparable) {
            return new KeyOrderedMultiMap(result);
        }
        return result;
    }

    @Contract(pure=true)
    public static <T> T getOrElse(@NotNull List<? extends T> elements, int i, T defaultValue) {
        return elements.size() > i ? elements.get(i) : defaultValue;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> intersection(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map2.size() < map1.size()) {
            Map<K, V> t = map1;
            map1 = map2;
            map2 = t;
        }
        HashMap<K, V> res = new HashMap<K, V>(map1);
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            K key = entry.getKey();
            V v2 = entry.getValue();
            V v1 = map1.get(key);
            if (Objects.equals(v1, v2)) continue;
            res.remove(key);
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, Couple<V>> diff(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        Set<K> keys = ContainerUtil.union(map1.keySet(), map2.keySet());
        HashMap<K, Couple<V>> res = new HashMap<K, Couple<V>>();
        for (K k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (Objects.equals(v1, v2 = map2.get(k))) continue;
            res.put(k, Couple.of(v1, v2));
        }
        return res;
    }

    public static <T> void processSortedListsInOrder(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems, @NotNull Consumer<? super T> processor) {
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            T e;
            if (index1 >= list1.size()) {
                e = list2.get(index2++);
            } else if (index2 >= list2.size()) {
                e = list1.get(index1++);
            } else {
                T element2;
                T element1 = list1.get(index1);
                int c = comparator.compare(element1, element2 = list2.get(index2));
                if (c == 0) {
                    ++index1;
                    ++index2;
                    if (mergeEqualItems) {
                        e = element1;
                    } else {
                        processor.consume(element1);
                        e = element2;
                    }
                } else if (c < 0) {
                    e = element1;
                    ++index1;
                } else {
                    e = element2;
                    ++index2;
                }
            }
            processor.consume(e);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> mergeSortedLists(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems) {
        ArrayList result = new ArrayList(list1.size() + list2.size());
        ContainerUtil.processSortedListsInOrder(list1, list2, comparator, mergeEqualItems, result::add);
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> subList(@NotNull List<T> list, int from) {
        return list.subList(from, list.size());
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> appendix) {
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> iterator) {
        while (iterator.hasNext()) {
            T o = iterator.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> elements) {
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> elements) {
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<? extends T> iterator) {
        if (!iterator.hasNext()) {
            return ContainerUtil.emptyList();
        }
        ArrayList list = new ArrayList();
        ContainerUtil.addAll(list, iterator);
        return list;
    }

    @NotNull
    public static <T> Set<T> collectSet(@NotNull Iterator<? extends T> iterator) {
        if (!iterator.hasNext()) {
            return Collections.emptySet();
        }
        HashSet hashSet = new HashSet();
        ContainerUtil.addAll(hashSet, iterator);
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newMapFromKeys(@NotNull Iterator<? extends K> keys, @NotNull Convertor<? super K, ? extends V> valueConvertor) {
        HashMap<K, V> map = new HashMap<K, V>();
        while (keys.hasNext()) {
            K key = keys.next();
            map.put(key, valueConvertor.convert(key));
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newMapFromValues(@NotNull Iterator<? extends V> values, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        HashMap map = new HashMap();
        ContainerUtil.fillMapWithValues(map, values, keyConvertor);
        return map;
    }

    public static <K, V> void fillMapWithValues(@NotNull Map<? super K, ? super V> map, @NotNull Iterator<? extends V> values, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        while (values.hasNext()) {
            V value = values.next();
            map.put(keyConvertor.convert(value), value);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, Set<V>> classify(@NotNull Iterator<? extends V> iterator, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        LinkedHashMap<K, LinkedHashSet<V>> hashMap = new LinkedHashMap<K, LinkedHashSet<V>>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            K key = keyConvertor.convert(value);
            LinkedHashSet<V> set = (LinkedHashSet<V>)hashMap.get(key);
            if (set == null) {
                set = new LinkedHashSet<V>();
                hashMap.put(key, set);
            }
            set.add(value);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> emptyIterator() {
        return EmptyIterator.getInstance();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> emptyIterable() {
        return EmptyIterable.getInstance();
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<? super T> processor) {
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list, @NotNull Processor<? super T> processor) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull T[] iterable, @NotNull Processor<? super T> processor) {
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull Iterator<? extends T> iterator, @NotNull Processor<? super T> processor) {
        while (iterator.hasNext()) {
            if (processor.process(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterable<? extends V> iterable, @NotNull Condition<? super T> condition) {
        return ContainerUtilRt.find(iterable, condition);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull T equalTo) {
        return (T)ContainerUtil.find(iterable, object -> equalTo == object || equalTo.equals(object));
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull Iterator<? extends T> iterator, @NotNull T equalTo) {
        return ContainerUtil.find(iterator, (? super T object) -> equalTo == object || equalTo.equals(object));
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<? extends V> iterator, @NotNull Condition<? super T> condition) {
        return ContainerUtilRt.find(iterator, condition);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V findLast(@NotNull List<? extends V> list, @NotNull Condition<? super T> condition) {
        int index = ContainerUtil.lastIndexOf(list, condition);
        if (index < 0) {
            return null;
        }
        return list.get(index);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2Map(@NotNull T[] collection, @NotNull Function<? super T, ? extends Pair<K, V>> mapper) {
        return ContainerUtil.map2Map(Arrays.asList(collection), mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2Map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends Pair<K, V>> mapper) {
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<K, V> pair = mapper.fun(t);
            set.put(pair.first, pair.second);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2MapNotNull(@NotNull T[] collection, @NotNull Function<? super T, ? extends Pair<K, V>> mapper) {
        return ContainerUtil.map2MapNotNull(Arrays.asList(collection), mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2MapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends Pair<K, V>> mapper) {
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<K, V> pair = mapper.fun(t);
            if (pair == null) continue;
            set.put(pair.first, pair.second);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> map2Map(@NotNull Collection<? extends Pair<K, V>> collection) {
        THashMap result = new THashMap(collection.size());
        for (Pair<K, V> pair : collection) {
            result.put(pair.first, pair.second);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Object[] map2Array(@NotNull T[] array, @NotNull Function<? super T, Object> mapper) {
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Object[] map2Array(@NotNull Collection<? extends T> array, @NotNull Function<? super T, Object> mapper) {
        return ContainerUtil.map2Array(array, Object.class, mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<? super V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        Object[] result = (Object[])Array.newInstance(aClass, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = mapper.fun(array[i]);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<? super V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        Object[] result = (Object[])Array.newInstance(aClass, collection.size());
        int i = 0;
        for (T t : collection) {
            result[i++] = mapper.fun(t);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull V[] to, @NotNull Function<? super T, V> mapper) {
        return ContainerUtil.map2List(collection, mapper).toArray(to);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        return ContainerUtil.findAll(collection, condition);
    }

    @NotNull
    @Contract(pure=true)
    public static int[] filter(@NotNull int[] collection, @NotNull TIntProcedure condition) {
        TIntArrayList result = new TIntArrayList();
        for (int t : collection) {
            if (!condition.execute(t)) continue;
            result.add(t);
        }
        return result.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : result.toNativeArray();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filterIsInstance(@NotNull Collection<?> collection, @NotNull Class<? super T> aClass) {
        return ContainerUtil.filter(collection, Conditions.instanceOf(aClass));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        return ContainerUtil.findAll(collection, condition);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> filter(@NotNull Map<? extends K, ? extends V> map, @NotNull Condition<? super K> keyFilter) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!keyFilter.value(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        return ContainerUtil.findAll(collection, Condition.NOT_NULL);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> findAll(@NotNull T[] collection, @NotNull Class<V> instanceOf) {
        return ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] findAllAsArray(@NotNull T[] collection, @NotNull Class<V> instanceOf) {
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        Object[] array = (Object[])Array.newInstance(instanceOf, list.size());
        return list.toArray(array);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] findAllAsArray(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        Object[] array = (Object[])Array.newInstance(instanceOf, list.size());
        return list.toArray(array);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] findAllAsArray(@NotNull T[] collection, @NotNull Condition<? super T> instanceOf) {
        List<Object> list = ContainerUtil.findAll(collection, instanceOf);
        if (list.size() == collection.length) {
            return collection;
        }
        Object[] array = (Object[])Array.newInstance(collection.getClass().getComponentType(), list.size());
        return list.toArray(array);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> findAll(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            T v = t;
            result.add(v);
        }
        return result;
    }

    public static <T> boolean all(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        for (T t : collection) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> void removeDuplicates(@NotNull Collection<T> collection) {
        HashSet<T> collected = new HashSet<T>();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!collected.contains(t)) {
                collected.add(t);
                continue;
            }
            iterator.remove();
        }
    }

    @NotNull
    @Contract(pure=true)
    public static Map<String, String> stringMap(String ... keyValues) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            result.put(keyValues[i], keyValues[i + 1]);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> iterate(@NotNull T[] array) {
        return array.length == 0 ? EmptyIterator.getInstance() : Arrays.asList(array).iterator();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> iterate(final @NotNull Enumeration<? extends T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(@NotNull T[] arrays, @NotNull Condition<? super T> condition) {
        return ContainerUtil.iterate(Arrays.asList(arrays), condition);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection.isEmpty()) {
            return ContainerUtil.emptyIterable();
        }
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<? extends T> impl;
                    private T next;
                    {
                        this.impl = collection.iterator();
                        this.next = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result = this.next;
                        this.next = this.findNext();
                        return result;
                    }

                    @Nullable
                    private T findNext() {
                        while (this.impl.hasNext()) {
                            Object each = this.impl.next();
                            if (!condition.value(each)) continue;
                            return each;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterateBackward(final @NotNull List<? extends T> list) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final ListIterator<? extends T> it;
                    {
                        this.it = list.listIterator(list.size());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return this.it.previous();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T, E> Iterable<Pair<T, E>> zip(final @NotNull Iterable<? extends T> iterable1, final @NotNull Iterable<? extends E> iterable2) {
        return new Iterable<Pair<T, E>>(){

            @Override
            @NotNull
            public Iterator<Pair<T, E>> iterator() {
                return new Iterator<Pair<T, E>>(){
                    private final Iterator<? extends T> i1;
                    private final Iterator<? extends E> i2;
                    {
                        this.i1 = iterable1.iterator();
                        this.i2 = iterable2.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i1.hasNext() && this.i2.hasNext();
                    }

                    @Override
                    public Pair<T, E> next() {
                        return Pair.create(this.i1.next(), this.i2.next());
                    }

                    @Override
                    public void remove() {
                        this.i1.remove();
                        this.i2.remove();
                    }
                };
            }
        };
    }

    public static <E> void swapElements(@NotNull List<E> list, int index1, int index2) {
        E e1 = list.get(index1);
        E e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<?> iterator, @NotNull FilteringIterator.InstanceOf<T> instanceOf) {
        List list = ContainerUtil.collect(FilteringIterator.create(iterator, instanceOf));
        return list;
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Enumeration<? extends T> enumeration) {
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        for (A element : elements) {
            collection.add(element);
        }
        return collection;
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, A ... elements) {
        for (A element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        return collection;
    }

    public static <T> boolean removeAll(@NotNull Collection<T> collection, T ... elements) {
        boolean modified = false;
        for (T element : elements) {
            modified |= collection.remove(element);
        }
        return modified;
    }

    public static <T> boolean retainAll(@NotNull Collection<T> collection, @NotNull Condition<? super T> condition) {
        boolean modified = false;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (condition.value(next)) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<? extends T> iterable, @NotNull Class<? extends U> aClass) {
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<? extends T> iterator, @NotNull Class<? extends U> aClass) {
        return (U)ContainerUtil.find(iterator, FilteringIterator.instanceOf(aClass));
    }

    @Nullable
    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull T[] array, @NotNull Class<? extends U> aClass) {
        return ContainerUtil.findInstance(Arrays.asList(array), aClass);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull V[] array, @NotNull Function<? super V, ? extends Collection<? extends T>> fun) {
        return ContainerUtil.concat(Arrays.asList(array), fun);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(@NotNull Iterable<? extends Collection<? extends T>> list) {
        int totalSize = 0;
        for (Collection<T> ts : list) {
            totalSize += ts.size();
        }
        ArrayList result = new ArrayList(totalSize);
        for (Collection<T> collection : list) {
            result.addAll(collection);
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> append(@NotNull List<? extends T> list, T ... values) {
        return ContainerUtil.concat(list, ContainerUtil.list(values));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> prepend(@NotNull List<? extends T> list, T ... values) {
        return ContainerUtil.concat(ContainerUtil.list(values), list);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1.isEmpty() && list2.isEmpty()) {
            return Collections.emptyList();
        }
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < size1) {
                    return list1.get(index);
                }
                return list2.get(index - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        if (iterables.length == 0) {
            return ContainerUtil.emptyIterable();
        }
        if (iterables.length == 1) {
            return iterables[0];
        }
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i = 0; i < iterables.length; ++i) {
                    Iterable iterable = iterables[i];
                    iterators[i] = iterable.iterator();
                }
                return ContainerUtil.concatIterators(iterators);
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> concatIterators(Iterator<T> ... iterators) {
        return new SequenceIterator<T>(iterators);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> concatIterators(@NotNull Collection<? extends Iterator<? extends T>> iterators) {
        return new SequenceIterator(iterators);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(final T[] ... iterables) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i = 0; i < iterables.length; ++i) {
                    Object[] iterable = iterables[i];
                    iterators[i] = ContainerUtil.iterate(iterable);
                }
                Iterator i = ContainerUtil.concatIterators(iterators);
                return i;
            }
        };
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final List<? extends T> ... lists) {
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        if (size == 0) {
            return ContainerUtil.emptyList();
        }
        final int finalSize = size;
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= 0 && index < finalSize) {
                    int from = 0;
                    for (List each : lists) {
                        if (from <= index && index < from + each.size()) {
                            return each.get(index - from);
                        }
                        from += each.size();
                    }
                    if (from != finalSize) {
                        throw new ConcurrentModificationException("The list has changed. Its size was " + finalSize + "; now it's " + from);
                    }
                }
                throw new IndexOutOfBoundsException("index: " + index + "; size: " + this.size());
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(@NotNull List<List<? extends T>> lists) {
        List[] array = lists.toArray(new List[0]);
        return ContainerUtil.concat(array);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull Iterable<? extends V> list, @NotNull Function<? super V, ? extends Collection<? extends T>> listGenerator) {
        ArrayList<T> result = new ArrayList<T>();
        for (V v : list) {
            result.addAll(listGenerator.fun(v));
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result.add(t);
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    @NotNull
    @Contract(pure=true)
    public static <E extends Enum<E>> EnumSet<E> intersection(@NotNull EnumSet<E> collection1, @NotNull EnumSet<E> collection2) {
        EnumSet<E> result = EnumSet.copyOf(collection1);
        result.retainAll(collection2);
        return result;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable List<? extends T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getOnlyItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.size() != 1 ? defaultResult : items.iterator().next();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> getFirstItems(@NotNull List<T> items, int maxItems) {
        if (maxItems < 0) {
            throw new IllegalArgumentException("Expected non-negative maxItems; got: " + maxItems);
        }
        return maxItems >= items.size() ? items : items.subList(0, maxItems);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T iterateAndGetLastItem(@NotNull Iterable<? extends T> items) {
        Iterator<T> itr = items.iterator();
        T res = null;
        while (itr.hasNext()) {
            res = itr.next();
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<? extends T> iterator, final @NotNull Function<? super T, ? extends U> mapper) {
        return new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> filterIterator(final @NotNull Iterator<? extends T> iterator, final @NotNull Condition<? super T> filter) {
        return new Iterator<T>(){
            T next;
            boolean hasNext;
            {
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private void findNext() {
                this.hasNext = false;
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    if (!filter.value(t)) continue;
                    this.next = t;
                    this.hasNext = true;
                    break;
                }
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.findNext();
                return result;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list, @Nullable T def) {
        return ContainerUtilRt.getLastItem(list, def);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list) {
        return ContainerUtilRt.getLastItem(list);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> subtract(@NotNull Collection<? extends T> from, @NotNull Collection<? extends T> what) {
        HashSet<T> set = ContainerUtilRt.newHashSet(from);
        set.removeAll(what);
        return set.isEmpty() ? ContainerUtil.emptyList() : set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull ArrayFactory<? extends T> factory) {
        T[] a = factory.create(c.size());
        return c.toArray(a);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        return ArrayUtil.mergeCollections(c1, c2, factory);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeCollectionsToArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        return ArrayUtil.mergeCollections(c1, c2, factory);
    }

    public static <T extends Comparable<T>> void sort(@NotNull List<T> list) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list.get(0);
            if (t0.compareTo(t1 = (Comparable)list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    Comparable tj;
                    Comparable ti = (Comparable)list.get(i);
                    if (ti.compareTo(tj = (Comparable)list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list);
        }
    }

    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        int size = list.size();
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list.get(i);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            list.sort(comparator);
        }
    }

    public static <T extends Comparable<T>> void sort(@NotNull T[] a) {
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (t0.compareTo(t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (ti.compareTo(tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> sorted(@NotNull Collection<? extends T> list, @NotNull Comparator<? super T> comparator) {
        return ContainerUtil.sorted(list, comparator);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> sorted(@NotNull Iterable<? extends T> list, @NotNull Comparator<? super T> comparator) {
        ArrayList<? extends T> sorted = ContainerUtil.newArrayList(list);
        ContainerUtil.sort(sorted, comparator);
        return sorted;
    }

    @NotNull
    @Contract(pure=true)
    public static <T extends Comparable<? super T>> List<T> sorted(@NotNull Collection<? extends T> list) {
        return ContainerUtil.sorted(list, Comparator.naturalOrder());
    }

    public static <T> void sort(@NotNull T[] a, @NotNull Comparator<? super T> comparator) {
        int size = a.length;
        if (size < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (comparator.compare(t0, t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a, comparator);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping) {
        ArrayList<T> result = new ArrayList<T>(iterable instanceof Collection ? ((Collection)iterable).size() : 10);
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        return ContainerUtilRt.map2List(collection, mapping);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapping) {
        return ContainerUtil.mapNotNull(Arrays.asList(array), mapping);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] mapNotNull(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapping, @NotNull V[] emptyArray) {
        ArrayList<V> result = new ArrayList<V>(array.length);
        for (T t : array) {
            V v = mapping.fun(t);
            if (v == null) continue;
            result.add(v);
        }
        if (result.isEmpty()) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            return emptyArray;
        }
        return result.toArray(emptyArray);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        return ContainerUtilRt.mapNotNull(collection, mapping);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> packNullables(T ... elements) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : elements) {
            ContainerUtil.addIfNotNull(list, element);
        }
        return list.isEmpty() ? ContainerUtil.emptyList() : list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapping) {
        ArrayList<T> result = new ArrayList<T>(array.length);
        for (T t : array) {
            result.add(mapping.fun(t));
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map(@NotNull T[] arr, @NotNull Function<? super T, ? extends V> mapping, @NotNull V[] emptyArray) {
        if (arr.length == 0) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            return emptyArray;
        }
        V[] result = emptyArray.length < arr.length ? Arrays.copyOf(emptyArray, arr.length) : emptyArray;
        for (int i = 0; i < arr.length; ++i) {
            result[i] = mapping.fun(arr[i]);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> set(T ... items) {
        return ContainerUtilRt.newHashSet(items);
    }

    public static <K, V> void putIfAbsent(K key, @Nullable V value, @NotNull Map<? super K, ? super V> result) {
        if (!result.containsKey(key)) {
            result.put(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull Map<? super K, ? super V> result) {
        if (value != null) {
            result.put(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable Collection<? extends V> value, @NotNull MultiMap<? super K, ? super V> result) {
        if (value != null) {
            result.putValues(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull MultiMap<? super K, ? super V> result) {
        if (value != null) {
            result.putValue(key, value);
        }
    }

    public static <T> void add(final T element, final @NotNull Collection<? super T> result, @NotNull Disposable parentDisposable) {
        if (result.add(element)) {
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    result.remove(element);
                }
            });
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        return element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> createMaybeSingletonSet(@Nullable T element) {
        return element == null ? Collections.emptySet() : Collections.singleton(element);
    }

    @NotNull
    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull V defaultValue) {
        V value = result.get(key);
        if (value == null) {
            value = defaultValue;
            result.put(key, value);
        }
        return value;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull Factory<? extends V> factory) {
        V value = result.get(key);
        if (value == null) {
            value = factory.create();
            result.put(key, value);
        }
        return value;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V getOrElse(@NotNull Map<T, V> result, T key, @NotNull V defValue) {
        V value = result.get(key);
        return value == null ? defValue : value;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        for (T t : array) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        return ContainerUtil.or(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        return ContainerUtil.exists(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int count(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        int count = 0;
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> unfold(@Nullable T t, @NotNull NullableFunction<? super T, ? extends T> next) {
        if (t == null) {
            return ContainerUtil.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        while (t != null) {
            list.add(t);
            t = next.fun(t);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> dropTail(@NotNull List<T> items) {
        return items.subList(0, items.size() - 1);
    }

    @SafeVarargs
    @NotNull
    @Contract(pure=true)
    public static <T> List<T> list(T ... items) {
        return Arrays.asList(items);
    }

    public static <T> void quickSort(@NotNull List<? extends T> list, @NotNull Comparator<? super T> comparator) {
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<? extends T> x, Comparator<? super T> comparator, int a, int b, int c) {
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> singleton(T o, @NotNull TObjectHashingStrategy<T> strategy) {
        return strategy == TObjectHashingStrategy.CANONICAL ? new SingletonSet<T>(o) : SingletonSet.withCustomStrategy(o, strategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Collection<E>[] collections) {
        return ContainerUtil.flatten(Arrays.asList(collections));
    }

    @NotNull
    public static <T> List<T> removeDuplicatesFromSorted(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        Object prev = null;
        ArrayList<T> result = null;
        for (int i = 0; i < list.size(); ++i) {
            int cmp;
            T t = list.get(i);
            if (t == null) {
                throw new IllegalArgumentException("get(" + i + ") = null");
            }
            int n = cmp = prev == null ? -1 : comparator.compare(prev, t);
            if (cmp < 0) {
                if (result != null) {
                    result.add(t);
                }
            } else if (cmp == 0) {
                if (result == null) {
                    result = new ArrayList<T>(list.size());
                    result.addAll(list.subList(0, i));
                }
            } else {
                throw new IllegalArgumentException("List must be sorted but get(" + (i - 1) + ")=" + list.get(i - 1) + " > get(" + i + ")=" + t);
            }
            prev = t;
        }
        return result == null ? list : result;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<? extends E>> collections) {
        int totalSize = 0;
        for (Collection<E> list : collections) {
            totalSize += list.size();
        }
        ArrayList result = new ArrayList(totalSize);
        for (Collection<E> collection : collections) {
            result.addAll(collection);
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flattenIterables(@NotNull Iterable<? extends Iterable<E>> collections) {
        int totalSize = 0;
        for (Iterable<E> list : collections) {
            totalSize += list instanceof Collection ? ((Collection)list).size() : 10;
        }
        ArrayList result = new ArrayList(totalSize);
        for (Iterable<E> list : collections) {
            for (E e : list) {
                result.add(e);
            }
        }
        return result.isEmpty() ? ContainerUtil.emptyList() : result;
    }

    @NotNull
    public static <K, V> V[] convert(@NotNull K[] from, @NotNull V[] to, @NotNull Function<? super K, ? extends V> fun) {
        if (to.length < from.length) {
            Object[] array = (Object[])Array.newInstance(to.getClass().getComponentType(), from.length);
            to = array;
        }
        for (int i = 0; i < from.length; ++i) {
            to[i] = fun.fun(from[i]);
        }
        return to;
    }

    @Contract(pure=true)
    public static <T> boolean containsIdentity(@NotNull Iterable<? extends T> list, T element) {
        for (T t : list) {
            if (t != element) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int indexOfIdentity(@NotNull List<? extends T> list, T element) {
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> boolean equalsIdentity(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2) {
        int listSize = list1.size();
        if (list2.size() != listSize) {
            return false;
        }
        for (int i = 0; i < listSize; ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        return ContainerUtilRt.indexOf(list, condition);
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        for (int i = list.size() - 1; i >= 0; --i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, U extends T> U findLastInstance(@NotNull List<? extends T> list, @NotNull Class<? extends U> clazz) {
        int i = ContainerUtil.lastIndexOf(list, clazz::isInstance);
        return i < 0 ? null : (U)list.get(i);
    }

    @Contract(pure=true)
    public static <T, U extends T> int lastIndexOfInstance(@NotNull List<? extends T> list, @NotNull Class<U> clazz) {
        return ContainerUtil.lastIndexOf(list, clazz::isInstance);
    }

    @NotNull
    @Contract(pure=true)
    public static <A, B> Map<B, A> reverseMap(@NotNull Map<A, B> map) {
        HashMap<B, A> result = new HashMap<B, A>();
        for (Map.Entry<A, B> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    @Contract(value="null -> null; !null -> !null")
    public static <T> List<T> trimToSize(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> Stack<T> newStack() {
        return ContainerUtilRt.newStack();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> Stack<T> newStack(@NotNull Collection<? extends T> initial) {
        return ContainerUtilRt.newStack(initial);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> Stack<T> newStack(T ... initial) {
        return ContainerUtilRt.newStack(initial);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        return ContainerUtilRt.emptyList();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        return new CopyOnWriteArrayList(ContainerUtilRt.emptyList());
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        return ContainerUtil.createConcurrentList();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList(@NotNull Collection<? extends T> c) {
        return new LockFreeCopyOnWriteArrayList<T>(c);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        return new ConcurrentIntObjectHashMap();
    }

    @NotNull
    @Contract(value="_,_,_ -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentIntObjectHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectSoftValueMap() {
        return new ConcurrentIntKeySoftValueHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        return new ConcurrentLongObjectHashMap();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap(int initialCapacity) {
        return new ConcurrentLongObjectHashMap(initialCapacity);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        return new ConcurrentWeakValueHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        return new ConcurrentIntKeyWeakValueHashMap();
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        return ContainerUtil.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        return ContainerUtil.createConcurrentWeakKeyWeakValueMap(ContainerUtil.canonicalStrategy());
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull TObjectHashingStrategy<? super K> strategy) {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap();
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        return new ConcurrentSoftHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        return new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(@NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        return new ConcurrentWeakHashMap(hashingStrategy);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> ConcurrentList<T> createConcurrentList() {
        return new LockFreeCopyOnWriteArrayList();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ConcurrentList<T> createConcurrentList(@NotNull Collection<? extends T> collection) {
        return new LockFreeCopyOnWriteArrayList<T>(collection);
    }

    @Deprecated
    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<? super T> result) {
        ContainerUtil.addIfNotNull(result, element);
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result, @Nullable T element) {
        ContainerUtilRt.addIfNotNull(result, element);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapper) {
        return ContainerUtilRt.map2List(array, mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        return ContainerUtilRt.map2List(collection, mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> List<Pair<K, V>> map2List(@NotNull Map<? extends K, ? extends V> map) {
        return ContainerUtilRt.map2List(map);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<? super T, ? extends V> mapper) {
        return ContainerUtilRt.map2Set(collection, mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        return ContainerUtilRt.map2Set(collection, mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2LinkedSet(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2SetNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet set = new HashSet(collection.size());
        for (T t : collection) {
            V value = mapper.fun(t);
            if (value == null) continue;
            set.add(value);
        }
        return set.isEmpty() ? Collections.emptySet() : set;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        return collection.toArray(array);
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<? extends T> c, @NotNull T[] sample) {
        return c.toArray(sample);
    }

    @NotNull
    public static <T> T[] copyAndClear(@NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory, boolean clear) {
        int size = collection.size();
        T[] a = factory.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        return a;
    }

    @Contract(value="null -> null")
    public static <T> List<T> copyList(@Nullable List<? extends T> list) {
        if (list == null) {
            return null;
        }
        if (list == Collections.emptyList()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return new SmartList<T>(list.get(0));
        }
        if (list.isEmpty()) {
            return new SmartList();
        }
        return new ArrayList<T>(list);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> toCollection(@NotNull Iterable<? extends T> iterable) {
        return iterable instanceof Collection ? (ArrayList<? extends T>)iterable : ContainerUtil.newArrayList(iterable);
    }

    @NotNull
    public static <T> List<T> toList(@NotNull Enumeration<? extends T> enumeration) {
        if (!enumeration.hasMoreElements()) {
            return Collections.emptyList();
        }
        SmartList<T> result = new SmartList<T>();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        return result;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return ContainerUtilRt.isEmpty(collection);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable Map map) {
        return map == null || map.isEmpty();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> notNullize(@Nullable List<T> list) {
        return list == null ? ContainerUtilRt.emptyList() : list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> notNullize(@Nullable Set<T> set) {
        return set == null ? Collections.emptySet() : set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> notNullize(@Nullable Map<K, V> map) {
        return map == null ? Collections.emptyMap() : map;
    }

    @Contract(pure=true)
    public static <T> boolean startsWith(@NotNull List<? extends T> list, @NotNull List<? extends T> prefix) {
        return list.size() >= prefix.size() && list.subList(0, prefix.size()).equals(prefix);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, C extends Collection<T>> C nullize(@Nullable C collection) {
        return ContainerUtil.isEmpty(collection) ? null : (C)collection;
    }

    @Contract(pure=true)
    public static <T extends Comparable<T>> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2) {
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result = Comparing.compare((Comparable)o1.get(i), (Comparable)o2.get(i));
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    @Contract(pure=true)
    public static <T> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2, @NotNull Comparator<? super T> comparator) {
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result = comparator.compare(o1.get(i), o2.get(i));
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(o1.size(), o2.size());
    }

    @NotNull
    @Contract(pure=true)
    public static String toString(@NotNull Map<?, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakKeySoftValueMap() {
        return new WeakKeySoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakKeyWeakValueMap() {
        return new WeakKeyWeakValueHashMap(true);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftKeySoftValueMap() {
        return new SoftKeySoftValueHashMap(true);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftValueMap() {
        return new SoftValueHashMap(ContainerUtil.canonicalStrategy());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakValueMap() {
        return new WeakValueHashMap(ContainerUtil.canonicalStrategy());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftMap() {
        return new SoftHashMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftMap(@NotNull TObjectHashingStrategy<? super K> strategy) {
        return new SoftHashMap(strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        return ContainerUtil.createWeakMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity) {
        return ContainerUtil.createWeakMap(initialCapacity, 0.8f, ContainerUtil.canonicalStrategy());
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<? super K> strategy) {
        return new WeakHashMap(initialCapacity, loadFactor, strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> Set<T> createWeakSet() {
        return new WeakHashSet();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> IntObjectMap<T> createIntKeyWeakValueMap() {
        return new IntKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> ObjectIntMap<T> createWeakKeyIntValueMap() {
        return new WeakKeyIntValueHashMap();
    }

    public static class KeyOrderedMultiMap<K extends Comparable<K>, V>
    extends MultiMap<K, V> {
        public KeyOrderedMultiMap() {
        }

        public KeyOrderedMultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
            super(toCopy);
        }

        @Override
        @NotNull
        protected Map<K, Collection<V>> createMap() {
            return new TreeMap();
        }

        @Override
        @NotNull
        protected Map<K, Collection<V>> createMap(int initialCapacity, float loadFactor) {
            return new TreeMap();
        }

        @NotNull
        public NavigableSet<K> navigableKeySet() {
            return ((TreeMap)this.myMap).navigableKeySet();
        }
    }

    private static class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(@NotNull E[] array) {
            this.myStore = array;
        }

        @Override
        public E get(int index) {
            return this.myStore[index];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            int size = this.size();
            T[] result = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            System.arraycopy(this.myStore, 0, result, 0, size);
            if (result.length > size) {
                result[size] = null;
            }
            return result;
        }
    }

    private static class ImmutableListBackedByList<E>
    extends ImmutableList<E> {
        private final List<? extends E> myStore;

        private ImmutableListBackedByList(@NotNull List<? extends E> list) {
            this.myStore = list;
        }

        @Override
        public E get(int index) {
            return this.myStore.get(index);
        }

        @Override
        public int size() {
            return this.myStore.size();
        }
    }

    public static class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new THashMap();

        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.myMap.put(key, value);
            return this;
        }

        @Contract(pure=true)
        public Map<K, V> build() {
            return Collections.unmodifiableMap(this.myMap);
        }
    }
}

