/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.EmptyListIterator;
import com.intellij.util.containers.Stack;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerUtilRt {
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    @NotNull
    @Contract(value="_,_ -> new", pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull List<? extends K> keys, @NotNull List<? extends V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException(keys + " should have same length as " + values);
        }
        HashMap<K, V> map = new HashMap<K, V>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    @NotNull
    @Contract(value="_,_ -> new", pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        HashMap<K, V> map = new HashMap<K, V>(entries.length + 1);
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        return map;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K extends Comparable<? super K>, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K extends Comparable<? super K>, V> TreeMap<K, V> newTreeMap(@NotNull Map<? extends K, ? extends V> map) {
        return new TreeMap<K, V>(map);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        return new LinkedHashMap(capacity);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Map<? extends K, ? extends V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    @NotNull
    @Contract(value="_,_ -> new", pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        LinkedHashMap<K, V> map = ContainerUtilRt.newLinkedHashMap();
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> pair : entries) {
            map.put(pair.getFirst(), pair.getSecond());
        }
        return map;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        LinkedList<T> list = ContainerUtilRt.newLinkedList();
        Collections.addAll(list, elements);
        return list;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Iterable<? extends T> elements) {
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedList(), elements);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayList(@NotNull Iterable<? extends T> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new ArrayList(collection);
        }
        return ContainerUtilRt.copy(new ArrayList(), elements);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        return new ArrayList(size);
    }

    @NotNull
    private static <T, C extends Collection<T>> C copy(@NotNull C collection, @NotNull Iterable<? extends T> elements) {
        for (T element : elements) {
            collection.add(element);
        }
        return collection;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> HashSet<T> newHashSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new HashSet(collection);
        }
        return ContainerUtilRt.newHashSet(elements.iterator());
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator) {
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        return ContainerUtilRt.newLinkedHashSet(Arrays.asList(elements));
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            return new LinkedHashSet(collection);
        }
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedHashSet(), elements);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T extends Comparable<? super T>> TreeSet<T> newTreeSet() {
        return new TreeSet();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T extends Comparable<? super T>> TreeSet<T> newTreeSet(@NotNull Iterable<? extends T> elements) {
        return ContainerUtilRt.copy(ContainerUtilRt.<T>newTreeSet(), elements);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<? super T> comparator) {
        return new TreeSet<T>(comparator);
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> Stack<T> newStack() {
        return new Stack();
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> Stack<T> newStack(@NotNull Collection<? extends T> elements) {
        return new Stack<T>(elements);
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> Stack<T> newStack(T ... initial) {
        return new Stack<T>(Arrays.asList(initial));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        return EmptyList.INSTANCE;
    }

    @Deprecated
    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<? super T> result) {
        if (element != null) {
            result.add(element);
        }
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result, @Nullable T element) {
        if (element != null) {
            result.add(element);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapper) {
        return ContainerUtilRt.map2List(Arrays.asList(array), mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        if (collection.isEmpty()) {
            return ContainerUtilRt.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(collection.size());
        for (T t : collection) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        return result.isEmpty() ? ContainerUtilRt.emptyList() : result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection.isEmpty()) {
            return ContainerUtilRt.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> List<Pair<K, V>> map2List(@NotNull Map<? extends K, ? extends V> map) {
        if (map.isEmpty()) {
            return ContainerUtilRt.emptyList();
        }
        ArrayList<Pair<K, V>> result = new ArrayList<Pair<K, V>>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.add(Pair.create(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<? super T, ? extends V> mapper) {
        return ContainerUtilRt.map2Set(Arrays.asList(collection), mapper);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<V> set = new HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        return set;
    }

    @Deprecated
    @NotNull
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        return collection.toArray(array);
    }

    @Deprecated
    @NotNull
    public static <T> T[] toArray(@NotNull Collection<? extends T> c, @NotNull T[] sample) {
        return c.toArray(sample);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list, @Nullable T def) {
        return ContainerUtilRt.isEmpty(list) ? def : list.get(list.size() - 1);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list) {
        return ContainerUtilRt.getLastItem(list, null);
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return collection == null || collection.isEmpty();
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterable<? extends V> iterable, @NotNull Condition<? super T> condition) {
        return ContainerUtilRt.find(iterable.iterator(), condition);
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<? extends V> iterator, @NotNull Condition<? super T> condition) {
        while (iterator.hasNext()) {
            V value = iterator.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <E> E[] toArray(@NotNull E[] a) {
            if (a.length != 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return EmptyIterator.getInstance();
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return EmptyListIterator.getInstance();
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        @Contract(pure=true)
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Contract(pure=true)
        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }
    }
}

