/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisposableWrapperList<E>
extends AbstractList<E> {
    @NotNull
    private final List<DisposableWrapper<E>> myWrappedList = ContainerUtil.createLockFreeCopyOnWriteList();

    @Override
    public boolean add(E element) {
        return this.myWrappedList.add(new DisposableWrapper<E>(element));
    }

    @Override
    public void add(int index, E element) {
        this.myWrappedList.add(index, new DisposableWrapper<E>(element));
    }

    @NotNull
    public Disposable add(E element, @NotNull Disposable parentDisposable) {
        DisposableWrapper<E> disposableWrapper = this.createDisposableWrapper(element, parentDisposable);
        this.myWrappedList.add(disposableWrapper);
        return disposableWrapper;
    }

    @NotNull
    public Disposable add(int index, E element, @NotNull Disposable parentDisposable) {
        DisposableWrapper<E> disposableWrapper = this.createDisposableWrapper(element, parentDisposable);
        this.myWrappedList.add(index, disposableWrapper);
        return disposableWrapper;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        Collection<DisposableWrapper<? extends E>> disposableWrappers = DisposableWrapperList.wrapAll(collection);
        return this.myWrappedList.addAll(disposableWrappers);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> collection) {
        Collection<DisposableWrapper<? extends E>> disposableWrappers = DisposableWrapperList.wrapAll(collection);
        return this.myWrappedList.addAll(index, disposableWrappers);
    }

    @Override
    public boolean remove(@Nullable Object obj) {
        ArrayList removedWrappers = new ArrayList(1);
        boolean result = this.myWrappedList.removeIf(disposableWrapper -> {
            if (((DisposableWrapper)disposableWrapper).delegate.equals(obj) && (removedWrappers.isEmpty() && disposableWrapper.makeUnique() || removedWrappers.contains(disposableWrapper))) {
                removedWrappers.add(disposableWrapper);
                return true;
            }
            return false;
        });
        for (DisposableWrapper disposableWrapper2 : removedWrappers) {
            disposableWrapper2.disposeWithoutRemoval();
        }
        return result;
    }

    @Override
    @Nullable
    public E remove(int index) {
        DisposableWrapper<E> removedWrapper = this.myWrappedList.remove(index);
        return this.unwrapAndDispose(removedWrapper);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> objects) {
        return this.removeIf(element -> objects.contains(element));
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super E> filter) {
        THashSet removedWrappers = ContainerUtil.newIdentityTroveSet(this.myWrappedList.size());
        boolean result = this.myWrappedList.removeIf(disposableWrapper -> {
            if (filter.test((Object)((DisposableWrapper)disposableWrapper).delegate) && (disposableWrapper.makeUnique() || removedWrappers.contains(disposableWrapper))) {
                removedWrappers.add(disposableWrapper);
                return true;
            }
            return false;
        });
        for (DisposableWrapper disposableWrapper2 : removedWrappers) {
            disposableWrapper2.disposeWithoutRemoval();
        }
        return result;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> objects) {
        return this.removeIf(element -> !objects.contains(element));
    }

    @Override
    public void clear() {
        this.removeIf(element -> true);
    }

    @Override
    public int size() {
        return this.myWrappedList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myWrappedList.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new DisposableWrapperListIterator(this.myWrappedList, 0);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] elements = this.myWrappedList.toArray();
        if (elements.length == 0) {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            elements[i] = ((DisposableWrapper)elements[i]).delegate;
        }
        return elements;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] array) {
        Object[] elements = this.myWrappedList.toArray();
        int len = elements.length;
        if (array.length < len) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), len);
        } else {
            Arrays.fill(array, len, array.length, null);
        }
        for (int i = 0; i < len; ++i) {
            array[i] = ((DisposableWrapper)elements[i]).delegate;
        }
        return array;
    }

    @Override
    public E get(int index) {
        return (E)((DisposableWrapper)this.myWrappedList.get(index)).delegate;
    }

    @Override
    public E set(int index, E element) {
        DisposableWrapper<E> replaced = this.myWrappedList.set(index, new DisposableWrapper<E>(element));
        return this.unwrapAndDispose(replaced);
    }

    @Override
    public boolean contains(@Nullable Object obj) {
        return obj != null && this.myWrappedList.contains(new DisposableWrapper<Object>(obj));
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        Collection<DisposableWrapper<?>> disposableWrappers = DisposableWrapperList.wrapAll(collection);
        return this.myWrappedList.containsAll(disposableWrappers);
    }

    @Override
    public int indexOf(@Nullable Object obj) {
        return obj == null ? -1 : this.myWrappedList.indexOf(new DisposableWrapper<Object>(obj));
    }

    @Override
    public int lastIndexOf(@Nullable Object obj) {
        return obj == null ? -1 : this.myWrappedList.lastIndexOf(new DisposableWrapper<Object>(obj));
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return new DisposableWrapperListIterator(this.myWrappedList, 0);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        return new DisposableWrapperListIterator(this.myWrappedList, index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private DisposableWrapper<E> createDisposableWrapper(E element, @NotNull Disposable parentDisposable) {
        DisposableWrapper<E> disposableWrapper = new DisposableWrapper<E>(element, this.myWrappedList);
        Disposer.register(parentDisposable, disposableWrapper);
        return disposableWrapper;
    }

    @NotNull
    private static <T> Collection<DisposableWrapper<T>> wrapAll(@NotNull Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DisposableWrapper<T>> result = new ArrayList<DisposableWrapper<T>>(collection.size());
        for (T obj : collection) {
            result.add(new DisposableWrapper<T>(obj));
        }
        return result;
    }

    @Nullable
    private E unwrapAndDispose(@Nullable DisposableWrapper<E> disposableWrapper) {
        if (disposableWrapper == null) {
            return null;
        }
        Object unwrapped = ((DisposableWrapper)disposableWrapper).delegate;
        disposableWrapper.disposeWithoutRemoval();
        return (E)unwrapped;
    }

    private static class DisposableWrapperListIterator<T>
    implements ListIterator<T> {
        @NotNull
        private final ListIterator<DisposableWrapper<T>> myDelegate;
        @Nullable
        private DisposableWrapper<T> myLastReturned;

        DisposableWrapperListIterator(@NotNull List<DisposableWrapper<T>> list, int initialCursor) {
            this.myDelegate = list.listIterator(initialCursor);
        }

        @Override
        public boolean hasNext() {
            return this.myDelegate.hasNext();
        }

        @Override
        public T next() {
            this.myLastReturned = this.myDelegate.next();
            return (T)((DisposableWrapper)this.myLastReturned).delegate;
        }

        @Override
        public boolean hasPrevious() {
            return this.myDelegate.hasPrevious();
        }

        @Override
        public T previous() {
            this.myLastReturned = this.myDelegate.previous();
            return (T)((DisposableWrapper)this.myLastReturned).delegate;
        }

        @Override
        public int nextIndex() {
            return this.myDelegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.myDelegate.previousIndex();
        }

        @Override
        public void remove() {
            if (this.myLastReturned == null) {
                throw new NoSuchElementException();
            }
            if (this.myLastReturned.makeUnique()) {
                this.myDelegate.remove();
                this.myLastReturned.disposeWithoutRemoval();
                this.myLastReturned = null;
            }
        }

        @Override
        public void set(T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T element) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.myDelegate.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            return this.myDelegate.equals(((DisposableWrapperListIterator)obj).myDelegate);
        }
    }

    private static class DisposableWrapper<T>
    implements Disposable {
        private static final AtomicFieldUpdater<DisposableWrapper, Integer> UNIQUENESS_UPDATER = AtomicFieldUpdater.forIntFieldIn(DisposableWrapper.class);
        @NotNull
        private final T delegate;
        @Nullable
        private Collection<DisposableWrapper<T>> myContainer;
        private volatile int myIsUnique;

        DisposableWrapper(@NotNull T obj) {
            this(obj, null);
        }

        DisposableWrapper(@NotNull T obj, @Nullable Collection<DisposableWrapper<T>> container) {
            this.delegate = obj;
            this.myContainer = container;
        }

        @Override
        public void dispose() {
            if (this.myContainer != null) {
                this.makeUnique();
                this.myContainer.remove(this);
            }
        }

        void disposeWithoutRemoval() {
            if (this.myContainer != null) {
                this.myContainer = null;
                Disposer.dispose(this);
            }
        }

        boolean makeUnique() {
            return UNIQUENESS_UPDATER.compareAndSetInt(this, 0, 1);
        }

        private boolean isUnique() {
            return this.myIsUnique != 0;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DisposableWrapper other = (DisposableWrapper)obj;
            return this.delegate.equals(other.delegate) && !this.isUnique() && !other.isUnique();
        }
    }
}

