/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.TreeTraversal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredTraverserBase<T, Self extends FilteredTraverserBase<T, Self>>
implements Iterable<T> {
    final Meta<T> myMeta;

    protected FilteredTraverserBase(@NotNull Meta<T> meta) {
        this.myMeta = meta;
    }

    @NotNull
    public Function<? super T, ? extends Iterable<? extends T>> getTree() {
        return this.myMeta.tree;
    }

    @NotNull
    public final T getRoot() {
        return this.myMeta.roots.iterator().next();
    }

    @NotNull
    public final Iterable<? extends T> getRoots() {
        return this.myMeta.roots;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.traverse().iterator();
    }

    @NotNull
    protected abstract Self newInstance(@NotNull Meta<T> var1);

    @NotNull
    public final JBIterable<T> traverse(@NotNull TreeTraversal traversal) {
        Function<Object, Iterable> adjusted = this::children;
        return this.myMeta.interceptor.fun(traversal).traversal(this.getRoots(), adjusted).filter(this.myMeta.filter.and());
    }

    @NotNull
    public final JBIterable<T> traverse() {
        return this.traverse(this.myMeta.traversal);
    }

    @NotNull
    public final JBIterable<T> biOrderDfsTraversal() {
        return this.traverse(TreeTraversal.BI_ORDER_DFS);
    }

    @NotNull
    public final JBIterable<T> preOrderDfsTraversal() {
        return this.traverse(TreeTraversal.PRE_ORDER_DFS);
    }

    @NotNull
    public final JBIterable<T> postOrderDfsTraversal() {
        return this.traverse(TreeTraversal.POST_ORDER_DFS);
    }

    @NotNull
    public final JBIterable<T> bfsTraversal() {
        return this.traverse(TreeTraversal.PLAIN_BFS);
    }

    @NotNull
    public final JBIterable<T> tracingBfsTraversal() {
        return this.traverse(TreeTraversal.TRACING_BFS);
    }

    @NotNull
    public final Self reset() {
        return this.newInstance(this.myMeta.reset());
    }

    @NotNull
    public final Self withRoot(@Nullable T root) {
        return this.newInstance(this.myMeta.withRoots(JBIterable.of(root)));
    }

    @NotNull
    public final Self withRoots(T ... roots) {
        return this.newInstance(this.myMeta.withRoots(JBIterable.of(roots)));
    }

    @NotNull
    public final Self withRoots(@Nullable Iterable<? extends T> roots) {
        return this.newInstance(this.myMeta.withRoots(roots != null ? roots : JBIterable.empty()));
    }

    @NotNull
    public final Self withTraversal(TreeTraversal type) {
        return this.newInstance(this.myMeta.withTraversal(type));
    }

    @NotNull
    public final Self expand(@NotNull Condition<? super T> c) {
        return this.newInstance(this.myMeta.expand(c));
    }

    @NotNull
    public final Self regard(@NotNull Condition<? super T> c) {
        return this.newInstance(this.myMeta.regard(c));
    }

    @NotNull
    public final Self expandAndFilter(Condition<? super T> c) {
        return this.newInstance(this.myMeta.expand(c).filter(c));
    }

    @NotNull
    public final Self expandAndSkip(Condition<? super T> c) {
        return this.newInstance(this.myMeta.expand(c).filter(Conditions.not(c)));
    }

    @NotNull
    public final Self filter(@NotNull Condition<? super T> c) {
        return this.newInstance(this.myMeta.filter(c));
    }

    @NotNull
    public final <C> JBIterable<C> filter(@NotNull Class<C> type) {
        return this.traverse().filter(type);
    }

    @NotNull
    public final Self unique() {
        return this.unique(Functions.identity());
    }

    @NotNull
    public final Self unique(@NotNull Function<? super T, Object> identity) {
        return this.interceptTraversal(traversal -> traversal.unique(identity));
    }

    @NotNull
    public Self onRange(@NotNull Condition<? super T> rangeCondition) {
        return this.interceptTraversal(traversal -> traversal.onRange(rangeCondition));
    }

    @NotNull
    public final Self forceIgnore(@NotNull Condition<? super T> c) {
        return this.newInstance(this.myMeta.forceIgnore(c));
    }

    @NotNull
    public final Self forceDisregard(@NotNull Condition<? super T> c) {
        return this.newInstance(this.myMeta.forceDisregard(c));
    }

    @NotNull
    public final Self interceptTraversal(@NotNull Function<? super TreeTraversal, ? extends TreeTraversal> transform) {
        return this.newInstance(this.myMeta.interceptTraversal(transform));
    }

    @NotNull
    protected <S, SelfS extends FilteredTraverserBase<S, ?>> SelfS mapImpl(@NotNull Function<? super T, ? extends S> function, @NotNull Function<? super S, ? extends T> reverse) {
        Function<Object, JBIterable> baseTree = this.myMeta::children;
        Condition filter = this.myMeta.filter.and();
        Meta<? extends S> meta = Meta.create(s -> ((JBIterable)baseTree.fun(reverse.fun((Object)s))).map(function)).withRoots(JBIterable.from(this.getRoots()).map(function)).filter(filter == Conditions.TRUE ? Conditions.alwaysTrue() : o -> filter.value(reverse.fun((Object)o)));
        return (SelfS)this.newInstance(meta);
    }

    @NotNull
    protected <S, SelfS extends FilteredTraverserBase<S, ?>> SelfS mapImpl(@NotNull Function<? super T, ? extends S> function) {
        Meta<Object> meta = new Meta<Object>(JBIterable.empty(), this.myMeta.traversal, Functions.constant(JBIterable.empty()), Cond.TRUE, Cond.TRUE, Cond.TRUE, Cond.FALSE, Cond.FALSE, Cond.FALSE, original -> new MappedTraversal((TreeTraversal)original, this.myMeta, JBIterable.Stateful.copy(function)), this.myMeta);
        return (SelfS)this.newInstance(meta);
    }

    @ApiStatus.Internal
    @NotNull
    public final JBIterable<T> children(@Nullable T node) {
        return this.myMeta.children(node);
    }

    @NotNull
    public final List<T> toList() {
        return this.traverse().toList();
    }

    @NotNull
    public final Set<T> toSet() {
        return this.traverse().toSet();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{traversal=" + this.myMeta.traversal + '}';
    }

    private static class MappedTree<T, S>
    implements Function<S, Iterable<? extends S>> {
        final Function<? super T, ? extends Iterable<? extends T>> tree;
        final Function<? super T, ? extends S> mapInner;
        final Meta<S> meta;
        Map<S, T> reverse;

        MappedTree(Function<? super T, ? extends Iterable<? extends T>> tree, Function<? super T, ? extends S> map, Meta<S> meta) {
            this.tree = tree;
            this.mapInner = map;
            this.meta = meta;
        }

        @Override
        public Iterable<? extends S> fun(S s) {
            return this.meta == null ? JBIterable.from(this.tree.fun(this.reverse(s))).map(this::map) : this.meta.childrenImpl(s, o -> JBIterable.from(this.tree.fun(this.reverse(o))).map(this::map));
        }

        S map(T t) {
            if (this.reverse == null) {
                this.reverse = ContainerUtil.createWeakMap();
            }
            S s = this.mapInner.fun(t);
            this.reverse.put(s, t);
            return s;
        }

        @NotNull
        T reverse(S s) {
            T t = this.reverse.get(s);
            if (t == null) {
                throw new IllegalStateException("unable to reverse map for: " + s);
            }
            return t;
        }
    }

    private static class MappedTraversal<T, S>
    extends TreeTraversal {
        final TreeTraversal original;
        final Meta<T> meta;
        final Function<? super T, ? extends S> map;

        MappedTraversal(@NotNull TreeTraversal original, @NotNull Meta<T> meta, @NotNull Function<? super T, ? extends S> map) {
            super(original + " (MAPPED by " + map + ")");
            this.original = original;
            this.meta = meta;
            this.map = map;
        }

        @NotNull
        public <SS> TreeTraversal.It<SS> createIterator(@NotNull Iterable<? extends SS> ignore1, @NotNull Function<? super SS, ? extends Iterable<? extends SS>> ignore2) {
            List<Meta> metas = ContainerUtil.reverse(JBIterable.generate(this.meta, o -> o.original).toList());
            Meta firstMeta = metas.get(0);
            Iterable roots = firstMeta.roots;
            Function<Object, Object> tree = firstMeta::children;
            Condition<Object> filter = firstMeta.filter.and();
            int count = metas.size();
            for (int i = 1; i <= count; ++i) {
                Meta meta = i < count ? metas.get(i) : null;
                MappedTraversal adjusted = meta == null ? this : meta.interceptor.fun(this.original);
                tree = new MappedTree<T, Object>(tree, adjusted.map, meta);
                roots = JBIterable.from(roots).map(((MappedTree)tree)::map);
                Function<Object, Object> tree0 = tree;
                Condition filter0 = filter;
                Condition<Object> prevFilter = filter == Condition.TRUE ? Condition.TRUE : o -> filter0.value(((MappedTree)tree0).reverse(o));
                filter = Conditions.and(prevFilter, meta == null ? Condition.TRUE : meta.filter.and());
            }
            MappedTree mappedTree = (MappedTree)tree;
            return (TreeTraversal.It)this.original.createIterator(JBIterable.from(roots), mappedTree).filter(filter);
        }
    }

    static class Cond<T> {
        static final Cond<Object> TRUE = new Cond<Object>(Conditions.TRUE, null);
        static final Cond<Object> FALSE = new Cond<Object>(Conditions.FALSE, null);
        final Condition<? super T> impl;
        final Cond<T> next;

        Cond(Condition<? super T> impl, Cond<T> next) {
            this.impl = impl;
            this.next = next;
        }

        Cond<T> append(Condition<? super T> impl) {
            return new Cond<T>(impl, this);
        }

        boolean valueAnd(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (!c.impl.value(t)) {
                    return false;
                }
                c = c.next;
            }
            return true;
        }

        boolean valueOr(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (c.impl.value(t)) {
                    return true;
                }
                c = c.next;
            }
            return false;
        }

        Condition<? super T> or() {
            Boolean result = false;
            Cond<T> c = this;
            while (c != null) {
                if (c.impl == Condition.TRUE) {
                    return Conditions.alwaysTrue();
                }
                result = result != null && c.impl != Condition.FALSE ? null : result;
                c = c.next;
            }
            return result == null ? this::valueOr : Conditions.alwaysFalse();
        }

        Condition<? super T> and() {
            Boolean result = true;
            Cond<T> c = this;
            while (c != null) {
                if (c.impl == Condition.FALSE) {
                    return Conditions.alwaysFalse();
                }
                result = result != null && c.impl != Condition.TRUE ? null : result;
                c = c.next;
            }
            return result == null ? this::valueAnd : Conditions.alwaysTrue();
        }

        public String toString() {
            if (this == TRUE) {
                return "Cond.TRUE";
            }
            if (this == FALSE) {
                return "Cond.FALSE";
            }
            StringBuilder sb = new StringBuilder("Cond{");
            Cond<T> c = this;
            while (c != null) {
                sb.append(JBIterator.toShortString(c.impl));
                if (c.next != null) {
                    sb.append(", ");
                }
                c = c.next;
            }
            return sb.append("}").toString();
        }
    }

    protected static class Meta<T> {
        final TreeTraversal traversal;
        final Iterable<? extends T> roots;
        final Function<? super T, ? extends Iterable<? extends T>> tree;
        final Cond<T> expand;
        final Cond<T> regard;
        final Cond<T> filter;
        final Cond<T> forceExpand;
        final Cond<T> forceIgnore;
        final Cond<T> forceDisregard;
        final Function<? super TreeTraversal, ? extends TreeTraversal> interceptor;
        final Meta<?> original;

        @NotNull
        public static <T> Meta<T> create(Function<? super T, ? extends Iterable<? extends T>> tree) {
            return new Meta<Object>(JBIterable.empty(), TreeTraversal.PRE_ORDER_DFS, tree, Cond.TRUE, Cond.TRUE, Cond.TRUE, Cond.FALSE, Cond.FALSE, Cond.FALSE, Functions.id(), null);
        }

        Meta(@NotNull Iterable<? extends T> roots, @NotNull TreeTraversal traversal, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree, @NotNull Cond<? super T> expand, @NotNull Cond<? super T> regard, @NotNull Cond<? super T> filter, @NotNull Cond<? super T> forceExpand, @NotNull Cond<? super T> forceIgnore, @NotNull Cond<? super T> forceDisregard, @NotNull Function<? super TreeTraversal, ? extends TreeTraversal> interceptor, @Nullable Meta<?> original) {
            this.roots = roots;
            this.traversal = traversal;
            this.tree = tree;
            this.expand = expand;
            this.regard = regard;
            this.filter = filter;
            this.forceExpand = forceExpand;
            this.forceIgnore = forceIgnore;
            this.forceDisregard = forceDisregard;
            this.interceptor = interceptor;
            this.original = original;
        }

        public Meta<T> reset() {
            return new Meta<Object>(this.roots, TreeTraversal.PRE_ORDER_DFS, this.tree, Cond.TRUE, Cond.TRUE, Cond.TRUE, this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> withRoots(@NotNull Iterable<? extends T> roots) {
            return new Meta<T>(roots, this.traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> withTraversal(TreeTraversal traversal) {
            return new Meta<T>(this.roots, traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> expand(@NotNull Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand.append(c), this.regard, this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> regard(@NotNull Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard.append(c), this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> filter(@NotNull Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard, this.filter.append(c), this.forceExpand, this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> forceExpand(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand.append(c), this.forceIgnore, this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> forceIgnore(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand, this.forceIgnore.append(c), this.forceDisregard, this.interceptor, this.original);
        }

        public Meta<T> forceDisregard(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard.append(c), this.interceptor, this.original);
        }

        public Meta<T> interceptTraversal(Function<? super TreeTraversal, ? extends TreeTraversal> interceptor) {
            if (interceptor == Function.ID) {
                return this;
            }
            return new Meta<T>(this.roots, this.traversal, this.tree, this.expand, this.regard, this.filter, this.forceExpand, this.forceIgnore, this.forceDisregard, Functions.compose(this.interceptor, interceptor), this.original);
        }

        JBIterable<T> children(@Nullable T node) {
            return this.childrenImpl(node, this.tree);
        }

        JBIterable<T> childrenImpl(@Nullable T node, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (node == null) {
                return JBIterable.empty();
            }
            if (!(this.expand == Cond.TRUE || this.expand.valueAnd(node) || this.forceExpand != Cond.FALSE && this.forceExpand.valueOr(node))) {
                return JBIterable.empty();
            }
            if (this.regard == Cond.TRUE && this.forceDisregard == Cond.FALSE) {
                return JBIterable.from(tree.fun(node)).filter(Conditions.not(this.forceIgnore.or()));
            }
            return TreeTraversal.GUIDED_TRAVERSAL(this.createChildrenGuide(node)).traversal(node, tree);
        }

        TreeTraversal.GuidedIt.Guide<T> createChildrenGuide(final T parent) {
            return new TreeTraversal.GuidedIt.Guide<T>(){
                final Condition<? super T> expand;
                {
                    this.expand = this.buildExpandConditionForChildren(parent);
                }

                @Override
                public void guide(@NotNull TreeTraversal.GuidedIt<T> guidedIt) {
                    this.doPerformChildrenGuidance(guidedIt, this.expand);
                }
            };
        }

        private void doPerformChildrenGuidance(TreeTraversal.GuidedIt<T> it, Condition<? super T> expand) {
            if (it.curChild == null) {
                return;
            }
            if (this.forceIgnore != Cond.FALSE && this.forceIgnore.valueOr(it.curChild)) {
                return;
            }
            if (it.curParent == null || expand == Conditions.TRUE || expand.value(it.curChild)) {
                it.queueNext(it.curChild);
            } else {
                it.result(it.curChild);
            }
        }

        private Condition<? super T> buildExpandConditionForChildren(T parent) {
            Cond copy = null;
            boolean invert = true;
            Cond<T> c = this.regard;
            while (c != null) {
                Condition impl = JBIterable.Stateful.copy(c.impl);
                if (impl != (invert ? Condition.TRUE : Condition.FALSE)) {
                    copy = new Cond(invert ? Conditions.not(impl) : impl, copy);
                    if (impl instanceof EdgeFilter) {
                        ((EdgeFilter)impl).edgeSource = parent;
                    }
                }
                if (c.next == null) {
                    c = invert ? this.forceDisregard : null;
                    invert = false;
                    continue;
                }
                c = c.next;
            }
            return copy == null ? Conditions.alwaysFalse() : copy.or();
        }
    }

    public static abstract class EdgeFilter<T>
    extends JBIterable.SCond<T> {
        protected T edgeSource;
    }
}

