/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.RefValueHashMap;
import com.intellij.util.containers.SimpleEntry;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class IntKeyWeakValueHashMap<V>
implements IntObjectMap<V> {
    private final TIntObjectHashMap<MyReference<V>> myMap = new TIntObjectHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    IntKeyWeakValueHashMap() {
    }

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            int key = ref.key;
            this.myMap.remove(key);
        }
        return;
    }

    @Override
    public final V get(int key) {
        return (V)SoftReference.dereference((Reference)this.myMap.get(key));
    }

    @Override
    public final V put(int key, @NotNull V value) {
        this.processQueue();
        MyReference ref = new MyReference(key, value, this.myQueue);
        MyReference oldRef = (MyReference)this.myMap.put(key, ref);
        return (V)SoftReference.dereference(oldRef);
    }

    @Override
    public final V remove(int key) {
        this.processQueue();
        MyReference ref = (MyReference)this.myMap.remove(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public final void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public final int size() {
        return this.myMap.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public final boolean containsKey(int key) {
        throw RefValueHashMap.pointlessContainsKey();
    }

    @Override
    @NotNull
    public final Collection<V> values() {
        Object[] refs;
        ArrayList result = new ArrayList();
        for (Object o : refs = this.myMap.getValues()) {
            Object value = ((MyReference)o).get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    @NotNull
    public int[] keys() {
        throw new IncorrectOperationException("keys() makes no sense for weak/soft map because GC can clear the value any moment now");
    }

    @Override
    public boolean containsValue(@NotNull V value) {
        return this.values().contains(value);
    }

    @Override
    @NotNull
    public Set<IntObjectMap.Entry<V>> entrySet() {
        return new MyEntrySetView();
    }

    @NotNull
    private Iterator<IntObjectMap.Entry<V>> entriesIterator() {
        final MovingIterator<V> entryIterator = new MovingIterator<V>(this.myMap);
        return new Iterator<IntObjectMap.Entry<V>>(){
            private IntObjectMap.Entry<V> nextVEntry;
            private int lastReturned;
            {
                this.nextAliveEntry();
            }

            @Override
            public boolean hasNext() {
                return this.nextVEntry != null;
            }

            @Override
            public IntObjectMap.Entry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IntObjectMap.Entry result = this.nextVEntry;
                this.lastReturned = result.getKey();
                this.nextAliveEntry();
                return result;
            }

            private void nextAliveEntry() {
                while (entryIterator.hasNext()) {
                    entryIterator.advance();
                    MyReference ref = (MyReference)entryIterator.value();
                    Object v = ref.get();
                    if (v == null) continue;
                    int key = entryIterator.key();
                    this.nextVEntry = new SimpleEntry(key, v);
                    return;
                }
                this.nextVEntry = null;
            }

            @Override
            public void remove() {
                IntKeyWeakValueHashMap.this.myMap.remove(this.lastReturned);
                entryIterator.removed();
            }
        };
    }

    private static class MovingIterator<V>
    extends TIntObjectIterator<MyReference<V>> {
        MovingIterator(TIntObjectHashMap<MyReference<V>> map) {
            super(map);
        }

        void removed() {
            --this._expectedSize;
        }
    }

    private class MyEntrySetView
    extends AbstractSet<IntObjectMap.Entry<V>> {
        private MyEntrySetView() {
        }

        @Override
        @NotNull
        public Iterator<IntObjectMap.Entry<V>> iterator() {
            return IntKeyWeakValueHashMap.this.entriesIterator();
        }

        @Override
        public int size() {
            return IntKeyWeakValueHashMap.this.size();
        }
    }

    private static class MyReference<T>
    extends WeakReference<T> {
        private final int key;

        private MyReference(int key, @NotNull T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.key = key;
        }
    }
}

