/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.OpenTHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Interner<T> {
    private final OpenTHashSet<T> mySet;

    public Interner() {
        this.mySet = new OpenTHashSet();
    }

    public Interner(@NotNull Collection<? extends T> initialItems) {
        this.mySet = new OpenTHashSet<T>(initialItems);
    }

    public Interner(@NotNull TObjectHashingStrategy<T> strategy) {
        this.mySet = new OpenTHashSet<T>(strategy);
    }

    @NotNull
    public T intern(@NotNull T name) {
        T interned = this.mySet.get(name);
        if (interned != null) {
            return interned;
        }
        boolean added = this.mySet.add(name);
        assert (added);
        return name;
    }

    public void clear() {
        this.mySet.clear();
    }

    @NotNull
    public Set<T> getValues() {
        return this.mySet;
    }
}

