/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.SingletonIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterable<E>
implements Iterable<E> {
    final Object content;
    private static final JBIterable EMPTY = new Empty();

    protected JBIterable() {
        this.content = this;
    }

    JBIterable(@NotNull Object content) {
        this.content = content;
    }

    @NotNull
    public static <E> JBIterable<E> create(final @Nullable Producer<? extends Iterator<E>> producer) {
        if (producer == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                return (Iterator)producer.produce();
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> from(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null || iterable == EMPTY) {
            return JBIterable.empty();
        }
        if (iterable instanceof JBIterable) {
            return (JBIterable)iterable;
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return JBIterable.empty();
        }
        return new Multi<E>(iterable);
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first, final @NotNull Function<? super E, ? extends E> generator) {
        if (first == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Function fun = Stateful.copy(generator);
                return new JBIterator<E>(){
                    E cur;
                    {
                        this.cur = first;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur;
                        if (result == null) {
                            return this.stop();
                        }
                        this.cur = fun.fun(this.cur);
                        return result;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first1, final @Nullable E first2, final @NotNull PairFunction<? super E, ? super E, ? extends E> generator) {
        if (first1 == null) {
            return JBIterable.empty();
        }
        return new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur1;
                    E cur2;
                    {
                        this.cur1 = first1;
                        this.cur2 = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result = this.cur1;
                        this.cur1 = this.cur2;
                        this.cur2 = generator.fun(result, this.cur2);
                        if (result == null) {
                            return this.stop();
                        }
                        return result;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> JBIterable<E> of(@Nullable E element) {
        if (element == null) {
            return JBIterable.empty();
        }
        return new Single(element);
    }

    @NotNull
    public static <E> JBIterable<E> of(E ... elements) {
        return elements == null || elements.length == 0 ? JBIterable.empty() : JBIterable.from(ContainerUtilRt.newArrayList(elements));
    }

    @NotNull
    public static <E> JBIterable<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> JBIterable<E> once(@NotNull Iterator<E> iterator) {
        return JBIterable.of(Ref.create(iterator)).intercept(iterator1 -> {
            Ref ref = (Ref)iterator1.next();
            Iterator result = (Iterator)ref.get();
            if (result == null) {
                throw new UnsupportedOperationException();
            }
            ref.set(null);
            return result;
        });
    }

    @NotNull
    public <T extends Iterator<E>> T typedIterator() {
        return (T)this.iterator();
    }

    public final boolean processEach(@NotNull Processor<? super E> processor) {
        return ContainerUtil.process(this, processor);
    }

    public final void consumeEach(@NotNull Consumer<? super E> consumer) {
        for (Object e : this) {
            consumer.consume(e);
        }
    }

    @NotNull
    public String toString() {
        return this.content == this ? JBIterable.class.getSimpleName() : String.valueOf(this.content);
    }

    public final int size() {
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.size();
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return 1;
        }
        int count = 0;
        for (E ignored : itt) {
            ++count;
        }
        return count;
    }

    public final boolean contains(@Nullable Object element) {
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.contains(element);
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return Comparing.equal(this.content, element);
        }
        for (E e : itt) {
            if (!Comparing.equal(e, element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final E get(int index) {
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return index >= list.size() ? null : (E)list.get(index);
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return (E)(index == 0 ? this.content : null);
        }
        return this.skip(index).first();
    }

    @Nullable
    private List<E> asRandomAccess() {
        return this.content instanceof RandomAccess ? (List)this.content : null;
    }

    @Nullable
    private Collection<E> asCollection() {
        return this.content instanceof Collection ? (Collection)this.content : null;
    }

    @Nullable
    private Iterable<E> asIterable() {
        return this.content instanceof Iterable ? (Iterable)this.content : null;
    }

    @NotNull
    public final JBIterable<E> repeat(int count) {
        Function fun = Functions.identity();
        return JBIterable.generate(this, fun).take(count).flatten(fun);
    }

    @NotNull
    public final JBIterable<E> append(@Nullable Iterable<? extends E> other) {
        if (other == null || other == EMPTY) {
            return this;
        }
        if (this == EMPTY) {
            return JBIterable.from(other);
        }
        Appended parent = this instanceof Appended ? (Appended)this : new Appended(this, null);
        return new Appended<E>(other, parent);
    }

    @NotNull
    public final <T> JBIterable<E> append(@Nullable Iterable<T> other, @NotNull Function<? super T, ? extends Iterable<? extends E>> fun) {
        return other == null ? this : (this == EMPTY ? JBIterable.from(other).flatten(fun) : this.append((T)JBIterable.from(other).flatten(fun)));
    }

    @NotNull
    public final JBIterable<E> append(@NotNull E[] elements) {
        return this == EMPTY ? JBIterable.of(elements) : this.append((E)JBIterable.of(elements));
    }

    @NotNull
    public final JBIterable<E> append(@Nullable E element) {
        return element == null ? this : (this == EMPTY ? JBIterable.of(element) : this.append(JBIterable.of(element)));
    }

    @NotNull
    public final JBIterable<E> filter(@NotNull Condition<? super E> condition) {
        return this.intercept(iterator -> JBIterator.from(iterator).filter(Stateful.copy(condition)));
    }

    @NotNull
    public final <T> JBIterable<T> filter(@NotNull Class<T> type) {
        return this.filter(Conditions.instanceOf(type));
    }

    @NotNull
    public final JBIterable<E> take(int count) {
        return this.intercept(iterator -> JBIterator.from(iterator).take(count));
    }

    @NotNull
    public final JBIterable<E> takeWhile(@NotNull Condition<? super E> condition) {
        return this.intercept(iterator -> JBIterator.from(iterator).takeWhile(Stateful.copy(condition)));
    }

    @NotNull
    public final JBIterable<E> skip(int count) {
        return this.intercept(iterator -> JBIterator.from(iterator).skip(count));
    }

    @NotNull
    public final JBIterable<E> skipWhile(@NotNull Condition<? super E> condition) {
        return this.intercept(iterator -> JBIterator.from(iterator).skipWhile(Stateful.copy(condition)));
    }

    @NotNull
    public final <T> JBIterable<T> map(@NotNull Function<? super E, T> function) {
        return this.intercept(iterator -> JBIterator.from(iterator).map(Stateful.copy(function)));
    }

    @NotNull
    public final <T> JBIterable<T> transform(@NotNull Function<? super E, T> function) {
        return this.map(function);
    }

    @NotNull
    public <T> JBIterable<T> flatten(@NotNull Function<? super E, ? extends Iterable<? extends T>> function) {
        return this.intercept(new FlattenFun(function));
    }

    @NotNull
    public final JBIterable<E> unique() {
        return this.unique(Function.ID);
    }

    @NotNull
    public final JBIterable<E> unique(final @NotNull Function<? super E, ?> identity) {
        return this.filter(new SCond<E>(){
            HashSet<Object> visited;

            @Override
            public boolean value(E e) {
                if (this.visited == null) {
                    this.visited = new HashSet();
                }
                return this.visited.add(identity.fun(e));
            }
        });
    }

    @NotNull
    public final <T, X extends Iterator<E>> JBIterable<T> intercept(@NotNull Function<X, ? extends Iterator<T>> function) {
        if (this == EMPTY) {
            return JBIterable.empty();
        }
        if (this instanceof Intercepted) {
            return new Intercepted(((Intercepted)this).original, Functions.compose(((Intercepted)this).interceptor, function));
        }
        return new Intercepted(this, function);
    }

    @Nullable
    public final E first() {
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return list.isEmpty() ? null : (E)list.get(0);
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return (E)this.content;
        }
        Iterator<E> iterator = itt.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    @Nullable
    public final E single() {
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return list.size() != 1 ? null : (E)list.get(0);
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return (E)this.content;
        }
        Iterator<E> iterator = itt.iterator();
        E first = iterator.hasNext() ? (E)iterator.next() : null;
        return iterator.hasNext() ? null : first;
    }

    @Nullable
    public final E last() {
        List<E> list = this.asRandomAccess();
        if (list != null) {
            return list.isEmpty() ? null : (E)list.get(list.size() - 1);
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return (E)this.content;
        }
        E cur = null;
        for (E e : itt) {
            cur = e;
        }
        return cur;
    }

    public final <T> T reduce(@Nullable T first, @NotNull PairFunction<T, ? super E, T> function) {
        T cur = first;
        for (Object e : this) {
            cur = function.fun(cur, e);
        }
        return cur;
    }

    public final E reduce(@NotNull PairFunction<E, ? super E, E> function) {
        boolean first = true;
        Object cur = null;
        for (Object e : this) {
            if (first) {
                cur = e;
                first = false;
                continue;
            }
            cur = function.fun(cur, e);
        }
        return (E)cur;
    }

    @Nullable
    public final E find(@NotNull Condition<? super E> condition) {
        return this.filter(condition).first();
    }

    public final int indexOf(@NotNull Condition<? super E> condition) {
        int index = 0;
        for (Object e : this) {
            if (condition.value(e)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @NotNull
    public final <T> JBIterable<T> filterMap(@NotNull Function<? super E, T> function) {
        return this.map(function).filter(Conditions.notNull());
    }

    @NotNull
    public final <T> JBIterable<T> flatMap(Function<? super E, ? extends Iterable<? extends T>> function) {
        return this.map(function).flatten(Function.ID);
    }

    @NotNull
    public final JBIterable<E> join(final @Nullable E separator) {
        return this.intercept(iterator -> {
            final Iterator original = iterator;
            return new JBIterator<E>(){
                boolean flag;

                @Override
                protected E nextImpl() {
                    if (!original.hasNext()) {
                        return this.stop();
                    }
                    this.flag = !this.flag;
                    return this.flag ? original.next() : separator;
                }
            };
        });
    }

    @NotNull
    public final JBIterable<List<E>> split(int size, boolean strict) {
        return this.split(size).filterMap(es -> {
            List list = es.addAllTo(ContainerUtilRt.newArrayListWithCapacity(size));
            return strict && list.size() < size ? null : list;
        });
    }

    @NotNull
    public final JBIterable<JBIterable<E>> split(final int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(size + " <= 0");
        }
        return this.intercept(iterator -> {
            final Iterator orig = iterator;
            return new JBIterator<JBIterable<E>>(){
                JBIterator it;

                @Override
                protected JBIterable<E> nextImpl() {
                    JBIterable jBIterable;
                    while (this.it != null && this.it.advance()) {
                    }
                    this.it = null;
                    if (orig.hasNext()) {
                        this.it = JBIterator.wrap(orig);
                        jBIterable = JBIterable.once(this.it.take(size));
                    } else {
                        jBIterable = (JBIterable)this.stop();
                    }
                    return jBIterable;
                }
            };
        });
    }

    @NotNull
    public final JBIterable<JBIterable<E>> split(final Split mode, Condition<? super E> separator) {
        return this.intercept(iterator -> {
            final Iterator orig = iterator;
            final Condition condition = Stateful.copy(separator);
            return new JBIterator<JBIterable<E>>(){
                int st;
                JBIterator it;
                Object stored;

                @Override
                protected JBIterable<E> nextImpl() {
                    while (this.it != null && this.it.advance()) {
                    }
                    this.it = null;
                    if (this.stored == null && !orig.hasNext()) {
                        if (this.st < 0 && mode != Split.BEFORE && mode != Split.GROUP) {
                            this.st = 1;
                            return JBIterable.empty();
                        }
                        return (JBIterable)this.stop();
                    }
                    if (this.st == -2 && mode == Split.AROUND) {
                        this.st = -1;
                        return JBIterable.empty();
                    }
                    Object tmp = this.stored;
                    this.stored = null;
                    this.it = JBIterator.wrap(orig);
                    return JBIterable.of(tmp).append(JBIterable.once(this.it.takeWhile(e -> {
                        boolean result;
                        boolean sep = condition.value(e);
                        int st0 = this.st;
                        this.st = st0 < 0 && sep ? -2 : (st0 > 0 && !sep ? 2 : (sep ? -1 : 1));
                        switch (mode) {
                            case AFTER: {
                                result = this.st != -2 && (this.st != 1 || st0 == 0);
                                break;
                            }
                            case BEFORE: {
                                result = this.st != -2 && this.st != -1;
                                break;
                            }
                            case AROUND: {
                                result = st0 >= 0 && this.st > 0;
                                break;
                            }
                            case GROUP: {
                                result = st0 >= 0 && this.st > 0 || st0 <= 0 && this.st < 0;
                                break;
                            }
                            case OFF: {
                                result = this.st > 0;
                                break;
                            }
                            default: {
                                throw new AssertionError(this.st);
                            }
                        }
                        this.stored = !result && mode != Split.OFF ? e : null;
                        return result;
                    })));
                }
            };
        });
    }

    public final boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.isEmpty();
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return false;
        }
        return !itt.iterator().hasNext();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @NotNull
    public final JBIterable<E> collect(@NotNull Collection<E> collection) {
        return JBIterable.from(this.addAllTo(collection));
    }

    @NotNull
    public final JBIterable<E> collect() {
        if (this.content instanceof Collection) {
            return this;
        }
        return this.collect(ContainerUtilRt.newArrayList());
    }

    @NotNull
    public final JBIterable<E> sort(@NotNull Comparator<? super E> comparator) {
        ArrayList list = this.addAllTo(ContainerUtilRt.newArrayList());
        list.sort(comparator);
        return JBIterable.from(list);
    }

    @Deprecated
    @NotNull
    public final JBIterable<E> sorted(@NotNull Comparator<? super E> comparator) {
        return this.sort(comparator);
    }

    @NotNull
    public final List<E> toList() {
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return Collections.singletonList(this.content);
        }
        return Collections.unmodifiableList(ContainerUtilRt.newArrayList(itt));
    }

    @NotNull
    public final Set<E> toSet() {
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return Collections.singleton(this.content);
        }
        return Collections.unmodifiableSet(ContainerUtilRt.newLinkedHashSet(itt));
    }

    @NotNull
    public final E[] toArray(@NotNull E[] array) {
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return Collections.singletonList(this.content).toArray(array);
        }
        return ContainerUtilRt.newArrayList(itt).toArray(array);
    }

    @NotNull
    public final <K, V> Map<K, V> toMap(@NotNull Convertor<E, K> toKey, @NotNull Convertor<E, V> toValue) {
        LinkedHashMap<K, V> map = ContainerUtil.newLinkedHashMap();
        for (Object e : this) {
            map.put(toKey.convert(e), toValue.convert(e));
        }
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
    }

    @NotNull
    public final <V> Map<E, V> toMap(Convertor<E, V> toValue) {
        return this.toMap(Convertor.SELF, toValue);
    }

    @NotNull
    public final <K> Map<K, E> toReverseMap(Convertor<E, K> toKey) {
        return this.toMap(toKey, Convertor.SELF);
    }

    @NotNull
    public final <C extends Collection<? super E>> C addAllTo(@NotNull C collection) {
        Collection<E> col = this.asCollection();
        if (col != null) {
            collection.addAll(col);
        } else {
            Iterable<E> itt = this.asIterable();
            if (itt == null) {
                collection.add((Object)this.content);
            } else {
                for (E item : itt) {
                    collection.add(item);
                }
            }
        }
        return collection;
    }

    public static abstract class SFun<S, T>
    extends Stateful<SFun>
    implements Function<S, T> {
    }

    public static abstract class SCond<T>
    extends Stateful<SCond>
    implements Condition<T> {
    }

    public static abstract class Stateful<Self extends Stateful>
    implements Cloneable {
        @NotNull
        static <T> T copy(@NotNull T o) {
            if (!(o instanceof Stateful)) {
                return o;
            }
            return (T)((Stateful)o).clone();
        }

        public Self clone() {
            try {
                return (Self)((Stateful)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static enum Split {
        AFTER,
        BEFORE,
        AROUND,
        OFF,
        GROUP;

    }

    private static final class Intercepted<E, T, X>
    extends JBIterable<T> {
        final JBIterable<E> original;
        private final Function<? super X, ? extends Iterator<T>> interceptor;

        Intercepted(@NotNull JBIterable<E> original, Function<? super X, ? extends Iterator<T>> interceptor) {
            this.original = original;
            this.interceptor = interceptor;
        }

        @Override
        public Iterator<T> iterator() {
            return this.interceptor.fun(this.original.iterator());
        }
    }

    private static final class FlattenFun<E, T>
    implements Function<Iterator<E>, Iterator<T>> {
        final Function<? super E, ? extends Iterable<? extends T>> function;

        FlattenFun(Function<? super E, ? extends Iterable<? extends T>> function) {
            this.function = function;
        }

        @Override
        public Iterator<T> fun(Iterator<E> iterator) {
            return new FlattenIt(iterator, Stateful.copy(this.function));
        }

        static final class FlattenIt<E, T>
        extends JBIterator<T> {
            final Iterator<? extends E> original;
            final Function<? super E, ? extends Iterable<? extends T>> function;
            Iterator<? extends T> cur;

            FlattenIt(Iterator<? extends E> iterator, Function<? super E, ? extends Iterable<? extends T>> fun) {
                this.original = iterator;
                this.function = fun;
            }

            @Override
            public T nextImpl() {
                if (this.cur != null && this.cur.hasNext()) {
                    return this.cur.next();
                }
                if (!this.original.hasNext()) {
                    return (T)this.stop();
                }
                Iterable<T> next = this.function.fun(this.original.next());
                this.cur = next == null ? null : next.iterator();
                return (T)this.skip();
            }
        }
    }

    private static final class Appended<E>
    extends JBIterable<E> {
        final Iterable<? extends E> iterable;
        final Appended<E> parent;

        Appended(@NotNull Iterable<? extends E> iterable, @Nullable Appended<E> parent) {
            this.iterable = iterable;
            this.parent = parent;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return new FlattenFun.FlattenIt(Arrays.asList(this.getIterables()).iterator(), Functions.identity());
        }

        @NotNull
        Iterable[] getIterables() {
            int size = 0;
            Appended<E> p = this;
            while (p != null) {
                ++size;
                p = p.parent;
            }
            Iterable[] iterables = new Iterable[size];
            int i = 0;
            Appended<E> p2 = this;
            while (p2 != null) {
                iterables[size - ++i] = p2.iterable;
                p2 = p2.parent;
            }
            return iterables;
        }
    }

    private static final class Empty
    extends JBIterable {
        private Empty() {
        }

        @Override
        public Iterator iterator() {
            return EmptyIterator.getInstance();
        }
    }

    private static final class Single<E>
    extends JBIterable<E> {
        Single(@NotNull Object content) {
            super(content);
        }

        @Override
        public Iterator<E> iterator() {
            return new SingletonIterator<Object>(this.content);
        }
    }

    private static final class Multi<E>
    extends JBIterable<E> {
        Multi(Iterable<? extends E> iterable) {
            super(iterable);
        }

        @Override
        public Iterator<E> iterator() {
            return JBIterator.from(((Iterable)this.content).iterator());
        }
    }
}

